/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.utils.SessionVars;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public abstract class GuiBuildCraft
extends GuiContainer {
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileEntity tile;

    public GuiBuildCraft(BuildCraftContainer container, IInventory inventory) {
        super((Container)container);
        if (inventory instanceof TileEntity) {
            this.tile = (TileEntity)inventory;
        }
        this.initLedgers(inventory);
    }

    protected void initLedgers(IInventory inventory) {
    }

    protected void func_74189_g(int par1, int par2) {
        this.ledgerManager.drawLedgers(par1, par2);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        this.ledgerManager.handleMouseClicked(par1, par2, mouseButton);
    }

    protected abstract class Ledger {
        private boolean open;
        protected int overlayColor = 0xFFFFFF;
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;

        protected Ledger() {
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y) {
            float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            ((GuiBuildCraft)GuiBuildCraft.this).field_73882_e.field_71446_o.func_98187_b(DefaultProps.TEXTURE_PATH_GUI + "/ledger.png");
            GuiBuildCraft.this.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiBuildCraft.this.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiBuildCraft.this.func_73729_b(x, y, 0, 0, 4, 4);
            GuiBuildCraft.this.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(Icon icon, int x, int y) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBuildCraft.this.func_94065_a(x, y, icon, 16, 16);
        }
    }

    protected class LedgerManager {
        private GuiBuildCraft gui;
        protected ArrayList ledgers = new ArrayList();

        public LedgerManager(GuiBuildCraft gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + this.gui.field_74194_b;
            int yShift = (this.gui.field_73881_g - this.gui.field_74195_c) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = (Ledger)this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiBuildCraft.this.field_74194_b, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + 12;
                int startY = mouseY - (this.gui.field_73881_g - this.gui.field_74195_c) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiBuildCraft.this.field_73886_k.func_78256_a(tooltip);
                GuiBuildCraft.this.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiBuildCraft.this.field_73886_k.func_78261_a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }
}

