/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IBox;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public abstract class FillerPattern
implements IFillerPattern {
    protected int id;

    @Override
    public abstract boolean iteratePattern(TileEntity var1, IBox var2, ItemStack var3);

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract Icon getTexture();

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean fill(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, ItemStack stackToPlace, World world) {
        boolean found = false;
        int xSlot = 0;
        int ySlot = 0;
        int zSlot = 0;
        for (int y = yMin; y <= yMax && !found; ++y) {
            for (int x = xMin; x <= xMax && !found; ++x) {
                for (int z = zMin; z <= zMax && !found; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y, z)) {
                        return false;
                    }
                    if (!BlockUtil.isSoftBlock(world, x, y, z)) continue;
                    xSlot = x;
                    ySlot = y;
                    zSlot = z;
                    found = true;
                }
            }
        }
        if (found && stackToPlace != null) {
            BlockUtil.breakBlock(world, xSlot, ySlot, zSlot);
            stackToPlace.func_77973_b().func_77648_a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(world), world, xSlot, ySlot - 1, zSlot, 1, 0.0f, 0.0f, 0.0f);
        }
        return found;
    }

    public boolean empty(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, World world) {
        boolean found = false;
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y = yMax; y >= yMin; --y) {
            found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y, z)) {
                        return false;
                    }
                    if (BlockUtil.isSoftBlock(world, x, y, z)) continue;
                    found = true;
                    lastX = x;
                    lastY = y;
                    lastZ = z;
                }
            }
            if (found) break;
        }
        if (lastX != Integer.MAX_VALUE) {
            if (BuildCraftBuilders.fillerDestroy) {
                world.func_94575_c(lastX, lastY, lastZ, 0);
            } else {
                BlockUtil.breakBlock(world, lastX, lastY, lastZ, 20);
            }
            return true;
        }
        return false;
    }
}

