/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IGuiIDHandlerProvider;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.IItemTextureRenderSlot;
import logisticspipes.utils.gui.IRenderSlot;
import logisticspipes.utils.gui.ISmallColorRenderSlot;
import logisticspipes.utils.gui.ISubGuiControler;
import logisticspipes.utils.gui.SubGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class KraphtBaseGuiScreen
extends GuiContainer
implements IGuiIDHandlerProvider,
ISubGuiControler {
    protected int right;
    protected int bottom;
    protected int xCenter;
    protected int yCenter;
    protected final int xCenterOffset;
    protected final int yCenterOffset;
    private SubGuiScreen subGui;
    private List slots = new ArrayList();

    public KraphtBaseGuiScreen(int xSize, int ySize, int xCenterOffset, int yCenterOffset) {
        this(new DummyContainer(null, null), xSize, ySize, xCenterOffset, yCenterOffset);
    }

    public KraphtBaseGuiScreen(Container container) {
        super(container);
        this.xCenterOffset = 0;
        this.yCenterOffset = 0;
    }

    public KraphtBaseGuiScreen(Container container, int xSize, int ySize, int xCenterOffset, int yCenterOffset) {
        super(container);
        this.field_74194_b = xSize;
        this.field_74195_c = ySize;
        this.xCenterOffset = xCenterOffset;
        this.yCenterOffset = yCenterOffset;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_74198_m = this.field_73880_f / 2 - this.field_74194_b / 2 + this.xCenterOffset;
        this.field_74197_n = this.field_73881_g / 2 - this.field_74195_c / 2 + this.yCenterOffset;
        this.right = this.field_73880_f / 2 + this.field_74194_b / 2 + this.xCenterOffset;
        this.bottom = this.field_73881_g / 2 + this.field_74195_c / 2 + this.yCenterOffset;
        this.xCenter = (this.right + this.field_74198_m) / 2;
        this.yCenter = (this.bottom + this.field_74197_n) / 2;
    }

    @Override
    public boolean hasSubGui() {
        return this.subGui != null;
    }

    @Override
    public SubGuiScreen getSubGui() {
        return this.subGui;
    }

    @Override
    public void setSubGui(SubGuiScreen gui) {
        if (this.subGui == null) {
            this.subGui = gui;
            this.subGui.func_73872_a(this.field_73882_e, this.field_73880_f, this.field_73881_g);
            this.subGui.register(this);
            this.subGui.func_73866_w_();
        }
    }

    public void func_73872_a(Minecraft mc, int width, int height) {
        super.func_73872_a(mc, width, height);
        if (this.subGui != null) {
            this.subGui.func_73872_a(mc, width, height);
        }
    }

    @Override
    public void resetSubGui() {
        this.subGui = null;
    }

    public void func_73873_v_() {
        if (this.subGui == null) {
            super.func_73873_v_();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (this.subGui != null) {
            block9: {
                Field fY;
                Field fX;
                int y;
                int x;
                block8: {
                    x = Mouse.getX();
                    y = Mouse.getY();
                    try {
                        fX = Mouse.class.getDeclaredField("x");
                        fY = Mouse.class.getDeclaredField("y");
                        fX.setAccessible(true);
                        fY.setAccessible(true);
                        fX.set(null, 0);
                        fY.set(null, 0);
                    }
                    catch (Exception e) {
                        if (!LogisticsPipes.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
                super.func_73863_a(0, 0, par3);
                try {
                    fX = Mouse.class.getDeclaredField("x");
                    fY = Mouse.class.getDeclaredField("y");
                    fX.setAccessible(true);
                    fY.setAccessible(true);
                    fX.set(null, x);
                    fY.set(null, y);
                }
                catch (Exception e) {
                    if (!LogisticsPipes.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            RenderHelper.func_74518_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)101.0f);
            if (!this.subGui.hasSubGui()) {
                GL11.glDisable((int)2929);
                super.func_73873_v_();
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)2929);
            this.subGui.func_73863_a(par1, par2, par3);
            GL11.glEnable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-101.0f);
            RenderHelper.func_74519_b();
        } else {
            super.func_73863_a(par1, par2, par3);
            RenderHelper.func_74518_a();
            for (IRenderSlot slot : this.slots) {
                int mouseX = par1 - this.field_74198_m;
                int mouseY = par2 - this.field_74197_n;
                int mouseXMax = mouseX - slot.getSize();
                int mouseYMax = mouseY - slot.getSize();
                if (slot.getXPos() >= mouseX || slot.getXPos() <= mouseXMax || slot.getYPos() >= mouseY || slot.getYPos() <= mouseYMax || !slot.displayToolTip() || slot.getToolTipText() == null || slot.getToolTipText().equals("")) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(slot.getToolTipText());
                BasicGuiHelper.drawToolTip(par1, par2, list, 15, false);
            }
            RenderHelper.func_74519_b();
        }
    }

    public final void func_73867_d() {
        if (this.subGui != null) {
            this.subGui.func_73867_d();
        } else {
            this.handleMouseInputSub();
        }
    }

    public void handleMouseInputSub() {
        super.func_73867_d();
    }

    public final void func_73860_n() {
        if (this.subGui != null) {
            this.subGui.func_73860_n();
        } else {
            this.handleKeyboardInputSub();
        }
    }

    public void handleKeyboardInputSub() {
        super.func_73860_n();
    }

    public void addRenderSlot(IRenderSlot slot) {
        this.slots.add(slot);
    }

    protected void func_74189_g(int par1, int par2) {
        for (IRenderSlot slot : this.slots) {
            if (slot instanceof IItemTextureRenderSlot) {
                if (slot.drawSlotBackground()) {
                    BasicGuiHelper.drawSlotBackground(this.field_73882_e, slot.getXPos(), slot.getYPos());
                }
                if (!((IItemTextureRenderSlot)slot).drawSlotIcon() || ((IItemTextureRenderSlot)slot).customRender(this.field_73882_e, this.field_73735_i)) continue;
                BasicGuiHelper.renderIconAt(this.field_73882_e, slot.getXPos() + 1, slot.getYPos() + 1, this.field_73735_i, ((IItemTextureRenderSlot)slot).getTextureIcon());
                continue;
            }
            if (!(slot instanceof ISmallColorRenderSlot)) continue;
            if (slot.drawSlotBackground()) {
                BasicGuiHelper.drawSmallSlotBackground(this.field_73882_e, slot.getXPos(), slot.getYPos());
            }
            if (!((ISmallColorRenderSlot)slot).drawColor()) continue;
            KraphtBaseGuiScreen.func_73734_a((int)(slot.getXPos() + 1), (int)(slot.getYPos() + 1), (int)(slot.getXPos() + 7), (int)(slot.getYPos() + 7), (int)((ISmallColorRenderSlot)slot).getColor());
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        for (IRenderSlot slot : this.slots) {
            int mouseX = par1 - this.field_74198_m;
            int mouseY = par2 - this.field_74197_n;
            int mouseXMax = mouseX - slot.getSize();
            int mouseYMax = mouseY - slot.getSize();
            if (slot.getXPos() >= mouseX || slot.getXPos() <= mouseXMax || slot.getYPos() >= mouseY || slot.getYPos() <= mouseYMax) continue;
            slot.mouseClicked(par3);
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    public void drawPoint(int x, int y, int color) {
        KraphtBaseGuiScreen.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)color);
    }

    public void drawPoint(int x, int y, Colors color) {
        KraphtBaseGuiScreen.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)BasicGuiHelper.ConvertEnumToColor(color));
    }

    public void drawRect(int x1, int y1, int x2, int y2, Colors color) {
        KraphtBaseGuiScreen.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)BasicGuiHelper.ConvertEnumToColor(color));
    }

    public void drawLine(int x1, int y1, int x2, int y2, Colors color) {
        int lasty = y1;
        int dx = 0;
        while (x1 + dx < x2) {
            int plotx = x1 + dx;
            int ploty = y1 + (y2 - y1) / (x2 - x1 - 1) * dx;
            this.drawPoint(plotx, ploty, color);
            while (lasty < ploty) {
                this.drawPoint(plotx, ++lasty, color);
            }
            while (lasty > ploty) {
                this.drawPoint(plotx, --lasty, color);
            }
            ++dx;
        }
        while (lasty < y2) {
            this.drawPoint(x2, ++lasty, color);
        }
        while (lasty > y2) {
            this.drawPoint(x2, --lasty, color);
        }
    }

    public void closeGui() {
        this.func_73869_a(' ', 1);
    }

    public static enum Colors {
        White,
        Black,
        LightGrey,
        MiddleGrey,
        DarkGrey,
        Red;

    }
}

