/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.TransactorForgeSided;
import buildcraft.core.inventory.TransactorSimple;
import buildcraft.core.inventory.TransactorSpecial;
import buildcraft.core.inventory.TransactorVanillaSided;
import buildcraft.core.utils.Utils;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.InventoryLargeChestLogistics;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class InventoryHelper {
    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            Position pos = new Position((double)chest.field_70329_l, (double)chest.field_70330_m, (double)chest.field_70327_n);
            TileEntity tile = Utils.getTile((World)chest.field_70331_k, (Position)pos, (ForgeDirection)ForgeDirection.WEST);
            if (tile instanceof TileEntityChest) {
                return new InventoryLargeChestLogistics("", (IInventory)tile, inv);
            }
            tile = Utils.getTile((World)chest.field_70331_k, (Position)pos, (ForgeDirection)ForgeDirection.EAST);
            if (tile instanceof TileEntityChest) {
                return new InventoryLargeChestLogistics("", inv, (IInventory)tile);
            }
            tile = Utils.getTile((World)chest.field_70331_k, (Position)pos, (ForgeDirection)ForgeDirection.NORTH);
            if (tile instanceof TileEntityChest) {
                return new InventoryLargeChestLogistics("", (IInventory)tile, inv);
            }
            tile = Utils.getTile((World)chest.field_70331_k, (Position)pos, (ForgeDirection)ForgeDirection.SOUTH);
            if (tile instanceof TileEntityChest) {
                return new InventoryLargeChestLogistics("", inv, (IInventory)tile);
            }
        }
        return inv;
    }

    public static ITransactor getTransactorFor(Object object) {
        SpecialInventoryHandler t;
        if (object instanceof IInventory && (t = SimpleServiceLocator.inventoryUtilFactory.getUtilForInv((IInventory)object, false, false, 0, 0)) != null) {
            return t;
        }
        if (object instanceof ISpecialInventory) {
            return new TransactorSpecial((ISpecialInventory)object);
        }
        if (object instanceof net.minecraft.inventory.ISidedInventory) {
            return new TransactorVanillaSided((net.minecraft.inventory.ISidedInventory)object);
        }
        if (object instanceof ISidedInventory) {
            return new TransactorForgeSided((ISidedInventory)object);
        }
        if (object instanceof IInventory) {
            return new TransactorSimple(InventoryHelper.getInventory((IInventory)object));
        }
        return null;
    }
}

