/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.transport.EntityData;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.LiquidIdentifier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class WorldTickHandler
implements ITickHandler {
    public static LinkedList clientPipesToReplace = new LinkedList();
    public static LinkedList serverPipesToReplace = new LinkedList();
    private Field entitiesToLoad = null;
    private Field delayedEntitiesToLoad = null;

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        LinkedList localList;
        if (type.contains(TickType.CLIENT)) {
            localList = clientPipesToReplace;
        } else if (type.contains(TickType.SERVER)) {
            localList = serverPipesToReplace;
        } else {
            System.out.println("not client, not server ... what is " + type);
            return;
        }
        if (this.entitiesToLoad == null || this.delayedEntitiesToLoad == null) {
            try {
                this.entitiesToLoad = PipeTransportItems.class.getDeclaredField("entitiesToLoad");
                this.entitiesToLoad.setAccessible(true);
                this.delayedEntitiesToLoad = PipeTransportItems.class.getDeclaredField("delayedEntitiesToLoad");
                this.delayedEntitiesToLoad.setAccessible(true);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        while (localList.size() > 0) {
            try {
                TileGenericPipe tile = (TileGenericPipe)localList.get(0);
                int x = tile.field_70329_l;
                int y = tile.field_70330_m;
                int z = tile.field_70327_n;
                World world = tile.field_70331_k;
                TileEntity tilecheck = world.func_72796_p(x, y, z);
                if (tilecheck != tile) {
                    localList.remove(0);
                    continue;
                }
                TileGenericPipe newTile = (TileGenericPipe)BuildCraftProxy.logisticsTileGenericPipe.newInstance();
                for (Field field : tile.getClass().getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        field.set(newTile, field.get(tile));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                tile.pipe = null;
                world.func_72837_a(x, y, z, (TileEntity)newTile);
                if (newTile.pipe != null) {
                    newTile.pipe.setTile((TileEntity)newTile);
                    if (newTile.pipe.transport instanceof PipeTransportItems) {
                        for (EntityData entity : ((PipeTransportItems)newTile.pipe.transport).travelingEntities.values()) {
                            entity.item.setContainer((TileEntity)newTile);
                        }
                        for (EntityData entity : (List)this.entitiesToLoad.get(newTile.pipe.transport)) {
                            entity.item.setContainer((TileEntity)newTile);
                        }
                        for (EntityData entity : (List)this.delayedEntitiesToLoad.get(newTile.pipe.transport)) {
                            entity.item.setContainer((TileEntity)newTile);
                        }
                    }
                }
                for (Field field : ForgeDirection.VALID_DIRECTIONS) {
                    Position pos = new Position((double)newTile.field_70329_l, (double)newTile.field_70330_m, (double)newTile.field_70327_n, (ForgeDirection)field);
                    pos.moveForwards(1.0);
                    newTile.tileBuffer[field.ordinal()] = new TileBuffer();
                    newTile.tileBuffer[field.ordinal()].initialize(newTile.field_70331_k, (int)pos.x, (int)pos.y, (int)pos.z);
                }
                for (Field field : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tileSide = newTile.getTile((ForgeDirection)field);
                    if (!(tileSide instanceof ITileBufferHolder)) continue;
                    ((ITileBufferHolder)tileSide).blockCreated((ForgeDirection)field, BuildCraftTransport.genericPipeBlock.field_71990_ca, (TileEntity)newTile);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            localList.remove(0);
        }
        ItemIdentifier.tick();
        LiquidIdentifier.initFromForge(true);
        if (type.contains(TickType.SERVER)) {
            HudUpdateTick.tick();
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.SERVER);
    }

    public String getLabel() {
        return "LogisticsPipes WorldTick";
    }
}

