/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.ClientPacketHandler;
import logisticspipes.network.packets.PacketBufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Pair;
import net.minecraft.network.packet.Packet250CustomPayload;

public class ClientPacketBufferHandlerThread {
    private final ClientCompressorThread clientCompressorThread = new ClientCompressorThread();
    private final ClientDecompressorThread clientDecompressorThread = new ClientDecompressorThread();

    public void setPause(boolean flag) {
        this.clientCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(Packet250CustomPayload packet) {
        this.clientCompressorThread.addPacketToCompressor(packet);
    }

    public void handlePacket(PacketBufferTransfer packet) {
        this.clientDecompressorThread.handlePacket(packet);
    }

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            int buffer = 0;
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private class ClientDecompressorThread
    extends Thread {
        private final LinkedList queue;
        private byte[] ByteBuffer;
        private final LinkedList PacketBuffer;

        public ClientDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Client");
            this.queue = new LinkedList();
            this.ByteBuffer = new byte[0];
            this.PacketBuffer = new LinkedList();
            this.setDaemon(true);
            this.start();
            TickRegistry.registerTickHandler((ITickHandler)new ITickHandler(){

                public EnumSet ticks() {
                    return EnumSet.of(TickType.CLIENT);
                }

                public void tickStart(EnumSet type, Object ... tickData) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void tickEnd(EnumSet type, Object ... tickData) {
                    boolean flag = false;
                    do {
                        flag = false;
                        Pair part = null;
                        LinkedList linkedList = ClientDecompressorThread.this.PacketBuffer;
                        synchronized (linkedList) {
                            if (ClientDecompressorThread.this.PacketBuffer.size() > 0) {
                                flag = true;
                                part = (Pair)ClientDecompressorThread.this.PacketBuffer.pop();
                            }
                        }
                        if (!flag) continue;
                        ClientPacketHandler.onPacketData(new DataInputStream(new ByteArrayInputStream((byte[])part.getValue2())), (Player)part.getValue1());
                    } while (flag);
                }

                public String getLabel() {
                    return "LogisticsPipes Packet Compressor Tick Client";
                }
            }, (Side)Side.CLIENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int size;
                boolean flag = false;
                do {
                    flag = false;
                    byte[] buffer = null;
                    LinkedList linkedList = this.queue;
                    synchronized (linkedList) {
                        if (this.queue.size() > 0) {
                            flag = true;
                            buffer = (byte[])this.queue.getFirst();
                            this.queue.removeFirst();
                        }
                    }
                    if (!flag || buffer == null) continue;
                    byte[] packetbytes = ClientPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + this.ByteBuffer.length];
                    System.arraycopy(this.ByteBuffer, 0, newBuffer, 0, this.ByteBuffer.length);
                    System.arraycopy(packetbytes, 0, newBuffer, this.ByteBuffer.length, packetbytes.length);
                    this.ByteBuffer = newBuffer;
                } while (flag);
                while (this.ByteBuffer.length >= 4 && (size = ((this.ByteBuffer[0] & 0xFF) << 24) + ((this.ByteBuffer[1] & 0xFF) << 16) + ((this.ByteBuffer[2] & 0xFF) << 8) + ((this.ByteBuffer[3] & 0xFF) << 0)) + 4 <= this.ByteBuffer.length) {
                    byte[] packet = Arrays.copyOfRange(this.ByteBuffer, 4, size + 4);
                    this.ByteBuffer = Arrays.copyOfRange(this.ByteBuffer, size + 4, this.ByteBuffer.length);
                    LinkedList linkedList = this.PacketBuffer;
                    synchronized (linkedList) {
                        this.PacketBuffer.add(new Pair((Player)MainProxy.proxy.getClientPlayer(), packet));
                    }
                }
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(PacketBufferTransfer packet) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(packet.content);
                this.queue.notify();
            }
        }
    }

    private class ClientCompressorThread
    extends Thread {
        private final LinkedList clientList;
        private byte[] clientBuffer;
        private boolean pause;

        public ClientCompressorThread() {
            super("LogisticsPipes Packet Compressor Client");
            this.clientList = new LinkedList();
            this.clientBuffer = new byte[0];
            this.pause = false;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList linkedList;
                try {
                    linkedList = this.clientList;
                    synchronized (linkedList) {
                        if (!this.pause && this.clientList.size() > 0) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            DataOutputStream data = new DataOutputStream(out);
                            data.write(this.clientBuffer);
                            LinkedList packets = this.clientList;
                            for (Packet250CustomPayload packet : packets) {
                                data.writeInt(packet.field_73629_c.length);
                                data.write(packet.field_73629_c);
                            }
                            packets.clear();
                            this.clientBuffer = out.toByteArray();
                        }
                    }
                    if (this.clientBuffer.length > 0) {
                        byte[] compressed;
                        byte[] sendbuffer;
                        while (this.clientBuffer.length > 32768) {
                            sendbuffer = Arrays.copyOf(this.clientBuffer, 32768);
                            this.clientBuffer = Arrays.copyOfRange(this.clientBuffer, 32768, this.clientBuffer.length);
                            compressed = ClientPacketBufferHandlerThread.compress(sendbuffer);
                            MainProxy.sendPacketToServer(new PacketBufferTransfer(compressed).getPacket());
                        }
                        sendbuffer = this.clientBuffer;
                        this.clientBuffer = new byte[0];
                        compressed = ClientPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToServer(new PacketBufferTransfer(compressed).getPacket());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                linkedList = this.clientList;
                synchronized (linkedList) {
                    while (this.pause || this.clientList.size() == 0) {
                        try {
                            this.clientList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(Packet250CustomPayload packet) {
            if (packet.field_73630_a.equals("BCLP")) {
                LinkedList linkedList = this.clientList;
                synchronized (linkedList) {
                    this.clientList.add(packet);
                    if (!this.pause) {
                        this.clientList.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            LinkedList linkedList = this.clientList;
            synchronized (linkedList) {
                this.pause = flag;
                if (!this.pause) {
                    this.clientList.notify();
                }
            }
        }
    }
}

