/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.transport.TileGenericPipe;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.pipes.PipeItemsBasicLogistics;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PathFinder;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.RouteLaser;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class ServerRouter
implements IRouter,
Comparable {
    static HashMap _globalSpecificInterests = new HashMap();
    static Set _genericInterests = new TreeSet();
    Set _hasInterestIn = new TreeSet();
    boolean _hasGenericInterest;
    static final int REFRESH_TIME = 20;
    static int iterated = 0;
    int ticksUntillNextInventoryCheck = 0;
    public Map _adjacent = new HashMap();
    public Map _adjacentRouter = new HashMap();
    public List _powerAdjacent = new ArrayList();
    public boolean[] sideDisconnected = new boolean[6];
    protected Map _prevAdjacentRouter = new HashMap();
    protected static int[] _lastLSAVersion = new int[0];
    protected int _LSAVersion = 0;
    protected LSA _myLsa = new LSA();
    protected UpdateRouterRunnable updateThread = null;
    protected static RouteLaser _laser = new RouteLaser();
    protected static final ReentrantReadWriteLock SharedLSADatabaseLock = new ReentrantReadWriteLock();
    protected static final Lock SharedLSADatabasereadLock = SharedLSADatabaseLock.readLock();
    protected static final Lock SharedLSADatabasewriteLock = SharedLSADatabaseLock.writeLock();
    protected final ReentrantReadWriteLock routingTableUpdateLock = new ReentrantReadWriteLock();
    protected final Lock routingTableUpdateReadLock = this.routingTableUpdateLock.readLock();
    protected final Lock routingTableUpdateWriteLock = this.routingTableUpdateLock.writeLock();
    public Object _externalRoutersByCostLock = new Object();
    protected static LSA[] SharedLSADatabase = new LSA[0];
    public ArrayList _routeTable = new ArrayList();
    public List _routeCosts = new ArrayList();
    public List _powerTable = new ArrayList();
    public List _firewallRouter = new ArrayList();
    public List _externalRoutersByCost = null;
    private EnumSet _routedExits = EnumSet.noneOf(ForgeDirection.class);
    private static int firstFreeId = 1;
    private static BitSet simpleIdUsedSet = new BitSet();
    protected final int simpleID;
    public final UUID id;
    private int _dimension;
    private final int _xCoord;
    private final int _yCoord;
    private final int _zCoord;
    private WeakReference _myPipeCache = null;

    public int hashCode() {
        return this.simpleID;
    }

    @Override
    public void clearPipeCache() {
        this._myPipeCache = null;
    }

    public static void cleanup() {
        _globalSpecificInterests.clear();
        _genericInterests.clear();
        SharedLSADatabasewriteLock.lock();
        SharedLSADatabase = new LSA[0];
        _lastLSAVersion = new int[0];
        SharedLSADatabasewriteLock.unlock();
        _laser = new RouteLaser();
        simpleIdUsedSet.clear();
        firstFreeId = 1;
    }

    private static int claimSimpleID() {
        int idx = simpleIdUsedSet.nextClearBit(firstFreeId);
        firstFreeId = idx + 1;
        simpleIdUsedSet.set(idx);
        return idx;
    }

    private static void releaseSimpleID(int idx) {
        simpleIdUsedSet.clear(idx);
        if (idx < firstFreeId) {
            firstFreeId = idx;
        }
    }

    public static int getBiggestSimpleID() {
        return simpleIdUsedSet.size();
    }

    public ServerRouter(UUID globalID, int dimension, int xCoord, int yCoord, int zCoord) {
        this.id = globalID != null ? globalID : UUID.randomUUID();
        this._dimension = dimension;
        this._xCoord = xCoord;
        this._yCoord = yCoord;
        this._zCoord = zCoord;
        this.clearPipeCache();
        this._myLsa = new LSA();
        this._myLsa.neighboursWithMetric = new HashMap();
        this._myLsa.power = new ArrayList();
        SharedLSADatabasewriteLock.lock();
        this.simpleID = ServerRouter.claimSimpleID();
        if (SharedLSADatabase.length <= this.simpleID) {
            int newlength = (int)((double)this.simpleID * 1.5) + 1;
            LSA[] new_SharedLSADatabase = new LSA[newlength];
            System.arraycopy(SharedLSADatabase, 0, new_SharedLSADatabase, 0, SharedLSADatabase.length);
            SharedLSADatabase = new_SharedLSADatabase;
            int[] new_lastLSAVersion = new int[newlength];
            System.arraycopy(_lastLSAVersion, 0, new_lastLSAVersion, 0, _lastLSAVersion.length);
            _lastLSAVersion = new_lastLSAVersion;
        }
        ServerRouter._lastLSAVersion[this.simpleID] = 0;
        ServerRouter.SharedLSADatabase[this.simpleID] = this._myLsa;
        SharedLSADatabasewriteLock.unlock();
    }

    @Override
    public int getSimpleID() {
        return this.simpleID;
    }

    @Override
    public boolean isInDim(int dimension) {
        return this._dimension == dimension;
    }

    @Override
    public boolean isAt(int dimension, int xCoord, int yCoord, int zCoord) {
        return this._dimension == dimension && this._xCoord == xCoord && this._yCoord == yCoord && this._zCoord == zCoord;
    }

    @Override
    public CoreRoutedPipe getPipe() {
        if (this._myPipeCache != null && this._myPipeCache.get() != null) {
            return (CoreRoutedPipe)this._myPipeCache.get();
        }
        WorldServer worldObj = DimensionManager.getWorld((int)this._dimension);
        if (worldObj == null) {
            return null;
        }
        TileEntity tile = worldObj.func_72796_p(this._xCoord, this._yCoord, this._zCoord);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        TileGenericPipe pipe = (TileGenericPipe)tile;
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        this._myPipeCache = new WeakReference<CoreRoutedPipe>((CoreRoutedPipe)pipe.pipe);
        return (CoreRoutedPipe)pipe.pipe;
    }

    @Override
    public CoreRoutedPipe getCachedPipe() {
        if (this._myPipeCache != null && this._myPipeCache.get() != null) {
            return (CoreRoutedPipe)this._myPipeCache.get();
        }
        return null;
    }

    private void ensureRouteTableIsUpToDate(boolean force) {
        if (this._LSAVersion > _lastLSAVersion[this.simpleID]) {
            if (Configs.MULTI_THREAD_NUMBER > 0 && !force) {
                RoutingTableUpdateThread.add(new UpdateRouterRunnable(this));
            } else {
                this.CreateRouteTable(this._LSAVersion);
                this._externalRoutersByCost = null;
            }
        }
    }

    @Override
    public ArrayList getRouteTable() {
        this.ensureRouteTableIsUpToDate(true);
        return this._routeTable;
    }

    @Override
    public List getIRoutersByCost() {
        this.ensureRouteTableIsUpToDate(true);
        return this._routeCosts;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    private boolean recheckAdjacent() {
        ArrayList power;
        HashMap adjacent;
        boolean adjacentChanged = false;
        CoreRoutedPipe thisPipe = this.getPipe();
        if (thisPipe == null) {
            return false;
        }
        if (thisPipe instanceof PipeItemsFirewall) {
            adjacent = PathFinder.getConnectedRoutingPipes(thisPipe.container, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH, ((PipeItemsFirewall)thisPipe).getRouterSide(this));
            power = new ArrayList();
        } else {
            adjacent = PathFinder.getConnectedRoutingPipes(thisPipe.container, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH);
            power = this.getConnectedPowerProvider();
        }
        for (CoreRoutedPipe coreRoutedPipe : adjacent.keySet()) {
            if (!coreRoutedPipe.stillNeedReplace()) continue;
            return false;
        }
        if (LogisticsPipes.DEBUG) {
            CoreRoutedPipe pipe;
            int n;
            boolean[] oldSideDisconnected = this.sideDisconnected;
            this.sideDisconnected = new boolean[6];
            this.checkSecurity(adjacent);
            boolean bl = false;
            for (int i = 0; i < 6; ++i) {
                n |= this.sideDisconnected[i] != oldSideDisconnected[i] ? 1 : 0;
            }
            if (n != 0 && (pipe = this.getPipe()) != null) {
                pipe.worldObj.func_72898_h(pipe.xCoord, pipe.yCoord, pipe.zCoord, pipe.worldObj.func_72798_a(pipe.xCoord, pipe.yCoord, pipe.zCoord));
                pipe.refreshConnectionAndRender(false);
            }
        }
        for (CoreRoutedPipe coreRoutedPipe : this._adjacent.keySet()) {
            if (adjacent.containsKey(coreRoutedPipe)) continue;
            adjacentChanged = true;
        }
        for (ILogisticsPowerProvider iLogisticsPowerProvider : this._powerAdjacent) {
            if (power.contains(iLogisticsPowerProvider)) continue;
            adjacentChanged = true;
        }
        for (Map.Entry entry : adjacent.entrySet()) {
            ExitRoute oldExit = (ExitRoute)this._adjacent.get(entry.getKey());
            if (oldExit == null) {
                adjacentChanged = true;
                break;
            }
            ExitRoute newExit = (ExitRoute)entry.getValue();
            if (newExit.equals(oldExit)) continue;
            adjacentChanged = true;
            break;
        }
        for (ILogisticsPowerProvider iLogisticsPowerProvider : power) {
            if (this._powerAdjacent.contains(iLogisticsPowerProvider)) continue;
            adjacentChanged = true;
        }
        if (adjacentChanged) {
            HashMap adjacentRouter = new HashMap();
            EnumSet<ForgeDirection> enumSet = EnumSet.noneOf(ForgeDirection.class);
            for (Map.Entry pipe : adjacent.entrySet()) {
                adjacentRouter.put(((CoreRoutedPipe)pipe.getKey()).getRouter(((ExitRoute)pipe.getValue()).insertOrientation), pipe.getValue());
                if (!((ExitRoute)pipe.getValue()).connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) && !((ExitRoute)pipe.getValue()).connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom)) continue;
                enumSet.add(((ExitRoute)pipe.getValue()).exitOrientation);
            }
            HashMap oldRouters = new HashMap(this._adjacentRouter);
            for (IRouter key : adjacentRouter.keySet()) {
                oldRouters.remove(key);
            }
            this._prevAdjacentRouter = Collections.unmodifiableMap(oldRouters);
            this._adjacentRouter = Collections.unmodifiableMap(adjacentRouter);
            this._adjacent = Collections.unmodifiableMap(adjacent);
            this._powerAdjacent = Collections.unmodifiableList(power);
            this._routedExits = enumSet;
            this.SendNewLSA();
        }
        return adjacentChanged;
    }

    private void checkSecurity(HashMap adjacent) {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return;
        }
        UUID id = pipe.getSecurityID();
        ArrayList toRemove = new ArrayList();
        if (id != null) {
            for (Map.Entry entry : adjacent.entrySet()) {
                if (!((ExitRoute)entry.getValue()).connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) && !((ExitRoute)entry.getValue()).connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom)) continue;
                UUID thatId = ((CoreRoutedPipe)entry.getKey()).getSecurityID();
                if (!(pipe instanceof PipeItemsFirewall)) {
                    if (thatId == null) {
                        ((CoreRoutedPipe)entry.getKey()).insetSecurityID(id);
                        continue;
                    }
                    if (id.equals(thatId)) continue;
                    this.sideDisconnected[((ExitRoute)entry.getValue()).exitOrientation.ordinal()] = true;
                    continue;
                }
                if (entry.getKey() instanceof PipeItemsFirewall || thatId == null || id.equals(thatId)) continue;
                this.sideDisconnected[((ExitRoute)entry.getValue()).exitOrientation.ordinal()] = true;
            }
            for (Map.Entry entry : adjacent.entrySet()) {
                if (!this.sideDisconnected[((ExitRoute)entry.getValue()).exitOrientation.ordinal()]) continue;
                toRemove.add(entry.getKey());
            }
            for (CoreRoutedPipe remove : toRemove) {
                adjacent.remove(remove);
            }
        }
    }

    private void SendNewLSA() {
        HashMap neighboursWithMetric = new HashMap();
        ArrayList<ILogisticsPowerProvider> power = new ArrayList<ILogisticsPowerProvider>();
        for (Map.Entry adjacent : this._adjacentRouter.entrySet()) {
            neighboursWithMetric.put(adjacent.getKey(), new Pair(((ExitRoute)adjacent.getValue()).distanceToDestination, ((ExitRoute)adjacent.getValue()).connectionDetails));
        }
        for (ILogisticsPowerProvider provider : this._powerAdjacent) {
            power.add(provider);
        }
        SharedLSADatabasewriteLock.lock();
        this._myLsa.neighboursWithMetric = neighboursWithMetric;
        this._myLsa.power = power;
        SharedLSADatabasewriteLock.unlock();
    }

    protected void CreateRouteTable(int version_to_update_to) {
        ExitRoute lowestCostNode;
        if (_lastLSAVersion[this.simpleID] >= version_to_update_to) {
            return;
        }
        int routingTableSize = ServerRouter.getBiggestSimpleID();
        if (routingTableSize == 0) {
            routingTableSize = SharedLSADatabase.length;
        }
        ArrayList<ExitRoute> routeCosts = new ArrayList<ExitRoute>(routingTableSize);
        ArrayList powerTable = new ArrayList(this._powerAdjacent);
        ArrayList<IRouter> firewallRouter = new ArrayList<IRouter>();
        ArrayList<EnumSet<PipeRoutingConnectionType>> closedSet = new ArrayList<EnumSet<PipeRoutingConnectionType>>(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            closedSet.add(null);
        }
        BitSet objectMapped = new BitSet(routingTableSize);
        objectMapped.set(this.simpleID, true);
        PriorityQueue<ExitRoute> candidatesCost = new PriorityQueue<ExitRoute>((int)Math.sqrt(routingTableSize));
        for (Map.Entry pipe : this._adjacentRouter.entrySet()) {
            ExitRoute currentE = (ExitRoute)pipe.getValue();
            IRouter newRouter = ((IRouter)pipe.getKey()).getRouter(currentE.insertOrientation);
            if (newRouter == null) continue;
            ExitRoute newER = new ExitRoute(newRouter, newRouter, currentE.distanceToDestination, currentE.connectionDetails);
            candidatesCost.add(newER);
        }
        SharedLSADatabasereadLock.lock();
        while ((lowestCostNode = (ExitRoute)candidatesCost.poll()) != null) {
            EnumSet<PipeRoutingConnectionType> lowestCostClosedFlags;
            if (!lowestCostNode.hasActivePipe()) continue;
            if (lowestCostNode.destination instanceof IFilteringRouter) {
                firewallRouter.add(lowestCostNode.destination);
            }
            if ((lowestCostClosedFlags = (EnumSet<PipeRoutingConnectionType>)closedSet.get(lowestCostNode.destination.getSimpleID())) == null) {
                lowestCostClosedFlags = EnumSet.noneOf(PipeRoutingConnectionType.class);
            }
            if (lowestCostClosedFlags.containsAll(lowestCostNode.getFlags())) continue;
            LSA lsa = null;
            if (lowestCostNode.destination.getSimpleID() < SharedLSADatabase.length) {
                lsa = SharedLSADatabase[lowestCostNode.destination.getSimpleID()];
            }
            if (lsa == null) {
                lowestCostNode.removeFlags(lowestCostClosedFlags);
                lowestCostClosedFlags.addAll(lowestCostNode.getFlags());
                if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canRouteTo) || lowestCostNode.containsFlag(PipeRoutingConnectionType.canRequestFrom)) {
                    routeCosts.add(lowestCostNode);
                }
                closedSet.set(lowestCostNode.destination.getSimpleID(), lowestCostClosedFlags);
                continue;
            }
            if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canPowerFrom) && !lsa.power.isEmpty() && !lowestCostClosedFlags.contains((Object)PipeRoutingConnectionType.canPowerFrom)) {
                powerTable.addAll(lsa.power);
            }
            for (Map.Entry newCandidate : lsa.neighboursWithMetric.entrySet()) {
                EnumSet<PipeRoutingConnectionType> newCandidateClosedFlags = (EnumSet<PipeRoutingConnectionType>)closedSet.get(((IRouter)newCandidate.getKey()).getSimpleID());
                if (newCandidateClosedFlags == null) {
                    newCandidateClosedFlags = EnumSet.noneOf(PipeRoutingConnectionType.class);
                }
                if (newCandidateClosedFlags.containsAll((Collection)((Pair)newCandidate.getValue()).getValue2())) continue;
                int candidateCost = lowestCostNode.distanceToDestination + (Integer)((Pair)newCandidate.getValue()).getValue1();
                EnumSet newCT = lowestCostNode.getFlags();
                newCT.retainAll((Collection)((Pair)newCandidate.getValue()).getValue2());
                if (newCT.isEmpty()) continue;
                candidatesCost.add(new ExitRoute(lowestCostNode.root, (IRouter)newCandidate.getKey(), candidateCost, newCT));
            }
            lowestCostNode.removeFlags(lowestCostClosedFlags);
            lowestCostClosedFlags.addAll(lowestCostNode.getFlags());
            if (lowestCostNode.containsFlag(PipeRoutingConnectionType.canRouteTo) || lowestCostNode.containsFlag(PipeRoutingConnectionType.canRequestFrom)) {
                routeCosts.add(lowestCostNode);
            }
            closedSet.set(lowestCostNode.destination.getSimpleID(), lowestCostClosedFlags);
        }
        SharedLSADatabasereadLock.unlock();
        ArrayList<ExitRoute> routeTable = new ArrayList<ExitRoute>(ServerRouter.getBiggestSimpleID() + 1);
        while (this.simpleID >= routeTable.size()) {
            routeTable.add(null);
        }
        routeTable.set(this.simpleID, new ExitRoute(this, this, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, 0, EnumSet.noneOf(PipeRoutingConnectionType.class)));
        for (ExitRoute node : routeCosts) {
            IRouter firstHop = node.root;
            ExitRoute hop = (ExitRoute)this._adjacentRouter.get(firstHop);
            if (hop == null) continue;
            node.root = this.getRouter(hop.exitOrientation);
            node.exitOrientation = hop.exitOrientation;
            node.insertOrientation = hop.insertOrientation;
            while (node.destination.getSimpleID() >= routeTable.size()) {
                routeTable.add(null);
            }
            ExitRoute current = (ExitRoute)routeTable.get(node.destination.getSimpleID());
            if (current != null) {
                ExitRoute merged = new ExitRoute(current, node);
                routeTable.set(merged.destination.getSimpleID(), merged);
                continue;
            }
            routeTable.set(node.destination.getSimpleID(), node);
        }
        this.routingTableUpdateWriteLock.lock();
        if (version_to_update_to == this._LSAVersion) {
            SharedLSADatabasereadLock.lock();
            if (_lastLSAVersion[this.simpleID] < version_to_update_to) {
                ServerRouter._lastLSAVersion[this.simpleID] = version_to_update_to;
                this._powerTable = powerTable;
                this._routeTable = routeTable;
                this._routeCosts = routeCosts;
                this._firewallRouter = firewallRouter;
            }
            SharedLSADatabasereadLock.unlock();
        }
        this.routingTableUpdateWriteLock.unlock();
    }

    @Override
    public void displayRoutes() {
        _laser.displayRoute(this);
    }

    @Override
    public void displayRouteTo(int r) {
        _laser.displayRoute((IRouter)this, r);
    }

    @Override
    public void inboundItemArrived(RoutedEntityItem routedEntityItem) {
        ItemStack stack;
        CoreRoutedPipe pipe = this.getPipe();
        pipe.notifyOfItemArival(routedEntityItem);
        if (pipe != null && pipe.logic instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)pipe.logic).itemArrived(ItemIdentifierStack.GetFromStack(routedEntityItem.getItemStack()));
        }
        if (pipe != null && pipe.logic instanceof IRequireReliableLiquidTransport && (stack = routedEntityItem.getItemStack()).func_77973_b() instanceof LogisticsLiquidContainer) {
            LiquidStack liquid = SimpleServiceLocator.logisticsLiquidManager.getLiquidFromContainer(stack);
            ((IRequireReliableLiquidTransport)pipe.logic).itemArrived(LiquidIdentifier.get(liquid), liquid.amount);
        }
    }

    @Override
    public boolean act(BitSet hasBeenProcessed, IRouter.IRAction actor) {
        boolean hasBeenReset = false;
        if (hasBeenProcessed.get(this.simpleID)) {
            return hasBeenReset;
        }
        hasBeenProcessed.set(this.simpleID);
        if (!actor.isInteresting(this)) {
            return hasBeenReset;
        }
        if (actor.doTo(this)) {
            hasBeenProcessed.clear();
            hasBeenReset = true;
        }
        for (IRouter r : this._adjacentRouter.keySet()) {
            hasBeenReset = hasBeenReset || r.act(hasBeenProcessed, actor);
        }
        for (IRouter r : this._prevAdjacentRouter.keySet()) {
            hasBeenReset = hasBeenReset || r.act(hasBeenProcessed, actor);
        }
        return hasBeenReset;
    }

    @Override
    public void destroy() {
        SharedLSADatabasewriteLock.lock();
        if (this.simpleID < SharedLSADatabase.length) {
            ServerRouter.SharedLSADatabase[this.simpleID] = null;
        }
        SharedLSADatabasewriteLock.unlock();
        this.removeAllInterests();
        this.clearPipeCache();
        SimpleServiceLocator.routerManager.removeRouter(this.simpleID);
        this.updateAdjacentAndLsa();
        ServerRouter.releaseSimpleID(this.simpleID);
    }

    private void removeAllInterests() {
        this.removeGenericInterest();
        for (ItemIdentifier i : this._hasInterestIn) {
            this.removeInterest(i);
        }
        this._hasInterestIn.clear();
    }

    @Override
    public boolean checkAdjacentUpdate() {
        boolean blockNeedsUpdate = this.recheckAdjacent();
        if (!blockNeedsUpdate) {
            return false;
        }
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return true;
        }
        pipe.refreshRender(true);
        return true;
    }

    @Override
    public void flagForRoutingUpdate() {
        ++this._LSAVersion;
    }

    @Override
    public void clearPrevAdjacent() {
        this._prevAdjacentRouter = null;
    }

    private void updateAdjacentAndLsa() {
        BitSet visited = new BitSet(ServerRouter.getBiggestSimpleID());
        floodCheckAdjacent flood = new floodCheckAdjacent();
        visited.set(this.simpleID);
        for (IRouter r : this._adjacentRouter.keySet()) {
            r.act(visited, flood);
        }
        if (this._prevAdjacentRouter != null) {
            for (IRouter r : this._prevAdjacentRouter.keySet()) {
                r.act(visited, flood);
            }
        }
        visited.clear();
        this.act(visited, new flagForLSAUpdate());
    }

    @Override
    public void update(boolean doFullRefresh) {
        this.updateInterests();
        if (doFullRefresh) {
            boolean blockNeedsUpdate = this.checkAdjacentUpdate();
            if (blockNeedsUpdate) {
                this.updateAdjacentAndLsa();
            }
            this.ensureRouteTableIsUpToDate(false);
            CoreRoutedPipe pipe = this.getPipe();
            if (pipe != null) {
                pipe.refreshRender(false);
            }
            return;
        }
        if (Configs.MULTI_THREAD_NUMBER > 0) {
            this.ensureRouteTableIsUpToDate(false);
        }
    }

    @Override
    public boolean isRoutedExit(ForgeDirection o) {
        return this._routedExits.contains(o);
    }

    @Override
    public ForgeDirection getExitFor(int id) {
        return ((ExitRoute)this.getRouteTable().get((int)id)).exitOrientation;
    }

    @Override
    public boolean hasRoute(int id) {
        if (!SimpleServiceLocator.routerManager.isRouterUnsafe(id, false)) {
            return false;
        }
        if (this.getRouteTable().size() <= id) {
            return false;
        }
        ExitRoute source = (ExitRoute)this.getRouteTable().get(id);
        return source != null && source.containsFlag(PipeRoutingConnectionType.canRouteTo);
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getLogisticsModule();
    }

    @Override
    public List getPowerProvider() {
        return Collections.unmodifiableList(this._powerTable);
    }

    private List getConnectedPowerProvider() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe instanceof PipeItemsBasicLogistics) {
            return ((PipeItemsBasicLogistics)pipe).getConnectedPowerProviders();
        }
        return new ArrayList();
    }

    @Override
    public IRouter getRouter(ForgeDirection insertOrientation) {
        CoreRoutedPipe pipe = this.getCachedPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getRouter(insertOrientation);
    }

    @Override
    public boolean isSideDisconneceted(ForgeDirection dir) {
        return ForgeDirection.UNKNOWN != dir && this.sideDisconnected[dir.ordinal()];
    }

    @Override
    public List getFilteringRouter() {
        return Collections.unmodifiableList(this._firewallRouter);
    }

    @Override
    public void updateInterests() {
        CoreRoutedPipe pipe;
        if (--this.ticksUntillNextInventoryCheck > 0) {
            return;
        }
        this.ticksUntillNextInventoryCheck = 20;
        if (iterated++ % this.simpleID == 0) {
            ++this.ticksUntillNextInventoryCheck;
        }
        if ((pipe = this.getPipe()) == null) {
            return;
        }
        if (pipe.hasGenericInterests()) {
            this.declareGenericInterest();
        } else {
            this.removeGenericInterest();
        }
        TreeSet newInterests = pipe.getSpecificInterests();
        if (newInterests == null) {
            newInterests = new TreeSet();
        }
        if (!newInterests.equals(this._hasInterestIn)) {
            for (ItemIdentifier i : this._hasInterestIn) {
                if (newInterests.contains(i)) continue;
                this.removeInterest(i);
            }
            for (ItemIdentifier i : newInterests) {
                if (this._hasInterestIn.contains(i)) continue;
                this.addInterest(i);
            }
            this._hasInterestIn = newInterests;
        }
    }

    private void removeGenericInterest() {
        this._hasGenericInterest = false;
        _genericInterests.remove(this);
    }

    private void declareGenericInterest() {
        this._hasGenericInterest = true;
        _genericInterests.add(this);
    }

    private void addInterest(ItemIdentifier items) {
        TreeSet<ServerRouter> interests = (TreeSet<ServerRouter>)_globalSpecificInterests.get(items);
        if (interests == null) {
            interests = new TreeSet<ServerRouter>();
            _globalSpecificInterests.put(items, interests);
        }
        interests.add(this);
    }

    private void removeInterest(ItemIdentifier p2) {
        Set interests = (Set)_globalSpecificInterests.get(p2);
        if (interests == null) {
            return;
        }
        interests.remove(this);
        if (interests.isEmpty()) {
            _globalSpecificInterests.remove(interests);
        }
    }

    public boolean hasGenericInterest() {
        return this._hasGenericInterest;
    }

    public boolean hasInterestIn(ItemIdentifier item) {
        return this._hasInterestIn.contains(item);
    }

    public static BitSet getRoutersInterestedIn(ItemIdentifier item) {
        Set specifics;
        BitSet s = new BitSet(ServerRouter.getBiggestSimpleID() + 1);
        if (_genericInterests != null) {
            for (IRouter r : _genericInterests) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = (Set)_globalSpecificInterests.get(item)) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = (Set)_globalSpecificInterests.get(item.getUndamaged())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        if ((specifics = (Set)_globalSpecificInterests.get(item.getIgnoringNBT())) != null) {
            for (IRouter r : specifics) {
                s.set(r.getSimpleID());
            }
        }
        return s;
    }

    public int compareTo(ServerRouter o) {
        return this.simpleID - o.simpleID;
    }

    @Override
    public ExitRoute getDistanceTo(IRouter r) {
        this.ensureRouteTableIsUpToDate(true);
        int id = r.getSimpleID();
        if (this._routeTable.size() <= id) {
            return null;
        }
        return (ExitRoute)this._routeTable.get(id);
    }

    public static Map getInterestedInSpecifics() {
        return _globalSpecificInterests;
    }

    public static Set getInterestedInGeneral() {
        return _genericInterests;
    }

    @Override
    public void clearInterests() {
        this.removeAllInterests();
    }

    public String toString() {
        StringBuilder string = new StringBuilder("ServerRouter: {ID: ");
        string.append(this.simpleID);
        string.append(", UUID: ");
        string.append(this.getId());
        string.append(", AT: (");
        string.append(this._dimension);
        string.append(", ");
        string.append(this._xCoord);
        string.append(", ");
        string.append(this._yCoord);
        string.append(", ");
        string.append(this._zCoord);
        string.append("), Version: ");
        string.append(this._LSAVersion);
        return string.append("}").toString();
    }

    class flagForLSAUpdate
    implements IRouter.IRAction {
        flagForLSAUpdate() {
        }

        @Override
        public boolean isInteresting(IRouter that) {
            return true;
        }

        @Override
        public boolean doTo(IRouter that) {
            that.flagForRoutingUpdate();
            return false;
        }

        @Override
        public void doneWith(IRouter that) {
            that.clearPrevAdjacent();
        }
    }

    class floodCheckAdjacent
    implements IRouter.IRAction {
        floodCheckAdjacent() {
        }

        @Override
        public boolean isInteresting(IRouter that) {
            return that.checkAdjacentUpdate();
        }

        @Override
        public boolean doTo(IRouter that) {
            return false;
        }

        @Override
        public void doneWith(IRouter that) {
        }
    }

    private class UpdateRouterRunnable
    implements Comparable,
    Runnable {
        int newVersion = 0;
        boolean run = true;
        IRouter target;

        UpdateRouterRunnable(IRouter target) {
            this.newVersion = ServerRouter.this._LSAVersion;
            this.target = target;
        }

        @Override
        public void run() {
            if (!this.run) {
                return;
            }
            try {
                CoreRoutedPipe p = this.target.getCachedPipe();
                if (p == null) {
                    this.run = false;
                    return;
                }
                while (p.stillNeedReplace()) {
                    Thread.sleep(10L);
                }
                ServerRouter.this.CreateRouteTable(this.newVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.run = false;
        }

        public int compareTo(UpdateRouterRunnable o) {
            int c = 0;
            if (o.newVersion <= 0) {
                c = this.newVersion - o.newVersion;
            }
            if (c != 0) {
                return 0;
            }
            c = this.target.getSimpleID() - o.target.getSimpleID();
            if (c != 0) {
                return 0;
            }
            c = o.newVersion - this.newVersion;
            return c;
        }
    }

    protected class LSA {
        public HashMap neighboursWithMetric;
        public List power;

        protected LSA() {
        }
    }
}

