/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.ISecurityStationManager;
import logisticspipes.interfaces.routing.IDirectConnectionManager;
import logisticspipes.network.packets.PacketStringList;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ClientRouter;
import logisticspipes.routing.DirectConnection;
import logisticspipes.routing.FilteringRouter;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterManager;
import logisticspipes.routing.ServerRouter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeDirection;

public class RouterManager
implements IRouterManager,
IDirectConnectionManager,
ISecurityStationManager {
    private final ArrayList _routersClient = new ArrayList();
    private final ArrayList _routersServer = new ArrayList();
    private final Map _uuidMap = new HashMap();
    private final WeakHashMap _security = new WeakHashMap();
    private List _authorized = new LinkedList();
    private final ArrayList connectedPipes = new ArrayList();

    @Override
    public IRouter getRouter(int id) {
        if (id <= 0 || MainProxy.isClient()) {
            return null;
        }
        return (IRouter)this._routersServer.get(id);
    }

    @Override
    public IRouter getRouterUnsafe(Integer id, boolean side) {
        if (side || id <= 0) {
            return null;
        }
        return (IRouter)this._routersServer.get(id);
    }

    @Override
    public int getIDforUUID(UUID id) {
        if (id == null) {
            return -1;
        }
        Integer iId = (Integer)this._uuidMap.get(id);
        if (iId == null) {
            return -1;
        }
        return iId;
    }

    @Override
    public void removeRouter(int id) {
        if (!MainProxy.isClient()) {
            this._routersServer.set(id, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getOrCreateRouter(UUID UUid, int dimension, int xCoord, int yCoord, int zCoord, boolean forceCreateDuplicate) {
        IRouter r = null;
        int id = this.getIDforUUID(UUid);
        if (id > 0) {
            this.getRouter(id);
        }
        if (r == null || !r.isAt(dimension, xCoord, yCoord, zCoord)) {
            if (MainProxy.isClient()) {
                ArrayList arrayList = this._routersClient;
                synchronized (arrayList) {
                    for (IRouter r2 : this._routersClient) {
                        if (!r2.isAt(dimension, xCoord, yCoord, zCoord)) continue;
                        return r2;
                    }
                    r = new ClientRouter(UUid, dimension, xCoord, yCoord, zCoord);
                    this._routersClient.add(r);
                }
            }
            ArrayList arrayList = this._routersServer;
            synchronized (arrayList) {
                if (!forceCreateDuplicate) {
                    for (IRouter r2 : this._routersServer) {
                        if (r2 == null || !r2.isAt(dimension, xCoord, yCoord, zCoord)) continue;
                        return r2;
                    }
                }
                r = new ServerRouter(UUid, dimension, xCoord, yCoord, zCoord);
                int rId = r.getSimpleID();
                if (this._routersServer.size() > rId) {
                    this._routersServer.set(rId, r);
                } else {
                    this._routersServer.ensureCapacity(rId + 1);
                    while (this._routersServer.size() <= rId) {
                        this._routersServer.add(null);
                    }
                    this._routersServer.set(rId, r);
                }
                this._uuidMap.put(r.getId(), r.getSimpleID());
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getOrCreateFirewallRouter(UUID UUid, int dimension, int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        IRouter r = null;
        int id = this.getIDforUUID(UUid);
        if (id > 0) {
            this.getRouter(id);
        }
        if (r == null || !r.isAt(dimension, xCoord, yCoord, zCoord)) {
            if (MainProxy.isClient()) {
                r = new ClientRouter(UUid, dimension, xCoord, yCoord, zCoord);
                ArrayList arrayList = this._routersClient;
                synchronized (arrayList) {
                    this._routersClient.add(r);
                }
            }
            ArrayList arrayList = this._routersServer;
            synchronized (arrayList) {
                r = new FilteringRouter(UUid, dimension, xCoord, yCoord, zCoord, dir);
                int rId = r.getSimpleID();
                if (this._routersServer.size() > rId) {
                    this._routersServer.set(rId, r);
                } else {
                    this._routersServer.ensureCapacity(rId + 1);
                    while (this._routersServer.size() <= rId) {
                        this._routersServer.add(null);
                    }
                    this._routersServer.set(rId, r);
                }
                this._uuidMap.put(r.getId(), r.getSimpleID());
            }
        }
        return r;
    }

    @Override
    public boolean isRouter(int id) {
        if (MainProxy.isClient()) {
            return true;
        }
        return this._routersServer.get(id) != null;
    }

    @Override
    public boolean isRouterUnsafe(int id, boolean side) {
        if (side) {
            return true;
        }
        return this._routersServer.get(id) != null;
    }

    @Override
    public List getRouters() {
        if (MainProxy.isClient()) {
            return Collections.unmodifiableList(this._routersClient);
        }
        return Collections.unmodifiableList(this._routersServer);
    }

    @Override
    public boolean hasDirectConnection(IRouter router) {
        for (DirectConnection con : this.connectedPipes) {
            if (con.Router1 < 0 || con.Router2 < 0) continue;
            if (con.Router1 == router.getSimpleID()) {
                return true;
            }
            if (con.Router2 != router.getSimpleID()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addDirectConnection(UUID ident, IRouter router) {
        if (MainProxy.isClient()) {
            return false;
        }
        boolean added = false;
        for (DirectConnection con : this.connectedPipes) {
            if (!ident.equals(con.identifier)) {
                if (con.Router1 >= 0 && con.Router1 == router.getSimpleID()) {
                    con.Router1 = -1;
                    continue;
                }
                if (con.Router2 < 0 || con.Router2 != router.getSimpleID()) continue;
                con.Router2 = -1;
                continue;
            }
            if (con.Router1 < 0 || con.Router1 == router.getSimpleID()) {
                con.Router1 = router.getSimpleID();
                added = true;
                break;
            }
            if (con.Router2 < 0 || con.Router2 == router.getSimpleID()) {
                con.Router2 = router.getSimpleID();
                added = true;
                break;
            }
            return false;
        }
        if (!added) {
            DirectConnection Dc = new DirectConnection();
            this.connectedPipes.add(Dc);
            Dc.identifier = ident;
            Dc.Router1 = router.getSimpleID();
        }
        return true;
    }

    @Override
    public CoreRoutedPipe getConnectedPipe(IRouter router) {
        int id = -1;
        for (DirectConnection con : this.connectedPipes) {
            if (con.Router1 < 0 || con.Router2 < 0) continue;
            if (con.Router1 == router.getSimpleID()) {
                id = con.Router2;
                break;
            }
            if (con.Router2 != router.getSimpleID()) continue;
            id = con.Router1;
            break;
        }
        if (id < 0) {
            return null;
        }
        IRouter r = this.getRouter(id);
        if (r == null) {
            return null;
        }
        return r.getPipe();
    }

    @Override
    public void removeDirectConnection(IRouter router) {
        if (MainProxy.isClient()) {
            return;
        }
        for (DirectConnection con : this.connectedPipes) {
            if (con.Router1 >= 0 && con.Router1 == router.getSimpleID()) {
                con.Router1 = -1;
                continue;
            }
            if (con.Router2 < 0 || con.Router2 != router.getSimpleID()) continue;
            con.Router2 = -1;
        }
    }

    @Override
    public void serverStopClean() {
        this.connectedPipes.clear();
        this._routersServer.clear();
        this._uuidMap.clear();
        this._security.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClientRouters() {
        ArrayList arrayList = this._routersClient;
        synchronized (arrayList) {
            this._routersClient.clear();
        }
    }

    @Override
    public void add(LogisticsSecurityTileEntity tile) {
        this._security.put(tile, null);
        this.authorizeUUID(tile.getSecId());
    }

    @Override
    public LogisticsSecurityTileEntity getStation(UUID id) {
        if (id == null) {
            return null;
        }
        for (LogisticsSecurityTileEntity tile : this._security.keySet()) {
            if (!id.equals(tile.getSecId())) continue;
            return tile;
        }
        return null;
    }

    @Override
    public void remove(LogisticsSecurityTileEntity tile) {
        this._security.remove(tile);
        this.deauthorizeUUID(tile.getSecId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dimensionUnloaded(int dim) {
        ArrayList arrayList = this._routersServer;
        synchronized (arrayList) {
            for (IRouter r : this._routersServer) {
                if (r == null || !r.isInDim(dim)) continue;
                r.clearPipeCache();
                r.clearInterests();
            }
        }
    }

    @Override
    public void deauthorizeUUID(UUID id) {
        if (this._authorized.contains(id.toString())) {
            this._authorized.remove(id.toString());
        }
        this.sendClientAuthorizationList();
    }

    @Override
    public void authorizeUUID(UUID id) {
        if (!this._authorized.contains(id.toString())) {
            this._authorized.add(id.toString());
        }
        this.sendClientAuthorizationList();
    }

    @Override
    public boolean isAuthorized(UUID id) {
        if (this._authorized.isEmpty() || id == null) {
            return false;
        }
        return this._authorized.contains(id.toString());
    }

    @Override
    public void setClientAuthorizationList(List list) {
        this._authorized = list;
    }

    @Override
    public void sendClientAuthorizationList() {
        MainProxy.sendToAllPlayers(new PacketStringList(102, this._authorized).getPacket());
    }

    @Override
    public void sendClientAuthorizationList(EntityPlayer player) {
        MainProxy.sendCompressedPacketToPlayer(new PacketStringList(102, this._authorized).getPacket(), (Player)player);
    }
}

