/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.routing.IDirectRoutingConnection;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidConnectorPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.utils.Pair;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

class PathFinder {
    private final int maxVisited;
    private final int maxLength;
    private final HashSet setVisited;
    private final IPaintPath pathPainter;
    private int pipesVisited;

    public static HashMap getConnectedRoutingPipes(TileGenericPipe startPipe, int maxVisited, int maxLength) {
        PathFinder newSearch = new PathFinder(maxVisited, maxLength, null);
        return newSearch.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), ForgeDirection.UNKNOWN);
    }

    public static HashMap getConnectedRoutingPipes(TileGenericPipe startPipe, int maxVisited, int maxLength, ForgeDirection side) {
        PathFinder newSearch = new PathFinder(maxVisited, maxLength, null);
        return newSearch.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), side);
    }

    public static HashMap paintAndgetConnectedRoutingPipes(TileGenericPipe startPipe, ForgeDirection startOrientation, int maxVisited, int maxLength, IPaintPath pathPainter) {
        PathFinder newSearch = new PathFinder(maxVisited, maxLength, pathPainter);
        newSearch.setVisited.add(startPipe);
        Position p = new Position((double)startPipe.field_70329_l, (double)startPipe.field_70330_m, (double)startPipe.field_70327_n, startOrientation);
        p.moveForwards(1.0);
        TileEntity entity = startPipe.field_70331_k.func_72796_p((int)p.x, (int)p.y, (int)p.z);
        if (!(entity instanceof TileGenericPipe) || !((TileGenericPipe)entity).pipe.canPipeConnect((TileEntity)startPipe, startOrientation)) {
            return new HashMap();
        }
        return newSearch.getConnectedRoutingPipes((TileGenericPipe)entity, EnumSet.allOf(PipeRoutingConnectionType.class), ForgeDirection.UNKNOWN);
    }

    private PathFinder(int maxVisited, int maxLength, IPaintPath pathPainter) {
        this.maxVisited = maxVisited;
        this.maxLength = maxLength;
        this.setVisited = new HashSet();
        this.pathPainter = pathPainter;
    }

    private HashMap getConnectedRoutingPipes(TileGenericPipe startPipe, EnumSet connectionFlags, ForgeDirection side) {
        boolean root;
        HashMap<CoreRoutedPipe, ExitRoute> foundPipes = new HashMap<CoreRoutedPipe, ExitRoute>();
        boolean bl = root = this.setVisited.size() == 0;
        if (this.setVisited.size() == 1) {
            this.pipesVisited = 0;
        }
        if (++this.pipesVisited > this.maxVisited) {
            return foundPipes;
        }
        if (this.setVisited.size() > this.maxLength) {
            return foundPipes;
        }
        if (!startPipe.initialized) {
            return foundPipes;
        }
        if (startPipe.pipe instanceof CoreRoutedPipe && this.setVisited.size() != 0) {
            CoreRoutedPipe rp = (CoreRoutedPipe)startPipe.pipe;
            if (rp.stillNeedReplace()) {
                return foundPipes;
            }
            foundPipes.put(rp, new ExitRoute(null, rp.getRouter(), ForgeDirection.UNKNOWN, side.getOpposite(), this.setVisited.size(), connectionFlags));
            return foundPipes;
        }
        if (startPipe.pipe instanceof LogisticsLiquidConnectorPipe) {
            return foundPipes;
        }
        this.setVisited.add(startPipe);
        if (startPipe.pipe != null) {
            List pipez = SimpleServiceLocator.specialpipeconnection.getConnectedPipes(startPipe);
            for (TileGenericPipe specialpipe : pipez) {
                if (this.setVisited.contains(specialpipe)) continue;
                HashMap result = this.getConnectedRoutingPipes(specialpipe, connectionFlags, side);
                for (Map.Entry pipe : result.entrySet()) {
                    ((ExitRoute)pipe.getValue()).exitOrientation = ForgeDirection.UNKNOWN;
                    ExitRoute foundPipe = (ExitRoute)foundPipes.get(pipe.getKey());
                    if (foundPipe != null && ((ExitRoute)pipe.getValue()).distanceToDestination >= foundPipe.distanceToDestination) continue;
                    foundPipes.put((CoreRoutedPipe)pipe.getKey(), (ExitRoute)pipe.getValue());
                }
            }
        }
        ArrayDeque<Pair> connections = new ArrayDeque<Pair>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            if (root && !ForgeDirection.UNKNOWN.equals((Object)side) && !direction.equals((Object)side) || (tile = startPipe.tileBuffer[direction.ordinal()].getTile()) == null) continue;
            connections.add(new Pair(tile, direction));
        }
        while (!connections.isEmpty()) {
            CoreRoutedPipe CRP;
            List list;
            Pair pair = (Pair)connections.pollFirst();
            TileEntity tile = (TileEntity)pair.getValue1();
            ForgeDirection direction = (ForgeDirection)pair.getValue2();
            EnumSet nextConnectionFlags = EnumSet.copyOf(connectionFlags);
            boolean isDirectConnection = false;
            int resistance = 0;
            if (root && !(list = SimpleServiceLocator.specialtileconnection.getConnectedPipes(tile)).isEmpty()) {
                for (TileGenericPipe pipe : list) {
                    connections.add(new Pair(pipe, direction));
                }
                continue;
            }
            if (tile instanceof IInventory && startPipe.pipe instanceof IDirectRoutingConnection && SimpleServiceLocator.connectionManager.hasDirectConnection(((CoreRoutedPipe)startPipe.pipe).getRouter()) && (CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(((CoreRoutedPipe)startPipe.pipe).getRouter())) != null) {
                tile = CRP.container;
                isDirectConnection = true;
                resistance = ((IDirectRoutingConnection)startPipe.pipe).getConnectionResistance();
            }
            if (tile == null || !(tile instanceof TileGenericPipe) || !isDirectConnection && !SimpleServiceLocator.buildCraftProxy.checkPipesConnections((TileEntity)startPipe, tile, direction, true)) continue;
            TileGenericPipe currentPipe = (TileGenericPipe)tile;
            if (this.setVisited.contains(tile)) continue;
            if (isDirectConnection) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
            }
            if (currentPipe.pipe instanceof PipeItemsObsidian || currentPipe.pipe instanceof PipeStructureCobblestone) continue;
            if (currentPipe.pipe instanceof PipeItemsDiamond) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
            }
            if (startPipe.pipe instanceof PipeItemsIron && !startPipe.pipe.outputOpen(direction)) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
            }
            if (currentPipe.pipe instanceof PipeItemsIron && !currentPipe.pipe.outputOpen(direction.getOpposite())) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
            }
            if (nextConnectionFlags.isEmpty()) continue;
            int beforeRecurseCount = foundPipes.size();
            HashMap result = this.getConnectedRoutingPipes((TileGenericPipe)tile, nextConnectionFlags, direction);
            for (Map.Entry pipeEntry : result.entrySet()) {
                ((ExitRoute)pipeEntry.getValue()).exitOrientation = direction;
                ExitRoute foundPipe = (ExitRoute)foundPipes.get(pipeEntry.getKey());
                if (foundPipe == null) {
                    foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                    ((ExitRoute)pipeEntry.getValue()).distanceToDestination += resistance;
                    continue;
                }
                if (((ExitRoute)pipeEntry.getValue()).distanceToDestination + resistance >= foundPipe.distanceToDestination) continue;
                foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                ((ExitRoute)pipeEntry.getValue()).distanceToDestination += resistance;
            }
            if (foundPipes.size() <= beforeRecurseCount || this.pathPainter == null) continue;
            Position p = new Position((double)startPipe.field_70329_l, (double)startPipe.field_70330_m, (double)startPipe.field_70327_n, direction);
            this.pathPainter.addLaser(startPipe.field_70331_k, p, direction);
        }
        this.setVisited.remove(startPipe);
        if (startPipe.pipe instanceof CoreRoutedPipe) {
            for (ExitRoute e : foundPipes.values()) {
                e.root = ((CoreRoutedPipe)startPipe.pipe).getRouter();
            }
        }
        return foundPipes;
    }
}

