/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.EnumSet;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import net.minecraftforge.common.ForgeDirection;

public class ExitRoute
implements Comparable {
    public ForgeDirection exitOrientation;
    public ForgeDirection insertOrientation;
    public int distanceToDestination;
    public final int destinationDistanceToRoot;
    public final EnumSet connectionDetails;
    public final IRouter destination;
    public IRouter root;

    public ExitRoute(IRouter source, IRouter destination, ForgeDirection exitOrientation, ForgeDirection insertOrientation, int metric, EnumSet connectionDetails) {
        this.destination = destination;
        this.root = source;
        this.exitOrientation = exitOrientation;
        this.insertOrientation = insertOrientation;
        this.connectionDetails = connectionDetails;
        this.distanceToDestination = connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) ? metric : Integer.MAX_VALUE;
        this.destinationDistanceToRoot = connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom) ? metric : Integer.MAX_VALUE;
    }

    public ExitRoute(ExitRoute other) {
        this.root = other.root;
        this.destination = other.destination;
        this.exitOrientation = other.exitOrientation;
        this.insertOrientation = other.insertOrientation;
        this.distanceToDestination = other.distanceToDestination;
        this.destinationDistanceToRoot = other.destinationDistanceToRoot;
        this.connectionDetails = other.connectionDetails;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof ExitRoute)) {
            return false;
        }
        ExitRoute that = (ExitRoute)aThat;
        return this.exitOrientation.equals((Object)that.exitOrientation) && this.insertOrientation.equals((Object)that.insertOrientation) && this.connectionDetails.equals(that.connectionDetails) && this.distanceToDestination == that.distanceToDestination && this.destinationDistanceToRoot == that.destinationDistanceToRoot;
    }

    public String toString() {
        return "{" + this.exitOrientation.name() + "," + this.insertOrientation.name() + "," + this.distanceToDestination + "," + this.destinationDistanceToRoot + ", ConnectionDetails: " + this.connectionDetails + "}";
    }

    public void removeFlags(EnumSet flags) {
        this.connectionDetails.removeAll(flags);
    }

    public boolean containsFlag(PipeRoutingConnectionType flag) {
        return this.connectionDetails.contains((Object)flag);
    }

    public boolean hasActivePipe() {
        return this.destination != null && this.destination.getCachedPipe() != null;
    }

    public EnumSet getFlags() {
        return EnumSet.copyOf(this.connectionDetails);
    }

    public int compareTo(ExitRoute o) {
        int c = this.distanceToDestination - o.distanceToDestination;
        if (c == 0) {
            return this.destination.getSimpleID() - o.destination.getSimpleID();
        }
        return c;
    }

    public ExitRoute(IRouter source, IRouter destination, int distance, EnumSet enumSet) {
        this(source, destination, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, distance, enumSet);
    }

    public ExitRoute(ExitRoute current, ExitRoute node) {
        this.root = current.root;
        this.destination = current.destination;
        this.connectionDetails = EnumSet.copyOf(current.connectionDetails);
        if (node.connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo)) {
            this.distanceToDestination = node.distanceToDestination;
            this.exitOrientation = node.exitOrientation;
        } else {
            this.exitOrientation = current.exitOrientation;
            this.distanceToDestination = current.distanceToDestination;
        }
        if (this.connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom)) {
            this.insertOrientation = node.insertOrientation;
            this.destinationDistanceToRoot = node.destinationDistanceToRoot;
        } else {
            this.insertOrientation = current.insertOrientation;
            this.destinationDistanceToRoot = current.destinationDistanceToRoot;
        }
        this.connectionDetails.addAll(node.connectionDetails);
    }
}

