/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.LiquidRequestTreeNode;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import logisticspipes.utils.Pair3;

public class RequestTreeNode {
    private final IRequestItems target;
    private final ItemIdentifierStack request;
    private final RequestTreeNode parentNode;
    protected final RequestTree root;
    private List subRequests = new ArrayList();
    List liquidSubRequests = new ArrayList();
    private List promises = new ArrayList();
    private List extrapromises = new ArrayList();
    private List byproducts = new ArrayList();
    private SortedSet usedCrafters = new TreeSet();
    private CraftingTemplate lastCrafterTried = null;
    private int promiseItemCount = 0;

    protected RequestTreeNode(ItemIdentifierStack item, IRequestItems requester, RequestTreeNode parentNode, EnumSet requestFlags) {
        this(null, item, requester, parentNode, requestFlags);
    }

    private RequestTreeNode(CraftingTemplate template, ItemIdentifierStack item, IRequestItems requester, RequestTreeNode parentNode, EnumSet requestFlags) {
        this.request = item;
        this.target = requester;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.subRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = (RequestTree)this;
        }
        if (template != null) {
            this.declareCrafterUsed(template);
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Provide) && this.checkProvider()) {
            return;
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Craft) && this.checkExtras() && this.checkCrafting()) {
            return;
        }
    }

    private boolean isCrafterUsed(CraftingTemplate test) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(test)) {
            return true;
        }
        if (this.parentNode == null) {
            return false;
        }
        return this.parentNode.isCrafterUsed(test);
    }

    private boolean declareCrafterUsed(CraftingTemplate test) {
        if (this.isCrafterUsed(test)) {
            return false;
        }
        this.usedCrafters.add(test);
        return true;
    }

    public int getPromiseItemCount() {
        return this.promiseItemCount;
    }

    public int getMissingItemCount() {
        return this.request.stackSize - this.promiseItemCount;
    }

    public void addPromise(LogisticsPromise promise) {
        if (promise.item != this.request.getItem()) {
            throw new IllegalArgumentException("wrong item");
        }
        if (this.getMissingItemCount() == 0) {
            throw new IllegalArgumentException("zero count needed, promises not needed.");
        }
        if (promise.numberOfItems > this.getMissingItemCount()) {
            int more = promise.numberOfItems - this.getMissingItemCount();
            promise.numberOfItems = this.getMissingItemCount();
            LogisticsExtraPromise extra = new LogisticsExtraPromise();
            extra.item = promise.item;
            extra.numberOfItems = more;
            extra.sender = promise.sender;
            extra.relayPoints = new LinkedList();
            extra.relayPoints.addAll(promise.relayPoints);
            this.extrapromises.add(extra);
        }
        if (promise.numberOfItems <= 0) {
            throw new IllegalArgumentException("zero count ... again");
        }
        this.promises.add(promise);
        this.promiseItemCount += promise.numberOfItems;
        this.root.promiseAdded(promise);
    }

    public boolean isDone() {
        return this.getMissingItemCount() <= 0;
    }

    public boolean isAllDone() {
        boolean result = this.getMissingItemCount() <= 0;
        for (RequestTreeNode node : this.subRequests) {
            result &= node.isAllDone();
        }
        return result;
    }

    public ItemIdentifier getStackItem() {
        return this.request.getItem();
    }

    protected void remove(RequestTreeNode subNode) {
        this.subRequests.remove(subNode);
        subNode.removeSubPromisses();
    }

    protected void remove(LiquidRequestTreeNode subNode) {
        this.liquidSubRequests.remove(subNode);
        subNode.removeSubPromisses();
    }

    protected void removeSubPromisses() {
        for (LogisticsPromise promise : this.promises) {
            this.root.promiseRemoved(promise);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeSubPromisses();
        }
    }

    protected void checkForExtras(ItemIdentifier item, HashMap extraMap) {
        for (LogisticsExtraPromise extra : this.extrapromises) {
            if (extra.item != item) continue;
            LinkedList<LogisticsExtraPromise> extras = (LinkedList<LogisticsExtraPromise>)extraMap.get(extra.sender);
            if (extras == null) {
                extras = new LinkedList<LogisticsExtraPromise>();
                extraMap.put(extra.sender, extras);
            }
            extras.add(extra.copy());
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.checkForExtras(item, extraMap);
        }
    }

    protected void removeUsedExtras(ItemIdentifier item, HashMap extraMap) {
        block0: for (LogisticsPromise promise : this.promises) {
            if (promise.item != item || !(promise instanceof LogisticsExtraPromise)) continue;
            LogisticsExtraPromise epromise = (LogisticsExtraPromise)promise;
            if (epromise.provided) continue;
            int usedcount = epromise.numberOfItems;
            List extras = (List)extraMap.get(epromise.sender);
            if (extras == null) continue;
            Iterator it = extras.iterator();
            while (it.hasNext()) {
                LogisticsExtraPromise extra = (LogisticsExtraPromise)it.next();
                if (extra.numberOfItems >= usedcount) {
                    extra.numberOfItems -= usedcount;
                    usedcount = 0;
                    continue block0;
                }
                usedcount -= extra.numberOfItems;
                it.remove();
            }
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeUsedExtras(item, extraMap);
        }
    }

    protected void fullFill() {
        for (Object subNode : this.subRequests) {
            ((RequestTreeNode)subNode).fullFill();
        }
        for (LogisticsPromise promise : this.promises) {
            promise.sender.fullFill(promise, this.target);
        }
        for (LogisticsPromise promise : this.extrapromises) {
            if (!(promise.sender instanceof ICraftItems)) continue;
            ((ICraftItems)promise.sender).registerExtras(promise);
        }
        for (LogisticsPromise promise : this.byproducts) {
            if (!(promise.sender instanceof ICraftItems)) continue;
            ((ICraftItems)promise.sender).registerExtras(promise);
        }
        for (Object subNode : this.liquidSubRequests) {
            ((LiquidRequestTreeNode)subNode).fullFill();
        }
    }

    protected void sendMissingMessage(LinkedList missing) {
        if (this.getMissingItemCount() != 0) {
            ItemIdentifierStack stack = this.request.clone();
            stack.stackSize = this.getMissingItemCount();
            missing.add(new ItemMessage(stack));
        }
        for (Object subNode : this.subRequests) {
            ((RequestTreeNode)subNode).sendMissingMessage(missing);
        }
        for (Object subNode : this.liquidSubRequests) {
            ((LiquidRequestTreeNode)subNode).sendMissingMessage(missing);
        }
    }

    protected void sendUsedMessage(LinkedList used, LinkedList missing) {
        ItemIdentifierStack stack;
        int usedcount = 0;
        for (LogisticsPromise promise : this.promises) {
            if (!(promise.sender instanceof IProvideItems) || promise.sender instanceof ICraftItems) continue;
            usedcount += promise.numberOfItems;
        }
        if (usedcount != 0) {
            stack = this.request.clone();
            stack.stackSize = usedcount;
            used.add(new ItemMessage(stack));
        }
        if (this.getMissingItemCount() != 0) {
            stack = this.request.clone();
            stack.stackSize = this.getMissingItemCount();
            missing.add(new ItemMessage(stack));
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.sendUsedMessage(used, missing);
        }
    }

    private boolean checkProvider() {
        CoreRoutedPipe thisPipe = this.target.getRouter().getCachedPipe();
        for (Pair provider : RequestTreeNode.getProviders(this.target.getRouter(), this.getStackItem(), new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList())) {
            if (this.isDone()) break;
            if (thisPipe.sharesInventoryWith(((IProvideItems)provider.getValue1()).getRouter().getPipe())) continue;
            ((IProvideItems)provider.getValue1()).canProvide(this, this.root.getAllPromissesFor((IProvideItems)provider.getValue1(), this.getStackItem()), (List)provider.getValue2());
        }
        return this.isDone();
    }

    private static List getProviders(IRouter destination, ItemIdentifier item, BitSet layer, List filters) {
        List list;
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(item);
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = destination.getDistanceTo(r);
            if (e != null) {
                validSources.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validSources, new RequestTree.workWeightedSorter(1.0));
        LinkedList<Pair> providers = new LinkedList<Pair>();
        LinkedList<ExitRoute> firewalls = new LinkedList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        for (ExitRoute r : validSources) {
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID())) continue;
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (pipe instanceof IProvideItems) {
                list = new LinkedList();
                list.addAll(filters);
                providers.add(new Pair((IProvideItems)((Object)pipe), list));
                used.set(r.root.getSimpleID());
            }
            if (!(r.destination instanceof IFilteringRouter)) continue;
            firewalls.add(r);
            used.set(r.destination.getSimpleID());
        }
        for (ExitRoute r : firewalls) {
            IFilter filter = ((IFilteringRouter)((Object)r.destination)).getFilter();
            filters.add(filter);
            list = RequestTreeNode.getProviders(r.destination, item, used, filters);
            filters.remove(filter);
            providers.addAll(list);
        }
        return providers;
    }

    private boolean checkExtras() {
        LinkedList map = this.root.getExtrasFor(this.getStackItem());
        for (LogisticsExtraPromise extraPromise : map) {
            if (this.isDone()) break;
            if (extraPromise.numberOfItems == 0) continue;
            boolean valid = false;
            ExitRoute source = (ExitRoute)extraPromise.sender.getRouter().getRouteTable().get(this.target.getRouter().getSimpleID());
            if (source != null && !source.containsFlag(PipeRoutingConnectionType.canRouteTo)) {
                for (ExitRoute node : this.target.getRouter().getIRoutersByCost()) {
                    if (node.destination != extraPromise.sender.getRouter() || !node.containsFlag(PipeRoutingConnectionType.canRequestFrom)) continue;
                    valid = true;
                }
            }
            if (!valid) continue;
            extraPromise.numberOfItems = Math.min(extraPromise.numberOfItems, this.getMissingItemCount());
            this.addPromise(extraPromise);
        }
        return this.isDone();
    }

    private boolean checkCrafting() {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(this.getStackItem());
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = this.target.getRouter().getDistanceTo(r);
            if (e != null) {
                validSources.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        RequestTree.workWeightedSorter wSorter = new RequestTree.workWeightedSorter(0.0);
        Collections.sort(validSources, wSorter);
        List allCraftersForItem = RequestTreeNode.getCrafters(this.getStackItem(), validSources, new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList());
        Iterator iterAllCrafters = allCraftersForItem.iterator();
        PriorityQueue<CraftingSorterNode> craftersSamePriority = new PriorityQueue<CraftingSorterNode>(5);
        ArrayList craftersToBalance = new ArrayList();
        boolean done = false;
        Pair lastCrafter = null;
        int currentPriority = 0;
        block1: while (!done) {
            if (iterAllCrafters.hasNext()) {
                if (lastCrafter == null) {
                    lastCrafter = (Pair)iterAllCrafters.next();
                }
            } else {
                done = true;
            }
            int itemsNeeded = this.getMissingItemCount();
            if (lastCrafter != null && (craftersSamePriority.isEmpty() || currentPriority == ((CraftingTemplate)lastCrafter.getValue1()).getPriority())) {
                currentPriority = ((CraftingTemplate)lastCrafter.getValue1()).getPriority();
                Pair crafter = lastCrafter;
                lastCrafter = null;
                CraftingTemplate template = (CraftingTemplate)crafter.getValue1();
                if (this.isCrafterUsed(template) || template.canCraft(this.getStackItem())) continue;
                for (IFilter filter : (List)crafter.getValue2()) {
                    if (filter.isBlocked() != filter.isFilteredItem(template.getResultItem().getUndamaged()) && !filter.blockCrafting()) continue;
                    continue block1;
                }
                CraftingSorterNode cn = new CraftingSorterNode(crafter, itemsNeeded, this.root, this);
                craftersSamePriority.add(cn);
                continue;
            }
            if (craftersToBalance == null && (craftersSamePriority == null || craftersSamePriority.isEmpty())) continue;
            if (craftersSamePriority.size() == 1) {
                craftersToBalance.add(craftersSamePriority.poll());
                ((CraftingSorterNode)craftersToBalance.get(0)).addToWorkRequest(itemsNeeded);
            } else {
                if (!craftersSamePriority.isEmpty()) {
                    craftersToBalance.add(craftersSamePriority.poll());
                }
                while (!craftersToBalance.isEmpty() && itemsNeeded > 0) {
                    while (!craftersSamePriority.isEmpty() && ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() <= ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo()) {
                        craftersToBalance.add(craftersSamePriority.poll());
                    }
                    int cap = !craftersSamePriority.isEmpty() ? ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() : Integer.MAX_VALUE;
                    int floor = ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo();
                    cap = Math.min(cap, floor + (itemsNeeded + craftersToBalance.size() - 1) / craftersToBalance.size());
                    for (CraftingSorterNode crafter : craftersToBalance) {
                        int request = Math.min(itemsNeeded, cap - floor);
                        if (request <= 0) continue;
                        int craftingDone = crafter.addToWorkRequest(request);
                        itemsNeeded -= craftingDone;
                    }
                }
            }
            Iterator iter = craftersToBalance.iterator();
            while (iter.hasNext()) {
                CraftingSorterNode c = (CraftingSorterNode)iter.next();
                if (c.stacksOfWorkRequested <= 0 || c.addWorkPromisesToTree()) continue;
                iter.remove();
            }
            itemsNeeded = this.getMissingItemCount();
            if (itemsNeeded <= 0) break;
            if (craftersToBalance.isEmpty()) continue;
            done = false;
        }
        return this.isDone();
    }

    private static List getCrafters(ItemIdentifier itemToCraft, List validDestinations, BitSet layer, List filters) {
        ArrayList<Pair> crafters = new ArrayList<Pair>(validDestinations.size());
        LinkedList<ExitRoute> firewalls = new LinkedList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        for (ExitRoute r : validDestinations) {
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID())) continue;
            if (pipe instanceof ICraftItems) {
                used.set(r.destination.getSimpleID());
                CraftingTemplate craftable = ((ICraftItems)((Object)pipe)).addCrafting(itemToCraft);
                if (craftable != null) {
                    for (IFilter filter : filters) {
                        if (filter.isBlocked() != filter.isFilteredItem(craftable.getResultItem().getUndamaged()) && !filter.blockCrafting()) continue;
                    }
                    LinkedList list = new LinkedList();
                    list.addAll(filters);
                    crafters.add(new Pair(craftable, list));
                }
            }
            if (!(r.destination instanceof IFilteringRouter)) continue;
            firewalls.add(r);
            used.set(r.destination.getSimpleID());
        }
        for (ExitRoute r : firewalls) {
            IFilter filter = ((IFilteringRouter)((Object)r.destination)).getFilter();
            filters.add(filter);
            List list = RequestTreeNode.getCrafters(itemToCraft, ((IFilteringRouter)((Object)r.destination)).getRouters(), used, filters);
            filters.remove(filter);
            crafters.addAll(list);
        }
        return crafters;
    }

    private int getSubRequests(int nCraftingSets, CraftingTemplate template) {
        boolean failed = false;
        List stacks = template.getComponentItems(nCraftingSets);
        int workSetsAvailable = nCraftingSets;
        ArrayList<RequestTreeNode> lastNode = new ArrayList<RequestTreeNode>(stacks.size());
        for (Pair stack : stacks) {
            RequestTreeNode node = new RequestTreeNode(template, (ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags);
            lastNode.add(node);
            if (node.isDone()) continue;
            failed = true;
        }
        List liquids = template.getComponentLiquid(nCraftingSets);
        ArrayList<LiquidRequestTreeNode> lastLiquidNode = new ArrayList<LiquidRequestTreeNode>(liquids.size());
        for (Pair3 pair3 : liquids) {
            LiquidRequestTreeNode node = new LiquidRequestTreeNode((LiquidIdentifier)pair3.getValue1(), (Integer)pair3.getValue2(), (IRequestLiquid)pair3.getValue3(), this);
            lastLiquidNode.add(node);
            if (node.isDone()) continue;
            failed = true;
        }
        if (failed) {
            int i;
            for (RequestTreeNode requestTreeNode : lastNode) {
                requestTreeNode.destroy();
            }
            for (LiquidRequestTreeNode liquidRequestTreeNode : lastLiquidNode) {
                liquidRequestTreeNode.destroy();
            }
            this.lastCrafterTried = template;
            for (i = 0; i < stacks.size(); ++i) {
                workSetsAvailable = Math.min(workSetsAvailable, ((RequestTreeNode)lastNode.get(i)).getPromiseItemCount() / ((ItemIdentifierStack)((Pair)stacks.get((int)i)).getValue1()).stackSize / nCraftingSets);
            }
            for (i = 0; i < liquids.size(); ++i) {
                workSetsAvailable = Math.min(workSetsAvailable, ((LiquidRequestTreeNode)lastLiquidNode.get(i)).getPromiseLiquidAmount() / (Integer)((Pair3)liquids.get(i)).getValue2() / nCraftingSets);
            }
            return this.generateRequestTreeFor(workSetsAvailable, template);
        }
        for (ItemIdentifierStack itemIdentifierStack : template.getByproduct()) {
            LogisticsExtraPromise extra = new LogisticsExtraPromise();
            extra.item = itemIdentifierStack.getItem();
            extra.numberOfItems = itemIdentifierStack.stackSize * workSetsAvailable;
            extra.sender = template.getCrafter();
            extra.provided = false;
            this.byproducts.add(extra);
        }
        return workSetsAvailable;
    }

    private int generateRequestTreeFor(int workSets, CraftingTemplate template) {
        ArrayList<RequestTreeNode> newChildren = new ArrayList<RequestTreeNode>();
        ArrayList<LiquidRequestTreeNode> newLiquidChildren = new ArrayList<LiquidRequestTreeNode>();
        if (workSets > 0) {
            List stacks = template.getComponentItems(workSets);
            boolean failed = false;
            for (Pair stack : stacks) {
                RequestTreeNode node = new RequestTreeNode(template, (ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags);
                newChildren.add(node);
                if (node.isDone()) continue;
                failed = true;
            }
            List liquids = template.getComponentLiquid(workSets);
            for (Pair3 liquid : liquids) {
                LiquidRequestTreeNode node = new LiquidRequestTreeNode((LiquidIdentifier)liquid.getValue1(), (Integer)liquid.getValue2(), (IRequestLiquid)liquid.getValue3(), this);
                newLiquidChildren.add(node);
                if (node.isDone()) continue;
                failed = true;
            }
            if (failed) {
                for (RequestTreeNode c : newChildren) {
                    c.destroy();
                }
                for (LiquidRequestTreeNode n : newLiquidChildren) {
                    n.destroy();
                }
                return 0;
            }
        }
        for (ItemIdentifierStack stack : template.getByproduct()) {
            LogisticsExtraPromise extra = new LogisticsExtraPromise();
            extra.item = stack.getItem();
            extra.numberOfItems = stack.stackSize * workSets;
            extra.sender = template.getCrafter();
            extra.provided = false;
            this.byproducts.add(extra);
        }
        return workSets;
    }

    void recurseFailedRequestTree() {
        if (this.isDone()) {
            return;
        }
        if (this.lastCrafterTried == null) {
            return;
        }
        CraftingTemplate template = this.lastCrafterTried;
        int nCraftingSetsNeeded = (this.getMissingItemCount() + template.getResultStackSize() - 1) / template.getResultStackSize();
        List stacks = template.getComponentItems(nCraftingSetsNeeded);
        for (Pair stack : stacks) {
            new RequestTreeNode(template, (ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags);
        }
        List liquids = template.getComponentLiquid(nCraftingSetsNeeded);
        for (Pair3 liquid : liquids) {
            new LiquidRequestTreeNode((LiquidIdentifier)liquid.getValue1(), (Integer)liquid.getValue2(), (IRequestLiquid)liquid.getValue3(), this);
        }
        this.addPromise(template.generatePromise(nCraftingSetsNeeded, new ArrayList()));
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.recurseFailedRequestTree();
        }
    }

    protected void logFailedRequestTree(RequestLog log) {
        for (RequestTreeNode node : this.subRequests) {
            node.recurseFailedRequestTree();
        }
        for (RequestTreeNode node : this.subRequests) {
            if (!(node instanceof RequestTree)) continue;
            ((RequestTree)node).sendMissingMessage(log);
        }
    }

    private void destroy() {
        this.parentNode.remove(this);
    }

    private class CraftingSorterNode
    implements Comparable {
        private int stacksOfWorkRequested;
        private final int setSize;
        private final int maxWorkSetsAvailable;
        private final RequestTreeNode treeNode;
        public final Pair crafter;
        public final int originalToDo;

        CraftingSorterNode(Pair crafter, int maxCount, RequestTree tree, RequestTreeNode treeNode) {
            this.crafter = crafter;
            this.treeNode = treeNode;
            this.originalToDo = ((CraftingTemplate)crafter.getValue1()).getCrafter().getTodo();
            this.stacksOfWorkRequested = 0;
            this.setSize = ((CraftingTemplate)crafter.getValue1()).getResultStackSize();
            this.maxWorkSetsAvailable = (treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize;
        }

        int calculateMaxWork(int maxSetsToCraft) {
            int nCraftingSetsNeeded = maxSetsToCraft == 0 ? (this.treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize : maxSetsToCraft;
            if (nCraftingSetsNeeded == 0) {
                return 0;
            }
            CraftingTemplate template = (CraftingTemplate)this.crafter.getValue1();
            int stacks = RequestTreeNode.this.getSubRequests(nCraftingSetsNeeded, template);
            return stacks;
        }

        int addToWorkRequest(int extraWork) {
            int stacksRequested = (extraWork + this.setSize - 1) / this.setSize;
            this.stacksOfWorkRequested += stacksRequested;
            return stacksRequested * this.setSize;
        }

        boolean addWorkPromisesToTree() {
            CraftingTemplate template = (CraftingTemplate)this.crafter.getValue1();
            int setsToCraft = Math.min(this.stacksOfWorkRequested, this.maxWorkSetsAvailable);
            int setsAbleToCraft = this.calculateMaxWork(setsToCraft);
            if (setsAbleToCraft > 0) {
                LinkedList<IFilter> relays = new LinkedList<IFilter>();
                for (IFilter filter : (List)this.crafter.getValue2()) {
                    relays.add(filter);
                }
                LogisticsPromise job = template.generatePromise(setsAbleToCraft, relays);
                if (job.numberOfItems != setsAbleToCraft * this.setSize) {
                    throw new IllegalStateException("generatePromises not creating the promisesPromised; this is goign to end badly.");
                }
                this.treeNode.addPromise(job);
            }
            boolean isDone = setsToCraft == setsAbleToCraft;
            this.stacksOfWorkRequested = 0;
            return isDone;
        }

        public int compareTo(CraftingSorterNode o) {
            return this.currentToDo() - o.currentToDo();
        }

        public int currentToDo() {
            return this.originalToDo + this.stacksOfWorkRequested * this.setSize;
        }
    }
}

