/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.logisticspipes.MessageManager;
import logisticspipes.network.packets.PacketItems;
import logisticspipes.network.packets.PacketRequestGuiContent;
import logisticspipes.network.packets.PacketRequestSubmit;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.LiquidIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RequestHandler {
    public static void request(final EntityPlayerMP player, final PacketRequestSubmit packet, CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(5)) {
            player.func_70006_a("No Energy");
            return;
        }
        RequestTree.request(ItemIdentifier.get(packet.itemID, packet.dataValue, packet.tag).makeStack(packet.amount), pipe, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
                LinkedList<ItemMessage> list = new LinkedList<ItemMessage>();
                list.add(new ItemMessage(packet.itemID, packet.dataValue, packet.amount, packet.tag));
                MessageManager.requested((EntityPlayer)player, list);
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MessageManager.errors((EntityPlayer)player, list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        });
    }

    public static void simulate(EntityPlayerMP player, PacketRequestSubmit packet, CoreRoutedPipe pipe) {
        final LinkedList used = new LinkedList();
        final LinkedList missing = new LinkedList();
        RequestTree.simulate(ItemIdentifier.get(packet.itemID, packet.dataValue, packet.tag).makeStack(packet.amount), pipe, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                missing.addAll(list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
                used.addAll(items);
            }
        });
        MessageManager.simulated(player, used, missing);
    }

    public static void refresh(EntityPlayerMP player, CoreRoutedPipe pipe, DisplayOptions option) {
        HashMap _availableItems = option == DisplayOptions.SupplyOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getAvailableItems(pipe.getRouter().getIRoutersByCost()) : new HashMap();
        LinkedList _craftableItems = option == DisplayOptions.CraftOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost()) : new LinkedList();
        TreeSet<ItemIdentifierStack> _allItems = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry entry : _availableItems.entrySet()) {
            ItemIdentifierStack newStack = ((ItemIdentifier)entry.getKey()).makeStack((Integer)entry.getValue());
            _allItems.add(newStack);
        }
        for (ItemIdentifier itemIdentifier : _craftableItems) {
            if (_availableItems.containsKey(itemIdentifier)) continue;
            _allItems.add(itemIdentifier.makeStack(0));
        }
        MainProxy.sendPacketToPlayer(new PacketRequestGuiContent(_allItems).getPacket(), (Player)player);
    }

    public static void requestMacrolist(NBTTagCompound itemlist, CoreRoutedPipe requester, final EntityPlayer player) {
        if (!requester.useEnergy(5)) {
            player.func_70006_a("No Energy");
            return;
        }
        NBTTagList list = itemlist.func_74761_m("inventar");
        LinkedList<ItemIdentifierStack> transaction = new LinkedList<ItemIdentifierStack>();
        ArrayList<ItemMessage> items = new ArrayList<ItemMessage>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemnbt = (NBTTagCompound)list.func_74743_b(i);
            NBTTagCompound itemNBTContent = itemnbt.func_74775_l("nbt");
            if (!itemnbt.func_74764_b("nbt")) {
                itemNBTContent = null;
            }
            ItemIdentifierStack stack = ItemIdentifier.get(itemnbt.func_74762_e("id"), itemnbt.func_74762_e("data"), itemNBTContent).makeStack(itemnbt.func_74762_e("amount"));
            transaction.add(stack);
            items.add(new ItemMessage(stack));
        }
        RequestTree.request(transaction, requester, new RequestLog(){

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
                MainProxy.sendPacketToPlayer(new PacketItems((List)items, false).getPacket(), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MainProxy.sendPacketToPlayer(new PacketItems((List)list, true).getPacket(), (Player)player);
            }
        }, RequestTree.defaultRequestFlags);
    }

    public static String computerRequest(ItemIdentifierStack makeStack, CoreRoutedPipe pipe, boolean craftingOnly) {
        EnumSet<RequestTree.ActiveRequestType> requestFlags = craftingOnly ? EnumSet.of(RequestTree.ActiveRequestType.Craft) : EnumSet.of(RequestTree.ActiveRequestType.Craft, RequestTree.ActiveRequestType.Provide);
        if (!pipe.useEnergy(15)) {
            return "NO_POWER";
        }
        final String[] status = new String[1];
        RequestTree.request(makeStack, pipe, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
                status[0] = "DONE";
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                status[0] = "MISSING";
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        }, false, false, true, false, requestFlags);
        return status[0];
    }

    public static void refreshLiquid(EntityPlayerMP player, CoreRoutedPipe pipe) {
        TreeSet _allItems = SimpleServiceLocator.logisticsLiquidManager.getAvailableLiquid(pipe.getRouter().getIRoutersByCost());
        MainProxy.sendPacketToPlayer(new PacketRequestGuiContent(_allItems).getPacket(), (Player)player);
    }

    public static void requestLiquid(final EntityPlayerMP player, final PacketRequestSubmit packet, CoreRoutedPipe pipe, IRequestLiquid requester) {
        if (!pipe.useEnergy(10)) {
            player.func_70006_a("No Energy");
            return;
        }
        RequestTree.requestLiquid(LiquidIdentifier.get(packet.itemID, packet.dataValue), packet.amount, requester, new RequestLog(){

            @Override
            public void handleSucessfullRequestOf(ItemMessage item) {
                LinkedList<ItemMessage> list = new LinkedList<ItemMessage>();
                list.add(new ItemMessage(packet.itemID, packet.dataValue, packet.amount, packet.tag));
                MessageManager.requested((EntityPlayer)player, list);
            }

            @Override
            public void handleMissingItems(LinkedList list) {
                MessageManager.errors((EntityPlayer)player, list);
            }

            @Override
            public void handleSucessfullRequestOfList(LinkedList items) {
            }
        });
    }

    public static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

