/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import logisticspipes.utils.Pair3;

public class CraftingTemplate
implements Comparable {
    protected ItemIdentifierStack _result;
    protected ICraftItems _crafter;
    protected ArrayList _required = new ArrayList(9);
    protected ArrayList _requiredLiquid = new ArrayList();
    protected ArrayList _byproduct = new ArrayList(9);
    private final int priority;

    public CraftingTemplate(ItemIdentifierStack result, ICraftItems crafter, int priority) {
        this._result = result;
        this._crafter = crafter;
        this.priority = priority;
    }

    public void addRequirement(ItemIdentifierStack stack, IRequestItems crafter) {
        for (Pair i : this._required) {
            if (((ItemIdentifierStack)i.getValue1()).getItem() != stack.getItem() || i.getValue2() != crafter) continue;
            ((ItemIdentifierStack)i.getValue1()).stackSize += stack.stackSize;
            return;
        }
        this._required.add(new Pair(stack, crafter));
    }

    public void addRequirement(LiquidIdentifier liquid, Integer amount, IRequestLiquid crafter) {
        for (Pair3 i : this._requiredLiquid) {
            if (i.getValue1() != liquid || i.getValue3() != crafter) continue;
            i.setValue2((Integer)i.getValue2() + amount);
            return;
        }
        this._requiredLiquid.add(new Pair3(liquid, amount, crafter));
    }

    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (i.getItem() != stack.getItem()) continue;
            i.stackSize += stack.stackSize;
            return;
        }
        this._byproduct.add(stack);
    }

    public LogisticsPromise generatePromise(int nResultSets, List relays) {
        LogisticsPromise promise = new LogisticsPromise();
        promise.item = this._result.getItem();
        promise.numberOfItems = this._result.stackSize * nResultSets;
        promise.sender = this._crafter;
        promise.relayPoints = relays;
        return promise;
    }

    public ICraftItems getCrafter() {
        return this._crafter;
    }

    public int getPriority() {
        return this.priority;
    }

    public int compareTo(CraftingTemplate o) {
        int c = this.priority - o.priority;
        if (c == 0) {
            c = this._result.compareTo(o._result);
        }
        if (c == 0) {
            c = this._crafter.compareTo(o._crafter);
        }
        return c;
    }

    public boolean canCraft(ItemIdentifier item) {
        return item.equals(this._result);
    }

    public int getResultStackSize() {
        return this._result.stackSize;
    }

    ItemIdentifier getResultItem() {
        return this._result.getItem();
    }

    public List getByproduct() {
        return this._byproduct;
    }

    protected List getComponentItems(int nCraftingSetsNeeded) {
        ArrayList<Pair> stacks = new ArrayList<Pair>(this._required.size());
        for (Pair stack : this._required) {
            Pair pair = new Pair(((ItemIdentifierStack)stack.getValue1()).clone(), stack.getValue2());
            ((ItemIdentifierStack)pair.getValue1()).stackSize *= nCraftingSetsNeeded;
            stacks.add(pair);
        }
        return stacks;
    }

    protected List getComponentLiquid(int nCraftingSetsNeeded) {
        ArrayList<Pair3> stacks = new ArrayList<Pair3>(this._requiredLiquid.size());
        for (Pair3 stack : this._requiredLiquid) {
            stacks.add(new Pair3(stack.getValue1(), (Integer)stack.getValue2() * nCraftingSetsNeeded, stack.getValue3()));
        }
        return stacks;
    }
}

