/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import logisticspipes.api.IHUDArmor;
import logisticspipes.config.Configs;
import logisticspipes.hud.HUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.MathVector;
import logisticspipes.utils.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class LogisticsHUDRenderer {
    private LinkedList list = new LinkedList();
    private double lastXPos = 0.0;
    private double lastYPos = 0.0;
    private double lastZPos = 0.0;
    private ArrayList providers = new ArrayList();
    private static LogisticsHUDRenderer renderer = null;

    public void add(IHeadUpDisplayBlockRendererProvider provider) {
        IHeadUpDisplayBlockRendererProvider toRemove = null;
        for (IHeadUpDisplayBlockRendererProvider listedProvider : this.providers) {
            if (listedProvider.getX() != provider.getX() || listedProvider.getY() != provider.getY() || listedProvider.getZ() != provider.getZ()) continue;
            toRemove = listedProvider;
            break;
        }
        if (toRemove != null) {
            this.providers.remove(toRemove);
        }
        this.providers.add(provider);
    }

    public void remove(IHeadUpDisplayBlockRendererProvider provider) {
        this.providers.remove(provider);
    }

    public void clear() {
        this.providers.clear();
        LogisticsHUDRenderer.instance().clearList(false);
    }

    private void clearList(boolean flag) {
        if (flag) {
            for (IHeadUpDisplayRendererProvider renderer : this.list) {
                renderer.stopWaitching();
            }
        }
        this.list.clear();
    }

    private void refreshList(double x, double y, double z) {
        double dis;
        ArrayList<Pair> newList = new ArrayList<Pair>();
        for (IRouter router : SimpleServiceLocator.routerManager.getRouters()) {
            CoreRoutedPipe coreRoutedPipe;
            if (router == null || !((coreRoutedPipe = router.getPipe()) instanceof IHeadUpDisplayRendererProvider) || MainProxy.getDimensionForWorld(coreRoutedPipe.worldObj) != MainProxy.getDimensionForWorld((World)FMLClientHandler.instance().getClient().field_71441_e) || !((dis = Math.hypot((double)coreRoutedPipe.xCoord - x + 0.5, Math.hypot((double)coreRoutedPipe.yCoord - y + 0.5, (double)coreRoutedPipe.zCoord - z + 0.5))) < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE) || !(dis > 0.75)) continue;
            newList.add(new Pair(dis, (IHeadUpDisplayRendererProvider)((Object)coreRoutedPipe)));
            if (this.list.contains(coreRoutedPipe)) continue;
            ((IHeadUpDisplayRendererProvider)((Object)coreRoutedPipe)).startWaitching();
        }
        ArrayList<IHeadUpDisplayBlockRendererProvider> remove = new ArrayList<IHeadUpDisplayBlockRendererProvider>();
        for (IHeadUpDisplayBlockRendererProvider iHeadUpDisplayBlockRendererProvider : this.providers) {
            if (MainProxy.getDimensionForWorld(iHeadUpDisplayBlockRendererProvider.getWorld()) != MainProxy.getDimensionForWorld((World)FMLClientHandler.instance().getClient().field_71441_e)) continue;
            dis = Math.hypot((double)iHeadUpDisplayBlockRendererProvider.getX() - x + 0.5, Math.hypot((double)iHeadUpDisplayBlockRendererProvider.getY() - y + 0.5, (double)iHeadUpDisplayBlockRendererProvider.getZ() - z + 0.5));
            if (dis < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE && dis > 0.75 && !iHeadUpDisplayBlockRendererProvider.func_70320_p() && iHeadUpDisplayBlockRendererProvider.isExistend()) {
                newList.add(new Pair(dis, iHeadUpDisplayBlockRendererProvider));
                if (this.list.contains(iHeadUpDisplayBlockRendererProvider)) continue;
                iHeadUpDisplayBlockRendererProvider.startWaitching();
                continue;
            }
            if (!iHeadUpDisplayBlockRendererProvider.func_70320_p() && iHeadUpDisplayBlockRendererProvider.isExistend()) continue;
            remove.add(iHeadUpDisplayBlockRendererProvider);
        }
        for (IHeadUpDisplayBlockRendererProvider iHeadUpDisplayBlockRendererProvider : remove) {
            this.providers.remove(iHeadUpDisplayBlockRendererProvider);
        }
        if (newList.size() < 1) {
            this.clearList(false);
            return;
        }
        Collections.sort(newList, new Comparator(){

            public int compare(Pair o1, Pair o2) {
                if ((Double)o1.getValue1() < (Double)o2.getValue1()) {
                    return -1;
                }
                if ((Double)o1.getValue1() > (Double)o2.getValue1()) {
                    return 1;
                }
                return 0;
            }
        });
        for (IHeadUpDisplayRendererProvider iHeadUpDisplayRendererProvider : this.list) {
            boolean contains = false;
            for (Pair inpart : newList) {
                if (!((IHeadUpDisplayRendererProvider)inpart.getValue2()).equals(iHeadUpDisplayRendererProvider)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            iHeadUpDisplayRendererProvider.stopWaitching();
        }
        this.clearList(false);
        for (Pair pair : newList) {
            this.list.addLast(pair.getValue2());
        }
    }

    private boolean playerWearsHUD() {
        return FMLClientHandler.instance().getClient().field_71439_g != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b[3] != null && FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b[3].func_77973_b() instanceof IHUDArmor && ((IHUDArmor)FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b[3].func_77973_b()).isEnabled(FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b[3]);
    }

    public void renderPlayerDisplay(long renderTicks) {
    }

    public void renderWorldRelative(long renderTicks, float partialTick) {
        if (!this.displayRenderer()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (this.list.size() == 0 || Math.hypot(this.lastXPos - player.field_70165_t, Math.hypot(this.lastYPos - player.field_70163_u, this.lastZPos - player.field_70161_v)) > 0.5 || renderTicks % 10L == 0L && (this.lastXPos != player.field_70165_t || this.lastYPos != player.field_70163_u + (double)player.func_70047_e() || this.lastZPos != player.field_70161_v) || renderTicks % 600L == 0L) {
            this.refreshList(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            this.lastXPos = player.field_70165_t;
            this.lastYPos = player.field_70163_u + (double)player.func_70047_e();
            this.lastZPos = player.field_70161_v;
        }
        boolean cursorHandled = false;
        HUDConfig config = new HUDConfig(FMLClientHandler.instance().getClient().field_71439_g.field_71071_by.field_70460_b[3]);
        for (IHeadUpDisplayRendererProvider renderer : this.list) {
            if (renderer.getRenderer() == null || !renderer.getRenderer().display(config)) continue;
            GL11.glPushMatrix();
            if (!cursorHandled) {
                double z;
                double y;
                double x = (double)renderer.getX() + 0.5 - player.field_70165_t;
                if (Math.hypot(x, Math.hypot(y = (double)renderer.getY() + 0.5 - player.field_70163_u, z = (double)renderer.getZ() + 0.5 - player.field_70161_v)) < 0.75 || renderer instanceof IHeadUpDisplayBlockRendererProvider && (((IHeadUpDisplayBlockRendererProvider)renderer).func_70320_p() || !((IHeadUpDisplayBlockRendererProvider)renderer).isExistend())) {
                    this.refreshList(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    GL11.glPopMatrix();
                    break;
                }
                cursorHandled = this.handleCursor(renderer);
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.displayOneView(renderer, config, partialTick);
            GL11.glPopMatrix();
        }
    }

    private void displayOneView(IHeadUpDisplayRendererProvider renderer, HUDConfig config, float partialTick) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        double x = (double)renderer.getX() + 0.5 - player.field_70169_q - (player.field_70165_t - player.field_70169_q) * (double)partialTick;
        double y = (double)renderer.getY() + 0.5 - player.field_70167_r - (player.field_70163_u - player.field_70167_r) * (double)partialTick;
        double z = (double)renderer.getZ() + 0.5 - player.field_70166_s - (player.field_70161_v - player.field_70166_s) * (double)partialTick;
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(this.getAngle(z, x) + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-1.0f * this.getAngle(Math.hypot(x, z), y) + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.4f);
        GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
        float light = mc.field_71441_e.func_72957_l(renderer.getX(), renderer.getY(), renderer.getZ());
        boolean dark = light < 11.0f;
        renderer.getRenderer().renderHeadUpDisplay(Math.hypot(x, Math.hypot(y, z)), dark, mc, config);
    }

    private float getAngle(double x, double y) {
        return (float)(Math.atan2(x, y) * 360.0 / (Math.PI * 2));
    }

    public double up(double input) {
        input %= 360.0;
        while (input < 0.0 && !Double.isNaN(input) && !Double.isInfinite(input)) {
            input += 360.0;
        }
        return input;
    }

    private boolean handleCursor(IHeadUpDisplayRendererProvider renderer) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        MathVector playerView = MathVector.getFromAngles((double)((270.0f - player.field_70177_z) / 360.0f * -2.0f) * Math.PI, (double)(player.field_70125_A / 360.0f * -2.0f) * Math.PI);
        MathVector playerPos = new MathVector();
        playerPos.X = player.field_70165_t;
        playerPos.Y = player.field_70163_u;
        playerPos.Z = player.field_70161_v;
        MathVector panelPos = new MathVector();
        panelPos.X = (double)renderer.getX() + 0.5;
        panelPos.Y = (double)renderer.getY() + 0.5;
        panelPos.Z = (double)renderer.getZ() + 0.5;
        MathVector panelView = new MathVector();
        panelView.X = playerPos.X - panelPos.X;
        panelView.Y = playerPos.Y - panelPos.Y;
        panelView.Z = playerPos.Z - panelPos.Z;
        panelPos.add(panelView, 0.44);
        double d = panelPos.X * panelView.X + panelPos.Y * panelView.Y + panelPos.Z * panelView.Z;
        double c = panelView.X * playerPos.X + panelView.Y * playerPos.Y + panelView.Z * playerPos.Z;
        double b = panelView.X * playerView.X + panelView.Y * playerView.Y + panelView.Z * playerView.Z;
        double a = (d - c) / b;
        MathVector viewPos = new MathVector();
        viewPos.X = playerPos.X + a * playerView.X - panelPos.X;
        viewPos.Y = playerPos.Y + a * playerView.Y - panelPos.Y;
        viewPos.Z = playerPos.Z + a * playerView.Z - panelPos.Z;
        MathVector panelScalVector1 = new MathVector();
        if (panelView.Y == 0.0) {
            panelScalVector1.X = 0.0;
            panelScalVector1.Y = 1.0;
            panelScalVector1.Z = 0.0;
        } else {
            panelScalVector1 = panelView.getOrtogonal(-panelView.X, null, -panelView.Z).makeVectorLength(1.0);
        }
        MathVector panelScalVector2 = new MathVector();
        if (panelView.Z == 0.0) {
            panelScalVector2.X = 0.0;
            panelScalVector2.Y = 0.0;
            panelScalVector2.Z = 1.0;
        } else {
            panelScalVector2 = panelView.getOrtogonal(1.0, 0.0, null).makeVectorLength(1.0);
        }
        if (panelScalVector1.Y == 0.0) {
            return false;
        }
        double cursorY = -viewPos.Y / panelScalVector1.Y;
        MathVector restViewPos = viewPos.clone();
        restViewPos.X += cursorY * panelScalVector1.X;
        restViewPos.Y = 0.0;
        restViewPos.Z += cursorY * panelScalVector1.Z;
        double cursorX = panelScalVector2.X == 0.0 ? restViewPos.Z / panelScalVector2.Z : restViewPos.X / panelScalVector2.X;
        cursorX *= 106.38297872340426;
        cursorY *= 106.38297872340426;
        if (panelView.Z < 0.0) {
            cursorX *= -1.0;
        }
        if (panelView.Y < 0.0) {
            cursorY *= -1.0;
        }
        if (renderer.getRenderer().cursorOnWindow((int)cursorX, (int)cursorY)) {
            renderer.getRenderer().handleCursor((int)cursorX, (int)cursorY);
            return true;
        }
        return false;
    }

    public boolean displayRenderer() {
        if (!this.displayHUD() && this.list.size() != 0) {
            this.clearList(true);
        }
        return this.displayHUD();
    }

    private boolean displayHUD() {
        return this.playerWearsHUD() && FMLClientHandler.instance().getClient().field_71462_r == null && FMLClientHandler.instance().getClient().field_71474_y.field_74320_O == 0 && !FMLClientHandler.instance().getClient().field_71474_y.field_74319_N;
    }

    public static LogisticsHUDRenderer instance() {
        if (renderer == null) {
            renderer = new LogisticsHUDRenderer();
        }
        return renderer;
    }
}

