/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.thaumcraft;

import buildcraft.BuildCraftSilicon;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.IThaumCraftProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.client.lib.UtilsFX;

public class ThaumCraftProxy
implements IThaumCraftProxy {
    private Item itemShard;

    public ThaumCraftProxy() {
        block2: {
            try {
                Class<?> tcConfig = Class.forName("thaumcraft.common.Config");
                this.itemShard = (Item)tcConfig.getField("itemShard").get(null);
            }
            catch (Exception e) {
                if (!LogisticsPipes.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void renderAspectsDown(ItemStack item, int x, int y, GuiScreen gui) {
        GL11.glPushMatrix();
        Minecraft mc = FMLClientHandler.instance().getClient();
        ObjectTags tags = this.getTagsForStack(item);
        tags = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)item, (ObjectTags)tags);
        if (tags != null) {
            int index = 0;
            for (EnumTag tag : tags.getAspectsSorted()) {
                int yPos = y + index * 18;
                UtilsFX.drawTag((Minecraft)mc, (int)x, (int)yPos, (EnumTag)tag, (int)tags.getAmount(tag), (GuiScreen)gui, (boolean)true, (boolean)false);
                ++index;
            }
        }
        GL11.glPopMatrix();
    }

    public ObjectTags getTagsForStack(ItemStack stack) {
        if (stack == null) {
            return new ObjectTags();
        }
        ObjectTags ot = ThaumcraftApiHelper.getObjectTags((ItemStack)stack);
        ot = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)stack, (ObjectTags)ot);
        return ot;
    }

    @Override
    public void renderAspectAt(Object etag, int x, int y, GuiScreen gui) {
        if (!(etag instanceof EnumTag)) {
            return;
        }
        GL11.glPushMatrix();
        Minecraft mc = FMLClientHandler.instance().getClient();
        UtilsFX.drawTag((Minecraft)mc, (int)x, (int)y, (EnumTag)((EnumTag)etag), (int)1, (GuiScreen)gui, (boolean)true, (boolean)false);
        GL11.glPopMatrix();
    }

    @Override
    public void renderAspectsInGrid(List etagIDs, int x, int y, int legnth, int width, GuiScreen gui) {
        if (etagIDs.size() == 0) {
            return;
        }
        int xshift = x;
        int yshift = y;
        int currentListIndex = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < legnth; ++j) {
                this.renderAspectAt(EnumTag.get((int)((Integer)etagIDs.get(currentListIndex))), xshift, yshift, gui);
                if (++currentListIndex == etagIDs.size()) {
                    return;
                }
                xshift += 18;
            }
            xshift = x;
            yshift += 18;
        }
    }

    @Override
    public List getListOfTagIDsForStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        ObjectTags tags = this.getTagsForStack(stack);
        EnumTag[] tagArray = tags.getAspectsSorted();
        if (tagArray.length == 0 || tagArray == null) {
            return null;
        }
        for (int i = 0; i < tagArray.length; ++i) {
            if (tagArray[i] == null) continue;
            int ID = tagArray[i].id;
            list.add(ID);
        }
        return list;
    }

    @Override
    public String getNameForTagID(int id) {
        return EnumTag.get((int)id).name;
    }

    @Override
    public void addCraftingRecipes() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 30), new Object[]{"wGe", "rBr", "fra", Character.valueOf('w'), new ItemStack(this.itemShard, 1, 2), Character.valueOf('e'), new ItemStack(this.itemShard, 1, 3), Character.valueOf('f'), new ItemStack(this.itemShard, 1, 1), Character.valueOf('a'), new ItemStack(this.itemShard, 1, 0), Character.valueOf('G'), new ItemStack(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
    }
}

