/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class CrateInventoryHandler
extends SpecialInventoryHandler {
    private static Class crateClass;
    private static Method getPileData;
    private static Class cratePileDataClass;
    private static Method getNumItems;
    private static Method removeItems;
    private static Method getItemStack;
    private static Method getItemCount;
    private static Method spaceForItem;
    private static Method addItems;
    private final TileEntity _tile;
    private final boolean _hideOnePerStack;
    LinkedList cached;

    private CrateInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public CrateInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        try {
            crateClass = Class.forName("net.mcft.copy.betterstorage.block.crate.TileEntityCrate");
            getPileData = crateClass.getDeclaredMethod("getPileData", new Class[0]);
            cratePileDataClass = Class.forName("net.mcft.copy.betterstorage.block.crate.CratePileData");
            getNumItems = cratePileDataClass.getDeclaredMethod("getNumItems", new Class[0]);
            removeItems = cratePileDataClass.getDeclaredMethod("removeItems", ItemStack.class, Integer.TYPE);
            getItemStack = cratePileDataClass.getDeclaredMethod("getItemStack", Integer.TYPE);
            getItemCount = cratePileDataClass.getDeclaredMethod("getItemCount", ItemStack.class);
            spaceForItem = cratePileDataClass.getDeclaredMethod("spaceForItem", ItemStack.class);
            addItems = cratePileDataClass.getDeclaredMethod("addItems", ItemStack.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isType(TileEntity tile) {
        return crateClass.isAssignableFrom(tile.getClass());
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new CrateInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int numitems = (Integer)getNumItems.invoke(cratePileData, new Object[0]);
            for (int i = 0; i < numitems; ++i) {
                ItemStack itemStack = (ItemStack)getItemStack.invoke(cratePileData, i);
                result.add(ItemIdentifier.get(itemStack));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Map getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map getItemsAndCount(boolean linked) {
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int numitems = (Integer)getNumItems.invoke(cratePileData, new Object[0]);
            HashMap<ItemIdentifier, Integer> map = new HashMap<ItemIdentifier, Integer>((int)((double)numitems * 1.5));
            for (int i = 0; i < numitems; ++i) {
                ItemStack itemStack = (ItemStack)getItemStack.invoke(cratePileData, i);
                ItemIdentifier itemId = ItemIdentifier.get(itemStack);
                int stackSize = itemStack.field_77994_a - (this._hideOnePerStack ? 1 : 0);
                Integer m = (Integer)map.get(itemId);
                if (m == null) {
                    map.put(itemId, stackSize);
                    continue;
                }
                map.put(itemId, m + stackSize);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new HashMap();
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int count = (Integer)getItemCount.invoke(cratePileData, itemIdent.unsafeMakeNormalStack(1));
            if (count <= (this._hideOnePerStack ? 1 : 0)) {
                return null;
            }
            return (ItemStack)removeItems.invoke(cratePileData, itemIdent.makeNormalStack(1), 1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int count = (Integer)getItemCount.invoke(cratePileData, itemIdent.unsafeMakeNormalStack(1));
            return count > 0;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            if (!Item.field_77698_e[itemIdent.itemID].func_77645_m()) {
                int count = (Integer)getItemCount.invoke(cratePileData, itemIdent.unsafeMakeNormalStack(1));
                return count > 0;
            }
            int numitems = (Integer)getNumItems.invoke(cratePileData, new Object[0]);
            for (int i = 0; i < numitems; ++i) {
                ItemStack itemStack = (ItemStack)getItemStack.invoke(cratePileData, i);
                ItemIdentifier itemId = ItemIdentifier.getUndamaged(itemStack);
                if (itemId != itemIdent) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int space = (Integer)spaceForItem.invoke(cratePileData, itemIdent.unsafeMakeNormalStack(1));
            return space;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (doAdd) {
            ItemStack tst = stack.func_77946_l();
            if (tst.field_77990_d != null && tst.field_77990_d.func_74740_e().equals("")) {
                tst.field_77990_d.func_74738_o("tag");
            }
            try {
                Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
                ItemStack overflow = (ItemStack)addItems.invoke(cratePileData, tst);
                st.field_77994_a = stack.field_77994_a;
                if (overflow != null) {
                    st.field_77994_a -= overflow.field_77994_a;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            int space = this.roomForItem(ItemIdentifier.get(stack), 0);
            st.field_77994_a = Math.max(Math.min(space, stack.field_77994_a), 0);
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map map = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        for (Map.Entry e : map.entrySet()) {
            this.cached.add(e);
        }
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        Map.Entry entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((Integer)(entry = (Map.Entry)this.cached.get(i)).getValue() == 0) {
            return null;
        }
        return ((ItemIdentifier)entry.getKey()).makeNormalStack((Integer)entry.getValue());
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.cached == null) {
            this.initCache();
        }
        Map.Entry entry = (Map.Entry)this.cached.get(i);
        ItemStack stack = ((ItemIdentifier)entry.getKey()).makeNormalStack(j);
        ItemStack extracted = null;
        try {
            Object cratePileData = getPileData.invoke((Object)this._tile, new Object[0]);
            int count = (Integer)getItemCount.invoke(cratePileData, stack);
            if (count <= (this._hideOnePerStack ? 1 : 0)) {
                return null;
            }
            extracted = (ItemStack)removeItems.invoke(cratePileData, stack, 1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        entry.setValue((Integer)entry.getValue() - j);
        return extracted;
    }
}

