/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.side;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.server.FMLServerHandler;
import java.io.File;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSignTileEntity;
import logisticspipes.blocks.LogisticsSolderingTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.network.packets.PacketNameUpdatePacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;

public class ServerProxy
implements IProxy {
    private Configuration langDatabase = new Configuration(new File("config/LogisticsPipes-LangDatabase.cfg"));
    private long saveThreadTime = 0L;

    @Override
    public String getSide() {
        return "Server";
    }

    @Override
    public World getWorld() {
        return null;
    }

    @Override
    public void registerTileEntitis() {
        GameRegistry.registerTileEntity(LogisticsSignTileEntity.class, (String)"net.minecraft.src.buildcraft.logisticspipes.blocks.LogisticsTileEntiy");
        GameRegistry.registerTileEntity(LogisticsSignTileEntity.class, (String)"logisticspipes.blocks.LogisticsSignTileEntity");
        GameRegistry.registerTileEntity(LogisticsSolderingTileEntity.class, (String)"logisticspipes.blocks.LogisticsSolderingTileEntity");
        GameRegistry.registerTileEntity((Class)LogisticsPipes.powerTileEntity, (String)"logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity");
        GameRegistry.registerTileEntity(LogisticsSecurityTileEntity.class, (String)"logisticspipes.blocks.LogisticsSecurityTileEntity");
        if (!Configs.LOGISTICS_TILE_GENERIC_PIPE_REPLACEMENT_DISABLED) {
            GameRegistry.registerTileEntity((Class)BuildCraftProxy.logisticsTileGenericPipe, (String)"logisticspipes.pipes.basic.LogisticsTileGenericPipe");
        }
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return null;
    }

    @Override
    public boolean isMainThreadRunning() {
        return FMLServerHandler.instance().getServer().func_71278_l();
    }

    @Override
    public void registerParticles() {
    }

    private String tryGetName(ItemIdentifier item) {
        String name = "???";
        try {
            name = Item.field_77698_e[item.itemID].func_77628_j(item.unsafeMakeNormalStack(1));
            if (name == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                name = Item.field_77698_e[item.itemID].func_77667_c(item.unsafeMakeNormalStack(1));
                if (name == null) {
                    throw new Exception();
                }
            }
            catch (Exception e1) {
                try {
                    name = Item.field_77698_e[item.itemID].func_77658_a();
                    if (name == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    name = "???";
                }
            }
        }
        return name;
    }

    private String getNameForCategory(String category, ItemIdentifier item) {
        String name = this.langDatabase.get(category, "name", "").getString();
        if (name.equals("")) {
            this.saveLangDatabase();
            if (item.unsafeMakeNormalStack(1).func_77984_f()) {
                return this.tryGetName(item);
            }
            return "LP|UNDEFINED";
        }
        return name;
    }

    private void setNameForCategory(String category, ItemIdentifier item, String newName) {
        this.langDatabase.get(category, "name", newName).set(newName);
        this.saveLangDatabase();
    }

    private void saveLangDatabase() {
        this.saveThreadTime = System.currentTimeMillis() + 30000L;
    }

    @Override
    public String getName(ItemIdentifier item) {
        String category = "";
        category = item.unsafeMakeNormalStack(1).func_77984_f() ? "itemNames." + Integer.toString(item.itemID) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(item.itemID) : "itemNames." + Integer.toString(item.itemID) + "." + Integer.toString(item.itemDamage));
        String name = this.getNameForCategory(category, item);
        if (name.equals("LP|UNDEFINED")) {
            if (item.itemDamage == 0) {
                return this.tryGetName(item);
            }
            category = "itemNames." + Integer.toString(item.itemID);
            name = this.getNameForCategory(category, item);
            if (name.equals("LP|UNDEFINED")) {
                return this.tryGetName(item);
            }
        }
        return name;
    }

    @Override
    public void updateNames(ItemIdentifier item, String name) {
        String category = "";
        category = item.unsafeMakeNormalStack(1).func_77984_f() ? "itemNames." + Integer.toString(item.itemID) : (item.itemDamage == 0 ? "itemNames." + Integer.toString(item.itemID) : "itemNames." + Integer.toString(item.itemID) + "." + Integer.toString(item.itemDamage));
        this.setNameForCategory(category, item, name);
    }

    @Override
    public void tick() {
        if (this.saveThreadTime != 0L && this.saveThreadTime < System.currentTimeMillis()) {
            this.saveThreadTime = 0L;
            this.langDatabase.save();
            LogisticsPipes.log.info("LangDatabase saved");
        }
    }

    @Override
    public void sendNameUpdateRequest(Player player) {
        for (String category : this.langDatabase.getCategoryNames()) {
            String name;
            if (!category.startsWith("itemNames.") || !(name = this.langDatabase.get(category, "name", "").getString()).equals("")) continue;
            String itemPart = category.substring(10);
            String metaPart = "0";
            if (itemPart.contains(".")) {
                String[] itemPartSplit = itemPart.split(".");
                itemPart = itemPartSplit[0];
                metaPart = itemPartSplit[1];
            }
            int id = Integer.valueOf(itemPart);
            int meta = Integer.valueOf(metaPart);
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((Packet250CustomPayload)new PacketNameUpdatePacket(ItemIdentifier.get(id, meta, null), "-").getPacket(), player);
        }
    }

    @Override
    public int getDimensionForWorld(World world) {
        if (world instanceof WorldServer) {
            return ((WorldServer)world).field_73011_w.field_76574_g;
        }
        if (world instanceof WorldClient) {
            return ((WorldClient)world).field_73011_w.field_76574_g;
        }
        return world.func_72912_H().func_76076_i();
    }

    @Override
    public TileGenericPipe getPipeInDimensionAt(int dimension, int x, int y, int z, EntityPlayer player) {
        return ServerProxy.getPipe((World)DimensionManager.getWorld((int)dimension), x, y, z);
    }

    protected static TileGenericPipe getPipe(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }

    @Override
    public void addLogisticsPipesOverride(int index, String override1, String override2, boolean flag) {
    }
}

