/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.forestry;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.recipes.RecipeManagers;
import java.lang.reflect.Method;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.interfaces.IForestryProxy;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ForestryProxy
implements IForestryProxy {
    private Class analyserClass;
    private Method localize;
    private Item propolis;
    private Item pollen;
    private LiquidStack honey;
    private final boolean has_all;
    private IBeeRoot root;

    public ForestryProxy() {
        boolean initsuccessful;
        block2: {
            initsuccessful = false;
            try {
                this.analyserClass = Class.forName("forestry.core.gadgets.MachineAnalyzer");
                Class<?> stringUtil = Class.forName("forestry.core.utils.StringUtil");
                this.localize = stringUtil.getDeclaredMethod("localize", String.class);
                this.localize.setAccessible(true);
                this.propolis = ItemInterface.getItem((String)"propolis").func_77973_b();
                this.pollen = ItemInterface.getItem((String)"pollen").func_77973_b();
                this.honey = LiquidDictionary.getLiquid((String)"honey", (int)1500);
                this.root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
                initsuccessful = true;
            }
            catch (Exception e) {
                if (!LogisticsPipes.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        this.has_all = initsuccessful;
    }

    @Override
    public boolean isBee(ItemIdentifier item) {
        return this.isBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isBee(ItemStack item) {
        if (!this.has_all) {
            return false;
        }
        return this.root.isMember(item);
    }

    @Override
    public boolean isAnalysedBee(ItemIdentifier item) {
        return this.isAnalysedBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isAnalysedBee(ItemStack item) {
        if (!this.isBee(item)) {
            return false;
        }
        return this.root.getMember(item).isAnalyzed();
    }

    @Override
    public boolean isTileAnalyser(TileEntity tile) {
        block4: {
            if (!this.has_all) {
                return false;
            }
            try {
                if (this.analyserClass.isAssignableFrom(tile.getClass())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!LogisticsPipes.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean forestryEnabled() {
        return this.has_all;
    }

    @Override
    public boolean isKnownAlleleId(String allele, World world) {
        if (!this.has_all) {
            return false;
        }
        if (!(AlleleManager.alleleRegistry.getAllele(allele) instanceof IAlleleBeeSpecies)) {
            return false;
        }
        if (!((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele)).isSecret()) {
            return true;
        }
        return this.root.getBreedingTracker(world, MainProxy.proxy.getClientPlayer().field_71092_bJ).isDiscovered((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele));
    }

    @Override
    public String getAlleleName(String uid) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleSpecies)) {
            return "";
        }
        return ((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid)).getName();
    }

    private String getFirstValidAllele(World world) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            return allele.getUID();
        }
        return "";
    }

    private String getLastValidAllele(World world) {
        String uid = "";
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            uid = allele.getUID();
        }
        return uid;
    }

    @Override
    public String getNextAlleleId(String uid, World world) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getFirstValidAllele(world);
        }
        boolean next = false;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (next && this.isKnownAlleleId(allele.getUID(), world)) {
                return allele.getUID();
            }
            if (!allele.getUID().equals(uid)) continue;
            next = true;
        }
        return "";
    }

    @Override
    public String getPrevAlleleId(String uid, World world) {
        if (!this.has_all) {
            return "";
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getLastValidAllele(world);
        }
        IAllele lastAllele = null;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (allele.getUID().equals(uid)) {
                if (lastAllele == null) {
                    return "";
                }
                return lastAllele.getUID();
            }
            if (!this.isKnownAlleleId(allele.getUID(), world)) continue;
            lastAllele = allele;
        }
        return "";
    }

    @Override
    public String getFirstAlleleId(ItemStack bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return this.root.getMember(bee).getGenome().getPrimary().getUID();
    }

    @Override
    public String getSecondAlleleId(ItemStack bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return this.root.getMember(bee).getGenome().getSecondary().getUID();
    }

    @Override
    public boolean isDrone(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.isDrone(bee);
    }

    @Override
    public boolean isPrincess(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        if (this.isQueen(bee)) {
            return false;
        }
        return !this.isDrone(bee);
    }

    @Override
    public boolean isQueen(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.isMated(bee);
    }

    @Override
    public boolean isPurebred(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).isPureBred(EnumBeeChromosome.SPECIES.ordinal());
    }

    @Override
    public boolean isNocturnal(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getNocturnal();
    }

    @Override
    public boolean isPureNocturnal(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getNocturnal() && this.root.getMember(bee).isPureBred(EnumBeeChromosome.NOCTURNAL.ordinal());
    }

    @Override
    public boolean isFlyer(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getTolerantFlyer();
    }

    @Override
    public boolean isPureFlyer(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getTolerantFlyer() && this.root.getMember(bee).isPureBred(EnumBeeChromosome.TOLERANT_FLYER.ordinal());
    }

    @Override
    public boolean isCave(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getCaveDwelling();
    }

    @Override
    public boolean isPureCave(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getCaveDwelling() && this.root.getMember(bee).isPureBred(EnumBeeChromosome.CAVE_DWELLING.ordinal());
    }

    @Override
    public String getForestryTranslation(String input) {
        if (!this.has_all) {
            return input;
        }
        try {
            return (String)this.localize.invoke(null, input.toLowerCase());
        }
        catch (Exception e) {
            if (LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            return input;
        }
    }

    @Override
    public void addCraftingRecipes() {
        if (!this.has_all) {
            return;
        }
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ItemStack(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 9), new Object[]{"CrC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 10), new Object[]{" p ", "r r", "CwC", Character.valueOf('p'), this.pollen, Character.valueOf('C'), this.propolis, Character.valueOf('w'), BuildCraftTransport.pipeItemsWood, Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 11), new Object[]{"CGD", "r r", "DrC", Character.valueOf('C'), "dyeBlack", Character.valueOf('D'), "dyePurple", Character.valueOf('G'), this.pollen, Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ItemStack(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ItemStack(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ItemStack(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(25, this.honey, new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0), new ItemStack(LogisticsPipes.LogisticsApiaristSinkPipe, 1, 0), new Object[]{"CrC", "r r", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), Item.field_77767_aC});
        if (Configs.MANDATORY_CARPENTER_RECIPES) {
            return;
        }
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 8), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ItemStack(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 9), new Object[]{"CrC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 1)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 10), new Object[]{" p ", "rBr", "CwC", Character.valueOf('p'), this.pollen, Character.valueOf('C'), this.propolis, Character.valueOf('w'), BuildCraftTransport.pipeItemsWood, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 11), new Object[]{"CGD", "rBr", "DrC", Character.valueOf('C'), "dyeBlack", Character.valueOf('D'), "dyePurple", Character.valueOf('G'), this.pollen, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)}));
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), new ItemStack(BuildCraftSilicon.redstoneChipset, 1, 1), Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(LogisticsPipes.LogisticsApiaristSinkPipe, 1, 0), new Object[]{"CrC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('B'), new ItemStack(LogisticsPipes.LogisticsBasicPipe, 1, 0)});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconIndexForAlleleId(String uid, int phase) {
        if (!this.has_all) {
            return null;
        }
        IAllele bSpecies = AlleleManager.alleleRegistry.getAllele(uid);
        if (!(bSpecies instanceof IAlleleBeeSpecies)) {
            bSpecies = this.root.getDefaultTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        }
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)bSpecies;
        return species.getIcon(EnumBeeType.DRONE, phase);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorForAlleleId(String uid, int phase) {
        if (!this.has_all) {
            return 0xFFFFFF;
        }
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(uid);
        return species.getIconColour(phase);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPassesForAlleleId(String uid) {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconFromTextureManager(String name) {
        return ForestryAPI.textureManager.getDefault(name);
    }
}

