/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.cc;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.CCHelper;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCQueued;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.security.PermissionException;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.WorldUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class LogisticsTileGenericPipe_CC
extends LogisticsTileGenericPipe
implements IPeripheral {
    private boolean[] turtleConnect = new boolean[7];
    private HashMap connections = new HashMap();
    private boolean init = false;
    private HashMap commandMap = new HashMap();
    private Map commands = new LinkedHashMap();
    private String typeName = "";
    private IComputerAccess lastPC = null;

    private CCType getType(Class clazz) {
        CCType type;
        while ((type = clazz.getAnnotation(CCType.class)) == null) {
            if (clazz.getSuperclass() == Object.class) {
                return null;
            }
            clazz = clazz.getSuperclass();
        }
        return type;
    }

    private void init() {
        if (!this.init) {
            this.init = true;
            CoreRoutedPipe pipe = this.getCPipe();
            if (pipe == null) {
                return;
            }
            CCType type = this.getType(pipe.getClass());
            if (type == null) {
                return;
            }
            this.typeName = type.name();
            int i = 0;
            Class<?> clazz = pipe.getClass();
            while (true) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(CCCommand.class)) continue;
                    for (Class<?> param : method.getParameterTypes()) {
                        if (param.getName().startsWith("java")) continue;
                        throw new InternalError("Internal Excption (Code: 2)");
                    }
                    this.commandMap.put(i, method.getName());
                    this.commands.put(i, method);
                    ++i;
                }
                if (clazz.getSuperclass() == Object.class) break;
                clazz = clazz.getSuperclass();
            }
        }
    }

    private boolean argumentsMatch(Method method, Object[] arguments) {
        int i = 0;
        for (Class<?> args : method.getParameterTypes()) {
            if (!arguments[i].getClass().equals(args)) {
                return false;
            }
            ++i;
        }
        return arguments.length == i;
    }

    public boolean arePipesConnected(TileEntity with, ForgeDirection dir) {
        if (SimpleServiceLocator.ccProxy.isTurtle(with) && !this.turtleConnect[OrientationsUtil.getOrientationOfTilewithTile((TileEntity)this, with).ordinal()]) {
            return false;
        }
        return super.arePipesConnected(with, dir);
    }

    public String getType() {
        this.init();
        return this.typeName;
    }

    public String[] getMethodNames() {
        this.init();
        LinkedList<String> list = new LinkedList<String>();
        list.add("help");
        list.add("commandHelp");
        for (int i = 0; i < this.commandMap.size(); ++i) {
            list.add((String)this.commandMap.get(i));
        }
        return list.toArray(new String[list.size()]);
    }

    public Object[] callMethod(IComputerAccess computer, int methodId, Object[] arguments) throws Exception {
        Object result;
        if (this.getCPipe() == null) {
            throw new InternalError("Pipe is not a LogisticsPipe");
        }
        this.init();
        this.lastPC = computer;
        if (methodId == 0) {
            StringBuilder help = new StringBuilder();
            StringBuilder head = new StringBuilder();
            StringBuilder head2 = new StringBuilder();
            head.append("PipeType: ");
            head.append(this.typeName);
            head.append("\n");
            head2.append("Commands: \n");
            for (Integer num : this.commands.keySet()) {
                int number;
                Method method = (Method)this.commands.get(num);
                StringBuilder command = new StringBuilder();
                if (help.length() != 0) {
                    command.append("\n");
                }
                if ((number = num.intValue()) < 10) {
                    command.append(" ");
                }
                command.append(number);
                if (method.isAnnotationPresent(CCQueued.class)) {
                    command.append(" Q");
                } else {
                    command.append("  ");
                }
                command.append(": ");
                command.append(method.getName());
                StringBuilder param = new StringBuilder();
                param.append("(");
                boolean a = false;
                for (Class<?> clazz : method.getParameterTypes()) {
                    if (a) {
                        param.append(", ");
                    }
                    param.append(clazz.getSimpleName());
                    a = true;
                }
                param.append(")");
                if (param.toString().length() + command.length() > 36) {
                    command.append("\n      ---");
                }
                command.append(param.toString());
                help.append(command.toString());
            }
            String commands = help.toString();
            String[] lines = commands.split("\n");
            if (lines.length > 16) {
                int pageNumber = 1;
                if (arguments.length > 0 && arguments[0] instanceof Double && (pageNumber = (int)Math.floor((Double)arguments[0])) < 1) {
                    pageNumber = 1;
                }
                StringBuilder page = new StringBuilder();
                page.append(head.toString());
                page.append("Page ");
                page.append(pageNumber);
                page.append(" of ");
                page.append((int)(Math.floor(lines.length / 10) + (double)(lines.length % 10 != 0 ? 1 : 0)));
                page.append("\n");
                page.append(head2.toString());
                int from = --pageNumber * 11;
                int to = pageNumber * 11 + 10;
                for (int i = from; i < to; ++i) {
                    if (i < lines.length) {
                        page.append(lines[i]);
                    }
                    if (i >= to - 1) continue;
                    page.append("\n");
                }
                return new Object[]{page.toString()};
            }
            for (int i = 0; i < 16 - lines.length; ++i) {
                String buffer = head.toString();
                head = new StringBuilder();
                head.append("\n").append(buffer);
            }
            return new Object[]{"" + head + head2 + help};
        }
        if (--methodId == 0) {
            if (arguments.length != 1) {
                return new Object[]{"Wrong Argument Count"};
            }
            if (!(arguments[0] instanceof Double)) {
                return new Object[]{"Wrong Argument Type"};
            }
            Integer number = (int)Math.floor((Double)arguments[0]);
            if (!this.commands.containsKey(number)) {
                return new Object[]{"No command with that index"};
            }
            Method method = (Method)this.commands.get(number);
            StringBuilder help = new StringBuilder();
            help.append("---------------------------------\n");
            help.append("Command: ");
            help.append(method.getName());
            help.append("\n");
            help.append("Parameter: ");
            if (method.getParameterTypes().length > 0) {
                help.append("\n");
                boolean a = false;
                for (Class<?> clazz : method.getParameterTypes()) {
                    if (a) {
                        help.append(", ");
                    }
                    help.append(clazz.getSimpleName());
                    a = true;
                }
                help.append("\n");
            } else {
                help.append("NONE\n");
            }
            help.append("Return Type: ");
            help.append(method.getReturnType().getName());
            help.append("\n");
            help.append("Description: \n");
            help.append(method.getAnnotation(CCCommand.class).description());
            return new Object[]{help.toString()};
        }
        String name = (String)this.commandMap.get(--methodId);
        Method match = null;
        for (Method method : this.commands.values()) {
            if (!method.getName().equalsIgnoreCase(name) || !this.argumentsMatch(method, arguments)) continue;
            match = method;
            break;
        }
        if (match == null) {
            StringBuilder error = new StringBuilder();
            error.append("No such method.");
            boolean handled = false;
            for (Method method : this.commands.values()) {
                if (!method.getName().equalsIgnoreCase(name)) continue;
                if (handled) {
                    error.append("\n");
                }
                handled = true;
                error.append(method.getName());
                error.append("(");
                boolean a = false;
                for (Class<?> clazz : method.getParameterTypes()) {
                    if (a) {
                        error.append(", ");
                    }
                    error.append(clazz.getName());
                    a = true;
                }
                error.append(")");
            }
            if (!handled) {
                error = new StringBuilder();
                error.append("Internal Excption (Code: 1, ");
                error.append(name);
                error.append(")");
            }
            throw new UnsupportedOperationException(error.toString());
        }
        if (match.getAnnotation(CCCommand.class).needPermission()) {
            this.getCPipe().checkCCAccess();
        }
        if (match.getAnnotation(CCQueued.class) != null) {
            int count;
            final Method m = match;
            String prefunction = null;
            prefunction = match.getAnnotation(CCQueued.class).prefunction();
            if (!prefunction.equals("") && this.pipe != null) {
                Class<?> clazz = this.pipe.getClass();
                while (true) {
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (!method.getName().equals(prefunction)) continue;
                        if (method.getParameterTypes().length > 0) {
                            throw new InternalError("Internal Excption (Code: 3)");
                        }
                        try {
                            method.invoke((Object)this.pipe, new Object[0]);
                            break;
                        }
                        catch (InvocationTargetException e) {
                            if (e.getTargetException() instanceof Exception) {
                                throw (Exception)e.getTargetException();
                            }
                            throw e;
                        }
                    }
                    if (clazz.getSuperclass() == Object.class) break;
                    clazz = clazz.getSuperclass();
                }
            }
            final Object[] a = arguments;
            final Object[] resultArray = new Object[1];
            final Boolean[] booleans = new Boolean[]{false, false};
            QueuedTasks.queueTask(new Callable(){

                public Object call() throws Exception {
                    try {
                        Object result = m.invoke((Object)LogisticsTileGenericPipe_CC.this.pipe, a);
                        if (result != null) {
                            resultArray[0] = result;
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof PermissionException) {
                            booleans[1] = true;
                            resultArray[0] = e.getTargetException();
                        }
                        booleans[0] = true;
                        throw e;
                    }
                    booleans[0] = true;
                    return null;
                }
            });
            for (count = 0; !booleans[0].booleanValue() && count < 200; ++count) {
                Thread.sleep(10L);
            }
            if (count >= 199) {
                CoreRoutedPipe pipe = this.getCPipe();
                new Exception("Took too long (" + m.getName() + "," + pipe.getClass().getName() + ")").printStackTrace();
                throw new Exception("Took too long");
            }
            if (m.getReturnType().equals(Void.class)) {
                return null;
            }
            if (booleans[1].booleanValue()) {
                throw (Exception)resultArray[0];
            }
            return CCHelper.createArray(CCHelper.getAnswer(resultArray[0]));
        }
        try {
            result = match.invoke((Object)this.pipe, arguments);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        return CCHelper.createArray(CCHelper.getAnswer(result));
    }

    public void scheduleNeighborChange() {
        super.scheduleNeighborChange();
        boolean[] connected = new boolean[6];
        WorldUtil world = new WorldUtil(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        LinkedList adjacent = world.getAdjacentTileEntities(false);
        for (AdjacentTile aTile : adjacent) {
            if (!SimpleServiceLocator.ccProxy.isTurtle(aTile.tile)) continue;
            connected[aTile.orientation.ordinal()] = true;
        }
        for (int i = 0; i < 6; ++i) {
            if (connected[i]) continue;
            this.turtleConnect[i] = false;
        }
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        ForgeDirection ori = SimpleServiceLocator.ccProxy.getOrientation(computer, (TileEntity)this);
        this.connections.put(computer, ori);
        this.scheduleNeighborChange();
    }

    public void detach(IComputerAccess computer) {
        this.connections.remove(computer);
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            nbttagcompound.func_74757_a("turtleConnect_" + i, this.turtleConnect[i]);
        }
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            this.turtleConnect[i] = nbttagcompound.func_74767_n("turtleConnect_" + i);
        }
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        for (IComputerAccess computer : this.connections.keySet()) {
            computer.queueEvent(event, arguments);
        }
    }

    @Override
    public void setTurtrleConnect(boolean flag) {
        this.turtleConnect[((ForgeDirection)this.connections.get((Object)this.lastPC)).ordinal()] = flag;
        this.scheduleNeighborChange();
    }

    @Override
    public boolean getTurtrleConnect() {
        return this.turtleConnect[((ForgeDirection)this.connections.get(this.lastPC)).ordinal()];
    }

    @Override
    public int getLastCCID() {
        if (this.lastPC == null) {
            return -1;
        }
        return this.lastPC.getID();
    }
}

