/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.main.LogisticsEventListener;
import logisticspipes.network.packets.PacketRenderFX;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.IProxy;
import logisticspipes.ticks.RoutingTableUpdateThread;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.ServerListenThread;
import net.minecraft.server.ThreadMinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MainProxy {
    @SidedProxy(clientSide="logisticspipes.proxy.side.ClientProxy", serverSide="logisticspipes.proxy.side.ServerProxy", bukkitSide="logisticspipes.proxy.side.BukkitProxy")
    public static IProxy proxy;
    private static WeakHashMap threadSideMap;

    private static Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (threadSideMap.containsKey(thr)) {
            return (Side)threadSideMap.get(thr);
        }
        Side side = MainProxy.getEffectiveSide(thr);
        if (threadSideMap.size() > 50) {
            threadSideMap.clear();
        }
        threadSideMap.put(thr, side);
        return side;
    }

    private static Side getEffectiveSide(Thread thr) {
        if (SimpleServiceLocator.ccProxy != null && SimpleServiceLocator.ccProxy.isLuaThread(thr)) {
            return Side.SERVER;
        }
        if (thr instanceof ThreadMinecraftServer || thr instanceof ServerListenThread || thr instanceof RoutingTableUpdateThread) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static boolean isClient(World world) {
        try {
            return world.field_72995_K;
        }
        catch (NullPointerException n) {
            LogisticsPipes.log.severe("isClient called with a null world - using slow thread based fallback");
            n.printStackTrace();
            return MainProxy.isClient();
        }
    }

    @Deprecated
    public static boolean isClient() {
        return MainProxy.getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServer(World world) {
        try {
            return !world.field_72995_K;
        }
        catch (NullPointerException n) {
            LogisticsPipes.log.severe("isServer called with a null world - using slow thread based fallback");
            n.printStackTrace();
            return MainProxy.isServer();
        }
    }

    @Deprecated
    public static boolean isServer() {
        return MainProxy.getEffectiveSide() == Side.SERVER;
    }

    public static World getClientMainWorld() {
        return proxy.getWorld();
    }

    public static int getDimensionForWorld(World world) {
        return proxy.getDimensionForWorld(world);
    }

    public static void sendPacketToServer(Packet packet) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size too big").printStackTrace();
        }
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public static void sendCompressedPacketToServer(Packet250CustomPayload packet) {
        SimpleServiceLocator.clientBufferHandler.addPacketToCompressor(packet);
    }

    public static void sendPacketToPlayer(Packet packet, Player player) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((Packet250CustomPayload)packet, player);
        } else {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)player);
        }
    }

    public static void sendCompressedPacketToPlayer(Packet packet, Player player) {
        if (packet instanceof Packet250CustomPayload) {
            SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((Packet250CustomPayload)packet, player);
        } else {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)player);
        }
    }

    public static void sendPacketToAllWatchingChunk(int X, int Z, int dimensionId, Packet packet) {
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(X >> 4, Z >> 4);
        List players = (List)LogisticsEventListener.watcherList.get(chunk);
        if (players != null) {
            for (EntityPlayer player : players) {
                if (MainProxy.getDimensionForWorld(player.field_70170_p) != dimensionId) continue;
                MainProxy.sendPacketToPlayer(packet, (Player)player);
            }
            return;
        }
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size too big").printStackTrace();
        }
        PacketDispatcher.sendPacketToAllAround((double)X, (double)64.0, (double)Z, (double)128.0, (int)dimensionId, (Packet)packet);
    }

    public static void sendToPlayerList(Packet packet, List players) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            for (EntityPlayer player : players) {
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((Packet250CustomPayload)packet, (Player)player);
            }
        } else {
            for (EntityPlayer player : players) {
                PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
            }
        }
    }

    public static void sendCompressedToPlayerList(Packet packet, List players) {
        if (packet instanceof Packet250CustomPayload) {
            for (EntityPlayer player : players) {
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor((Packet250CustomPayload)packet, (Player)player);
            }
        } else {
            for (EntityPlayer player : players) {
                PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
            }
        }
    }

    public static void sendToAllPlayers(Packet packet) {
        if (!MainProxy.isDirectSendPacket(packet)) {
            new Exception("Packet size to big").printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    public static void sendCompressedToAllPlayers(Packet250CustomPayload packet) {
        for (WorldServer world : DimensionManager.getWorlds()) {
            for (Object playerObject : world.field_73010_i) {
                Player player = (Player)playerObject;
                SimpleServiceLocator.serverBufferHandler.addPacketToCompressor(packet, player);
            }
        }
    }

    private static boolean isDirectSendPacket(Packet packet) {
        if (packet instanceof Packet250CustomPayload) {
            Packet250CustomPayload packet250 = (Packet250CustomPayload)packet;
            if (packet250.field_73629_c != null && packet250.field_73629_c.length > Short.MAX_VALUE && packet250.field_73630_a.equals("BCLP")) {
                return false;
            }
        }
        return true;
    }

    public static List getPlayerArround(World worldObj, int xCoord, int yCoord, int zCoord, int distance) {
        ArrayList<EntityPlayer> list = new ArrayList<EntityPlayer>();
        if (worldObj != null) {
            for (Object playerObject : worldObj.field_73010_i) {
                EntityPlayer player = (EntityPlayer)playerObject;
                if (!(Math.hypot(player.field_70165_t - (double)xCoord, Math.hypot(player.field_70163_u - (double)yCoord, player.field_70161_v - (double)zCoord)) < (double)distance)) continue;
                list.add(player);
            }
        }
        return list;
    }

    public static void sendSpawnParticlePacket(int particle, int xCoord, int yCoord, int zCoord, World dimension, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX) {
            return;
        }
        if (MainProxy.isServer(dimension)) {
            MainProxy.sendPacketToAllWatchingChunk(xCoord, zCoord, MainProxy.getDimensionForWorld(dimension), new PacketRenderFX(78, xCoord, yCoord, zCoord, particle, amount).getPacket());
        } else {
            LogisticsPipes.log.severe("Server only method on Client (Particle Spawning)");
        }
    }

    public static void spawnParticle(int particle, int xCoord, int yCoord, int zCoord, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX || !Minecraft.func_71375_t()) {
            return;
        }
        PipeFXRenderHandler.spawnGenericParticle(particle, xCoord, yCoord, zCoord, amount);
    }

    static {
        threadSideMap = new WeakHashMap();
    }
}

