/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.ISlotCheck;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.ConnectionUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.LiquidCraftingUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class UpgradeManager
implements ISimpleInventoryEventHandler {
    private SimpleInventory inv = new SimpleInventory(9, "UpgradeInventory", 16);
    private SimpleInventory sneakyInv = new SimpleInventory(9, "SneakyUpgradeInventory", 1);
    private IPipeUpgrade[] upgrades = new IPipeUpgrade[8];
    private IPipeUpgrade[] sneakyUpgrades = new IPipeUpgrade[9];
    private CoreRoutedPipe pipe;
    private int securityDelay = 0;
    private ForgeDirection sneakyOrientation = ForgeDirection.UNKNOWN;
    private ForgeDirection[] combinedSneakyOrientation = new ForgeDirection[9];
    private int speedUpgradeCount = 0;
    private final EnumSet disconnectedSides = EnumSet.noneOf(ForgeDirection.class);
    private boolean isAdvancedCrafter = false;
    private boolean isCombinedSneakyUpgrade = false;
    private int liquidCrafter = 0;
    private boolean hasByproductExtractor = false;
    private boolean needsContainerPositionUpdate = false;

    public UpgradeManager(CoreRoutedPipe pipe) {
        this.pipe = pipe;
        this.inv.addListener(this);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.inv.readFromNBT(nbttagcompound, "UpgradeInventory_");
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.inv.writeToNBT(nbttagcompound, "UpgradeInventory_");
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot, IPipeUpgrade[] upgrades, IInventory inv) {
        upgrades[slot] = LogisticsPipes.UpgradeItem.getUpgradeForItem(inv.func_70301_a(slot), upgrades[slot]);
        if (upgrades[slot] == null) {
            inv.func_70299_a(slot, null);
            return false;
        }
        return upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot, IPipeUpgrade[] upgrades) {
        boolean needUpdate = upgrades[slot].needsUpdate();
        upgrades[slot] = null;
        return needUpdate;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        IPipeUpgrade upgrade;
        int i;
        boolean needUpdate = false;
        for (int i2 = 0; i2 < this.inv.func_70302_i_() - 1; ++i2) {
            ItemStack item = this.inv.func_70301_a(i2);
            if (item != null) {
                needUpdate |= this.updateModule(i2, this.upgrades, this.inv);
                continue;
            }
            if (item != null || this.upgrades[i2] == null) continue;
            needUpdate |= this.removeUpgrade(i2, this.upgrades);
        }
        this.sneakyOrientation = ForgeDirection.UNKNOWN;
        this.speedUpgradeCount = 0;
        this.isAdvancedCrafter = false;
        boolean combinedBuffer = this.isCombinedSneakyUpgrade;
        this.isCombinedSneakyUpgrade = false;
        this.liquidCrafter = 0;
        this.disconnectedSides.clear();
        this.hasByproductExtractor = false;
        for (i = 0; i < this.upgrades.length; ++i) {
            upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN && !this.isCombinedSneakyUpgrade) {
                this.sneakyOrientation = ((SneakyUpgrade)upgrade).getSneakyOrientation();
                continue;
            }
            if (upgrade instanceof SpeedUpgrade) {
                this.speedUpgradeCount += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (upgrade instanceof ConnectionUpgrade) {
                this.disconnectedSides.add(((ConnectionUpgrade)upgrade).getSide());
                continue;
            }
            if (upgrade instanceof AdvancedSatelliteUpgrade) {
                this.isAdvancedCrafter = true;
                continue;
            }
            if (upgrade instanceof CombinedSneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN) {
                this.isCombinedSneakyUpgrade = true;
                continue;
            }
            if (upgrade instanceof LiquidCraftingUpgrade) {
                this.liquidCrafter += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (!(upgrade instanceof CraftingByproductUpgrade)) continue;
            this.hasByproductExtractor = true;
        }
        this.liquidCrafter = Math.min(this.liquidCrafter, 3);
        if (combinedBuffer != this.isCombinedSneakyUpgrade) {
            this.needsContainerPositionUpdate = true;
        }
        for (i = 0; i < this.sneakyInv.func_70302_i_() - 1; ++i) {
            ItemStack item = this.sneakyInv.func_70301_a(i);
            if (item != null) {
                needUpdate |= this.updateModule(i, this.sneakyUpgrades, this.sneakyInv);
                continue;
            }
            if (item != null || this.sneakyUpgrades[i] == null) continue;
            needUpdate |= this.removeUpgrade(i, this.sneakyUpgrades);
        }
        for (i = 0; i < this.sneakyUpgrades.length; ++i) {
            upgrade = this.sneakyUpgrades[i];
            if (!(upgrade instanceof SneakyUpgrade)) continue;
            this.combinedSneakyOrientation[i] = ((SneakyUpgrade)upgrade).getSneakyOrientation();
        }
        if (needUpdate) {
            this.pipe.connectionUpdate();
        }
    }

    public boolean hasSneakyUpgrade() {
        return this.sneakyOrientation != ForgeDirection.UNKNOWN;
    }

    public ForgeDirection getSneakyOrientation() {
        return this.sneakyOrientation;
    }

    public int getSpeedUpgradeCount() {
        return this.speedUpgradeCount;
    }

    public boolean hasCombinedSneakyUpgrade() {
        return this.isCombinedSneakyUpgrade;
    }

    public ForgeDirection[] getCombinedSneakyOrientation() {
        return this.combinedSneakyOrientation;
    }

    public void openGui(EntityPlayer entityplayer, CoreRoutedPipe pipe) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 60, pipe.worldObj, pipe.getX(), pipe.getY(), pipe.getZ());
    }

    public DummyContainer getDummyContainer(EntityPlayer player) {
        DummyContainer dummy = new DummyContainer(player, this.inv, new IGuiOpenControler(){
            List players = new ArrayList();

            @Override
            public void guiOpenedByPlayer(EntityPlayer player) {
                this.players.add(player);
            }

            @Override
            public void guiClosedByPlayer(EntityPlayer player) {
                this.players.remove(player);
                if (this.players.isEmpty() && !UpgradeManager.this.isCombinedSneakyUpgrade) {
                    UpgradeManager.this.sneakyInv.dropContents(((UpgradeManager)UpgradeManager.this).pipe.worldObj, ((UpgradeManager)UpgradeManager.this).pipe.xCoord, ((UpgradeManager)UpgradeManager.this).pipe.yCoord, ((UpgradeManager)UpgradeManager.this).pipe.zCoord);
                }
            }
        });
        dummy.addNormalSlotsForPlayerInventory(8, this.isCombinedSneakyUpgrade ? 90 : 60);
        for (int pipeSlot = 0; pipeSlot < 8; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)this.inv, 8 + pipeSlot * 18, 18, new ISlotCheck(){

                @Override
                public boolean isStackAllowed(ItemStack itemStack) {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.field_77993_c == LogisticsPipes.UpgradeItem.field_77779_bT) {
                        return LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null).isAllowed(UpgradeManager.this.pipe);
                    }
                    return false;
                }
            });
        }
        dummy.addStaticRestrictedSlot(8, (IInventory)this.inv, 152, 18, new ISlotCheck(){

            @Override
            public boolean isStackAllowed(ItemStack itemStack) {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.field_77993_c != LogisticsPipes.LogisticsItemCard.field_77779_bT) {
                    return false;
                }
                if (itemStack.func_77960_j() != 1) {
                    return false;
                }
                return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID")));
            }
        }, 1);
        int y = this.isCombinedSneakyUpgrade ? 58 : 100000;
        for (int pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)this.sneakyInv, 8 + pipeSlot * 18, y, new ISlotCheck(){

                @Override
                public boolean isStackAllowed(ItemStack itemStack) {
                    if (itemStack == null) {
                        return false;
                    }
                    if (itemStack.field_77993_c == LogisticsPipes.UpgradeItem.field_77779_bT) {
                        IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null);
                        if (!(upgrade instanceof SneakyUpgrade)) {
                            return false;
                        }
                        return upgrade.isAllowed(UpgradeManager.this.pipe);
                    }
                    return false;
                }
            });
        }
        return dummy;
    }

    public boolean isNeedingContainerUpdate() {
        boolean tmp = this.needsContainerPositionUpdate;
        this.needsContainerPositionUpdate = false;
        return tmp;
    }

    public void dropUpgrades(World worldObj, int xCoord, int yCoord, int zCoord) {
        this.inv.dropContents(worldObj, xCoord, yCoord, zCoord);
    }

    public boolean isSideDisconnected(ForgeDirection side) {
        return this.disconnectedSides.contains(side);
    }

    public boolean tryIserting(World world, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c == LogisticsPipes.UpgradeItem.field_77779_bT) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(entityplayer.func_71045_bC(), null);
            if (upgrade.isAllowed(this.pipe)) {
                if (this.isCombinedSneakyUpgrade && upgrade instanceof SneakyUpgrade && this.insertIntInv(entityplayer, this.sneakyInv, 0)) {
                    return true;
                }
                if (this.insertIntInv(entityplayer, this.inv, 1)) {
                    return true;
                }
            }
        }
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c == LogisticsPipes.LogisticsItemCard.field_77779_bT && entityplayer.func_71045_bC().func_77960_j() == 1) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            if (this.inv.func_70301_a(8) == null) {
                this.inv.func_70299_a(8, entityplayer.func_71045_bC().func_77946_l());
                this.inv.func_70301_a((int)8).field_77994_a = 1;
                entityplayer.func_71045_bC().func_77979_a(1);
                this.InventoryChanged(this.inv);
                return true;
            }
        }
        return false;
    }

    private boolean insertIntInv(EntityPlayer entityplayer, SimpleInventory inv, int sub) {
        for (int i = 0; i < inv.func_70302_i_() - sub; ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null) {
                inv.func_70299_a(i, entityplayer.func_71045_bC().func_77979_a(1));
                this.InventoryChanged(inv);
                return true;
            }
            if (item.func_77960_j() != entityplayer.func_71045_bC().func_77960_j() || item.field_77994_a >= inv.func_70297_j_()) continue;
            ++item.field_77994_a;
            entityplayer.func_71045_bC().func_77979_a(1);
            this.InventoryChanged(inv);
            return true;
        }
        return false;
    }

    public UUID getSecurityID() {
        ItemStack stack = this.inv.func_70301_a(8);
        if (stack == null) {
            return null;
        }
        if (stack.field_77993_c != LogisticsPipes.LogisticsItemCard.field_77779_bT || stack.func_77960_j() != 1) {
            return null;
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!stack.func_77978_p().func_74764_b("UUID")) {
            return null;
        }
        return UUID.fromString(stack.func_77978_p().func_74779_i("UUID"));
    }

    public void insetSecurityID(UUID id) {
        ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 1, 1);
        stack.func_77982_d(new NBTTagCompound("tag"));
        stack.func_77978_p().func_74778_a("UUID", id.toString());
        this.inv.func_70299_a(8, stack);
    }

    public void securityTick() {
        UUID id = this.getSecurityID();
        if (id != null) {
            this.securityDelay = !SimpleServiceLocator.securityStationManager.isAuthorized(id) ? ++this.securityDelay : 0;
            if (this.securityDelay > 20) {
                this.inv.func_70299_a(8, null);
            }
        }
    }

    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter;
    }

    public int getLiquidCrafter() {
        return this.liquidCrafter;
    }

    public boolean hasByproductExtractor() {
        return this.hasByproductExtractor;
    }
}

