/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.logic.BaseLogicLiquidSatellite;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidSatelliteLogistics
extends LiquidRoutedPipe
implements IRequestLiquid,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final List localModeWatchers = new ArrayList();
    public final LinkedList itemList = new LinkedList();
    public final LinkedList oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);

    public PipeLiquidSatelliteLogistics(int itemID) {
        super(new BaseLogicLiquidSatellite(), itemID);
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_SATELLITE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.worldObj.func_72820_D() % 20L == 0L && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public void sendFailed(LiquidIdentifier liquid, Integer amount) {
        if (this.logic instanceof IRequireReliableLiquidTransport) {
            ((IRequireReliableLiquidTransport)this.logic).itemLost(liquid, amount);
        }
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.stackSize += stack.stackSize;
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            if (!(pair.getValue1() instanceof ITankContainer)) continue;
            ITankContainer tankContainer = (ITankContainer)pair.getValue1();
            for (ILiquidTank tank : tanks = tankContainer.getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null) continue;
                this.addToList(LiquidIdentifier.get(liquid).getItemIdentifier().makeStack(liquid.amount));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), this.itemList).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(8, this.getX(), this.getY(), this.getZ(), ((BaseLogicLiquidSatellite)this.logic).satelliteId).getPacket(), (Player)player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }
}

