/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import logisticspipes.utils.Pair;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidInsertion
extends LiquidRoutedPipe {
    private List localJamList = new ArrayList();
    private int[] nextSendMax = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] nextSendMin = new int[ForgeDirection.VALID_DIRECTIONS.length];

    public PipeLiquidInsertion(int itemID) {
        super(itemID);
    }

    @Override
    public void enabledUpdateEntity() {
        ArrayList<Object> tempJamList = new ArrayList<Object>();
        if (!this.localJamList.isEmpty()) {
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            for (Pair part : this.localJamList) {
                part.setValue2((Integer)part.getValue2() - 1);
                if ((Integer)part.getValue2() <= 0) {
                    toRemove.add(part);
                    continue;
                }
                tempJamList.add(part.getValue1());
            }
            if (!toRemove.isEmpty()) {
                this.localJamList.removeAll(toRemove);
            }
        }
        PipeLiquidTransportLogistics transport = (PipeLiquidTransportLogistics)this.transport;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            LiquidStack stack = transport.sideTanks[dir.ordinal()].getLiquid();
            if (stack == null) continue;
            stack = stack.copy();
            if (this.nextSendMax[dir.ordinal()] > 0 && stack.amount < transport.sideTanks[dir.ordinal()].getCapacity()) {
                int n = dir.ordinal();
                this.nextSendMax[n] = this.nextSendMax[n] - 1;
                continue;
            }
            if (this.nextSendMin[dir.ordinal()] > 0) {
                int n = dir.ordinal();
                this.nextSendMin[n] = this.nextSendMin[n] - 1;
                continue;
            }
            Pair result = SimpleServiceLocator.logisticsLiquidManager.getBestReply(stack, this.getRouter(), tempJamList);
            if (result == null || result.getValue1() == null || (Integer)result.getValue2() == 0) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            if (!this.useEnergy((int)(0.01 * (double)((Integer)result.getValue2()).intValue()))) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            LiquidStack toSend = transport.sideTanks[dir.ordinal()].drain((Integer)result.getValue2(), true);
            ItemStack liquidContainer = SimpleServiceLocator.logisticsLiquidManager.getLiquidContainer(toSend);
            IRoutedItem routed = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(liquidContainer, this.worldObj);
            routed.setDestination((Integer)result.getValue1());
            routed.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routed, dir);
            this.nextSendMax[dir.ordinal()] = 100;
            this.nextSendMin[dir.ordinal()] = 10;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("nextSendMax", this.nextSendMax);
        nbttagcompound.func_74783_a("nextSendMin", this.nextSendMin);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.nextSendMax = nbttagcompound.func_74759_k("nextSendMax");
        if (this.nextSendMax.length < 6) {
            this.nextSendMax = new int[6];
        }
        this.nextSendMin = nbttagcompound.func_74759_k("nextSendMin");
        if (this.nextSendMin.length < 6) {
            this.nextSendMin = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_INSERTION;
    }

    @Override
    public boolean canInsertToTanks() {
        return false;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return false;
    }
}

