/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.core.utils.SimpleInventory;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ILiquidSink;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidSection;
import logisticspipes.proxy.MainProxy;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidBasic
extends LiquidRoutedPipe
implements ILiquidSink {
    public SimpleInventory filterInv = new SimpleInventory(1, "Dummy", 1);

    public PipeLiquidBasic(int itemID) {
        super(itemID);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_BASIC;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean wrenchClicked(World world, int i, int j, int k, EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openGui) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 37, world, this.getX(), this.getY(), this.getZ());
            } else {
                entityplayer.func_70006_a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public int sinkAmount(LiquidStack stack) {
        LiquidIdentifier ident = LiquidIdentifier.get(stack);
        if (this.filterInv.func_70301_a(0) == null) {
            return 0;
        }
        if (ident != ItemIdentifier.get(this.filterInv.func_70301_a(0)).getLiquidIdentifier()) {
            return 0;
        }
        int amount = 0;
        for (Pair pair : this.getAdjacentTanks(true)) {
            LogisticsLiquidSection tank = ((PipeLiquidTransportLogistics)this.transport).sideTanks[((ForgeDirection)pair.getValue2()).ordinal()];
            if ((amount += tank.fill(stack, false)) != stack.amount) continue;
            return amount;
        }
        return amount;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.filterInv.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.filterInv.readFromNBT(nbttagcompound);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }
}

