/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.textures.Textures;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsSatelliteLogistics
extends CoreRoutedPipe
implements IRequestItems,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final List localModeWatchers = new ArrayList();
    public final LinkedList itemList = new LinkedList();
    public final LinkedList oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);

    public PipeItemsSatelliteLogistics(int itemID) {
        super(new BaseLogicSatellite(), itemID);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_SATELLITE_TEXTURE;
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.worldObj.func_72820_D() % 20L == 0L && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    private IInventory getRawInventory(ForgeDirection ori) {
        Position pos = new Position((double)this.getX(), (double)this.getY(), (double)this.getZ(), ori);
        pos.moveForwards(1.0);
        TileEntity tile = this.worldObj.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof IInventory)) {
            return null;
        }
        return InventoryHelper.getInventory((IInventory)tile);
    }

    private IInventory getInventory(ForgeDirection ori) {
        IInventory rawInventory = this.getRawInventory(ori);
        if (rawInventory instanceof net.minecraft.inventory.ISidedInventory) {
            return new SidedInventoryMinecraftAdapter((net.minecraft.inventory.ISidedInventory)rawInventory, ori.getOpposite());
        }
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryForgeAdapter((ISidedInventory)rawInventory, ori.getOpposite());
        }
        return rawInventory;
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.stackSize += stack.stackSize;
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (ForgeDirection ori : ForgeDirection.values()) {
            IInventory inv = this.getInventory(ori);
            if (inv == null) continue;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                this.addToList(ItemIdentifierStack.GetFromStack(inv.func_70301_a(i)));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), this.itemList).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(8, this.getX(), this.getY(), this.getZ(), ((BaseLogicSatellite)this.logic).satelliteId).getPacket(), (Player)player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }
}

