/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import logisticspipes.gui.hud.HUDProvider;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.LogicProvider;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsOrderManager;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.textures.Textures;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsProviderLogistics
extends CoreRoutedPipe
implements IProvideItems,
IHeadUpDisplayRendererProvider,
IChestContentReceiver,
IChangeListener,
IOrderManagerContentReceiver {
    public final List localModeWatchers = new ArrayList();
    private final Map displayMap = new HashMap();
    public final ArrayList displayList = new ArrayList();
    private final ArrayList oldList = new ArrayList();
    public final LinkedList oldManagerList = new LinkedList();
    public final LinkedList itemListOrderer = new LinkedList();
    private final HUDProvider HUD = new HUDProvider(this);
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager(this);
    private boolean doContentUpdate = true;

    public PipeItemsProviderLogistics(int itemID) {
        super(new LogicProvider(), itemID);
    }

    public PipeItemsProviderLogistics(int itemID, LogisticsOrderManager logisticsOrderManager) {
        this(itemID);
        this._orderManager = logisticsOrderManager;
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        while (this._orderManager.hasOrders()) {
            this._orderManager.sendFailed();
        }
    }

    public int getTotalItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        LogicProvider logicProvider = (LogicProvider)this.logic;
        if (logicProvider.hasFilter() && (logicProvider.isExcludeFilter() && logicProvider.itemIsFiltered(item) || !logicProvider.isExcludeFilter() && !logicProvider.itemIsFiltered(item))) {
            return 0;
        }
        int count = 0;
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory) || tile.tile instanceof TileGenericPipe) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(tile);
            count += inv.itemCount(item);
        }
        return count;
    }

    protected int neededEnergy() {
        return 1;
    }

    protected int itemsToExtract() {
        return 8;
    }

    protected int stacksToExtract() {
        return 1;
    }

    private int sendStack(ItemIdentifierStack stack, int maxCount, int destination, List relays) {
        ItemIdentifier item = stack.getItem();
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            IInventoryUtil inv;
            int available;
            if (!(tile.tile instanceof IInventory) || tile.tile instanceof TileGenericPipe || (available = (inv = this.getAdaptedInventoryUtil(tile)).itemCount(item)) == 0) continue;
            int wanted = Math.min(available, stack.stackSize);
            wanted = Math.min(wanted, maxCount);
            wanted = Math.min(wanted, item.getMaxStackSize());
            IRouter dRtr = SimpleServiceLocator.routerManager.getRouterUnsafe(destination, false);
            if (dRtr == null) {
                this._orderManager.sendFailed();
                return 0;
            }
            SinkReply reply = LogisticsManagerV2.canSink(dRtr, null, true, stack.getItem(), null, true, false);
            boolean defersend = false;
            if (reply != null && reply.maxNumberOfItems < wanted) {
                wanted = reply.maxNumberOfItems;
                if (wanted <= 0) {
                    this._orderManager.deferSend();
                    return 0;
                }
                defersend = true;
            }
            if (!this.canUseEnergy(wanted * this.neededEnergy())) {
                return -1;
            }
            ItemStack removed = inv.getMultipleItems(item, wanted);
            if (removed == null) continue;
            int sent = removed.field_77994_a;
            this.useEnergy(sent * this.neededEnergy());
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(removed, this.worldObj);
            routedItem.setDestination(destination);
            routedItem.setTransportMode(IRoutedItem.TransportMode.Active);
            routedItem.addRelayPoints(relays);
            super.queueRoutedItem(routedItem, tile.orientation);
            this._orderManager.sendSuccessfull(sent, defersend);
            return sent;
        }
        this._orderManager.sendFailed();
        return 0;
    }

    private IInventoryUtil getAdaptedInventoryUtil(AdjacentTile tile) {
        IInventory base = (IInventory)tile.tile;
        if (base instanceof net.minecraft.inventory.ISidedInventory) {
            base = new SidedInventoryMinecraftAdapter((net.minecraft.inventory.ISidedInventory)base, tile.orientation.getOpposite());
        }
        if (base instanceof ISidedInventory) {
            base = new SidedInventoryForgeAdapter((ISidedInventory)base, tile.orientation.getOpposite());
        }
        ExtractionMode mode = ((LogicProvider)this.logic).getExtractionMode();
        switch (mode) {
            case LeaveFirst: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, false, false, 1, 0);
            }
            case LeaveLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, false, false, 0, 1);
            }
            case LeaveFirstAndLast: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, false, false, 1, 1);
            }
            case Leave1PerStack: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, true, false, 0, 0);
            }
            case Leave1PerType: {
                return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, false, true, 0, 0);
            }
        }
        return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(base, false, false, 0, 0);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_PROVIDER_TEXTURE;
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.getTotalItemCount(item) - this._orderManager.totalItemsCountInOrders(item);
    }

    @Override
    public void enabledUpdateEntity() {
        int sent;
        if (this.worldObj.func_72820_D() % 6L == 0L) {
            this.updateInv(null);
        }
        if (this.doContentUpdate) {
            this.checkContentUpdate(null);
        }
        if (!this._orderManager.hasOrders() || this.worldObj.func_72820_D() % 6L != 0L) {
            return;
        }
        int itemsleft = this.itemsToExtract();
        Pair3 firstOrder = null;
        Pair3 order = null;
        for (int stacksleft = this.stacksToExtract(); itemsleft > 0 && stacksleft > 0 && this._orderManager.hasOrders() && (firstOrder == null || firstOrder != order); --stacksleft, itemsleft -= sent) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((sent = this.sendStack((ItemIdentifierStack)(order = this._orderManager.peekAtTopRequest()).getValue1(), itemsleft, ((IRequestItems)order.getValue2()).getRouter().getSimpleID(), (List)order.getValue3())) < 0) break;
            MainProxy.sendSpawnParticlePacket(6, this.getX(), this.getY(), this.getZ(), this.worldObj, 3);
        }
    }

    @Override
    public void canProvide(RequestTreeNode tree, int donePromisses, List filters) {
        if (!this.isEnabled()) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(tree.getStackItem().getUndamaged()) && !filter.blockProvider()) continue;
            return;
        }
        int canProvide = this.getAvailableItemCount(tree.getStackItem());
        if ((canProvide -= donePromisses) < 1) {
            return;
        }
        LogisticsPromise promise = new LogisticsPromise();
        promise.item = tree.getStackItem();
        promise.numberOfItems = Math.min(canProvide, tree.getMissingItemCount());
        promise.sender = this;
        LinkedList<IFilter> relays = new LinkedList<IFilter>();
        for (IFilter filter : filters) {
            relays.add(filter);
        }
        promise.relayPoints = relays;
        tree.addPromise(promise);
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        this._orderManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, promise.relayPoints);
        MainProxy.sendSpawnParticlePacket(1, this.getX(), this.getY(), this.getZ(), this.worldObj, 2);
    }

    @Override
    public void getAllItems(Map items, List filters) {
        if (!this.isEnabled()) {
            return;
        }
        LogicProvider providerLogic = (LogicProvider)this.logic;
        HashMap addedItems = new HashMap();
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        for (AdjacentTile adjacentTile : wUtil.getAdjacentTileEntities(true)) {
            if (!(adjacentTile.tile instanceof IInventory) || adjacentTile.tile instanceof TileGenericPipe) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(adjacentTile);
            Map currentInv = inv.getItemsAndCount();
            block1: for (Map.Entry currItem : currentInv.entrySet()) {
                if (items.containsKey(currItem.getKey()) || providerLogic.hasFilter() && (providerLogic.isExcludeFilter() && providerLogic.itemIsFiltered((ItemIdentifier)currItem.getKey()) || !providerLogic.isExcludeFilter() && !providerLogic.itemIsFiltered((ItemIdentifier)currItem.getKey()))) continue;
                for (IFilter filter : filters) {
                    if (filter.isBlocked() != filter.isFilteredItem(((ItemIdentifier)currItem.getKey()).getUndamaged()) && !filter.blockProvider()) continue;
                    continue block1;
                }
                Integer addedAmount = (Integer)addedItems.get(currItem.getKey());
                if (addedAmount == null) {
                    addedItems.put(currItem.getKey(), currItem.getValue());
                    continue;
                }
                addedItems.put(currItem.getKey(), addedAmount + (Integer)currItem.getValue());
            }
        }
        for (Map.Entry entry : addedItems.entrySet()) {
            int remaining = (Integer)entry.getValue() - this._orderManager.totalItemsCountInOrders((ItemIdentifier)entry.getKey());
            if (remaining < 1) continue;
            items.put(entry.getKey(), remaining);
        }
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    private void updateInv(EntityPlayer player) {
        if (this.localModeWatchers.size() == 0 && player == null) {
            return;
        }
        this.displayList.clear();
        this.displayMap.clear();
        this.getAllItems(this.displayMap, new ArrayList(0));
        this.displayList.ensureCapacity(this.displayMap.size());
        for (Map.Entry item : this.displayMap.entrySet()) {
            this.displayList.add(new ItemIdentifierStack((ItemIdentifier)item.getKey(), (Integer)item.getValue()));
        }
        if (!this.oldList.equals(this.displayList)) {
            this.oldList.clear();
            this.oldList.ensureCapacity(this.displayList.size());
            this.oldList.addAll(this.displayList);
            MainProxy.sendCompressedToPlayerList(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), this.displayList).getPacket(), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendCompressedPacketToPlayer(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), this.displayList).getPacket(), (Player)player);
        }
    }

    @Override
    public void listenedChanged() {
        this.doContentUpdate = true;
    }

    private void checkContentUpdate(EntityPlayer player) {
        this.doContentUpdate = false;
        LinkedList all = this._orderManager.getContentList(this.worldObj);
        if (!this.oldManagerList.equals(all)) {
            this.oldManagerList.clear();
            this.oldManagerList.addAll(all);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), all).getPacket(), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), all).getPacket(), (Player)player);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            this.updateInv(player);
            this.checkContentUpdate(player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.displayList.clear();
        this.displayList.ensureCapacity(list.size());
        this.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void setOrderManagerContent(Collection list) {
        this.itemListOrderer.clear();
        this.itemListOrderer.addAll(list);
    }

    @Override
    public Set getSpecificInterests() {
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        Set l1 = null;
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory) || tile.tile instanceof TileGenericPipe) continue;
            IInventoryUtil inv = this.getAdaptedInventoryUtil(tile);
            Set items = inv.getItems();
            if (l1 == null) {
                l1 = items;
                continue;
            }
            l1.addAll(items);
        }
        return l1;
    }

    @Override
    public double getLoadFactor() {
        return (double)(this._orderManager.totalItemsCountInAllOrders() + 63) / 64.0;
    }
}

