/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.transport.EntityData;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDInvSysConnector;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IDirectRoutingConnection;
import logisticspipes.logic.LogicInvSysConnection;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.TransportInvConnection;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair4;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsInvSysConnector
extends CoreRoutedPipe
implements IDirectRoutingConnection,
IHeadUpDisplayRendererProvider,
IOrderManagerContentReceiver {
    private boolean init = false;
    private LinkedList destination = new LinkedList();
    public SimpleInventory inv = new SimpleInventory(1, "Freq. card", 1);
    public int resistance;
    public Set oldList = new TreeSet();
    public final LinkedList displayList = new LinkedList();
    public final List localModeWatchers = new ArrayList();
    private HUDInvSysConnector HUD = new HUDInvSysConnector(this);
    private UUID idbuffer = UUID.randomUUID();

    public PipeItemsInvSysConnector(int itemID) {
        super(new TransportInvConnection(), new LogicInvSysConnection(), itemID);
    }

    @Override
    public void enabledUpdateEntity() {
        CoreRoutedPipe CRP;
        if (!this.init && this.hasConnectionUUID()) {
            if (!SimpleServiceLocator.connectionManager.addDirectConnection(this.getConnectionUUID(), this.getRouter())) {
                this.dropFreqCard();
            }
            if ((CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) != null) {
                CRP.refreshRender(true);
            }
            this.getRouter().update(true);
            this.refreshRender(true);
            this.init = true;
            this.idbuffer = this.getConnectionUUID();
        }
        if (this.init && !this.hasConnectionUUID()) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.init && this.idbuffer != null && !this.idbuffer.equals(this.getConnectionUUID())) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.destination.size() > 0) {
            this.checkConnectedInvs();
        }
    }

    private void checkConnectedInvs() {
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory)) continue;
            IInventory inv = InventoryHelper.getInventory((IInventory)tile.tile);
            if (inv instanceof net.minecraft.inventory.ISidedInventory) {
                inv = new SidedInventoryMinecraftAdapter((net.minecraft.inventory.ISidedInventory)inv, tile.orientation.getOpposite());
            }
            if (inv instanceof ISidedInventory) {
                inv = new SidedInventoryForgeAdapter((ISidedInventory)inv, tile.orientation.getOpposite());
            }
            if (!this.checkOneConnectedInv(inv, tile.orientation)) continue;
            this.updateContentListener();
            break;
        }
    }

    private boolean checkOneConnectedInv(IInventory inv, ForgeDirection dir) {
        boolean contentchanged = false;
        block0: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            ItemIdentifier ident = ItemIdentifier.get(stack);
            for (Pair4 pair : this.destination) {
                if (pair.getValue1() != ident) continue;
                int tosend = Math.min((Integer)pair.getValue2(), stack.field_77994_a);
                if (!this.useEnergy(6)) continue block0;
                this.sendStack(inv.func_70298_a(i, tosend), (Integer)pair.getValue3(), dir, (IRoutedItem.TransportMode)((Object)pair.getValue4()));
                if (tosend < (Integer)pair.getValue2()) {
                    pair.setValue2((Integer)pair.getValue2() - tosend);
                } else {
                    this.destination.remove(pair);
                }
                contentchanged = true;
                continue block0;
            }
        }
        return contentchanged;
    }

    public void sendStack(ItemStack stack, int destination, ForgeDirection dir, IRoutedItem.TransportMode mode) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(mode);
        super.queueRoutedItem(itemToSend, dir);
        MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this.worldObj, 4);
    }

    private UUID getConnectionUUID() {
        if (this.inv != null && this.inv.func_70301_a(0) != null && this.inv.func_70301_a(0).func_77942_o() && this.inv.func_70301_a(0).func_77978_p().func_74764_b("UUID")) {
            return UUID.fromString(this.inv.func_70301_a(0).func_77978_p().func_74779_i("UUID"));
        }
        return null;
    }

    private boolean hasConnectionUUID() {
        return this.inv != null && this.inv.func_70301_a(0) != null && this.inv.func_70301_a(0).func_77942_o() && this.inv.func_70301_a(0).func_77978_p().func_74764_b("UUID");
    }

    private void dropFreqCard() {
        if (this.inv.func_70301_a(0) == null) {
            return;
        }
        EntityItem item = new EntityItem(this.worldObj, (double)this.getX(), (double)this.getY(), (double)this.getZ(), this.inv.func_70301_a(0));
        this.worldObj.func_72838_d((Entity)item);
        this.inv.func_70299_a(0, null);
    }

    public Set getExpectedItems() {
        TreeMap list = new TreeMap();
        for (Pair4 pair : this.destination) {
            ItemIdentifierStack currentStack = new ItemIdentifierStack((ItemIdentifier)pair.getValue1(), (Integer)pair.getValue2());
            Map.Entry entry = list.ceilingEntry(currentStack);
            if (entry != null && entry.getKey().getItem().uniqueID == currentStack.getItem().uniqueID) {
                entry.getKey().stackSize += currentStack.stackSize;
                continue;
            }
            list.put(currentStack, null);
        }
        return list.keySet();
    }

    @Override
    public boolean wrenchClicked(World world, int i, int j, int k, EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openGui) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 16, world, i, j, k);
            } else {
                entityplayer.func_70006_a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.dropFreqCard();
        super.onBlockRemoval();
    }

    @Override
    public void invalidate() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.onChunkUnload();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74768_a("resistance", this.resistance);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "");
        this.resistance = nbttagcompound.func_74762_e("resistance");
    }

    private boolean hasRemoteConnection() {
        return this.hasConnectionUUID() && this.worldObj != null && SimpleServiceLocator.connectionManager.hasDirectConnection(this.getRouter());
    }

    private boolean inventoryConnected() {
        for (int i = 0; i < 6; ++i) {
            Position p = new Position((double)this.getX(), (double)this.getY(), (double)this.getZ(), ForgeDirection.values()[i]);
            p.moveForwards(1.0);
            TileEntity tile = this.worldObj.func_72796_p((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof IInventory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        if (!this.stillNeedReplace && this.hasRemoteConnection()) {
            if (this.inventoryConnected()) {
                return Textures.LOGISTICSPIPE_INVSYSCON_CON_TEXTURE;
            }
            return Textures.LOGISTICSPIPE_INVSYSCON_MIS_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_INVSYSCON_DIS_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public int getConnectionResistance() {
        return this.resistance;
    }

    @Override
    public void addItem(ItemIdentifier item, int amount, int destinationId, IRoutedItem.TransportMode mode) {
        if (item != null && destinationId >= 0) {
            this.destination.addLast(new Pair4(item, amount, destinationId, (Object)mode));
            this.updateContentListener();
        }
    }

    public boolean isConnectedInv(TileEntity tile) {
        for (int i = 0; i < 6; ++i) {
            Position p = new Position((double)this.getX(), (double)this.getY(), (double)this.getZ(), ForgeDirection.values()[i]);
            p.moveForwards(1.0);
            TileEntity lTile = this.worldObj.func_72796_p((int)p.x, (int)p.y, (int)p.z);
            if (!(lTile instanceof IInventory)) continue;
            return lTile == tile;
        }
        return false;
    }

    public void handleItemEnterInv(EntityData data, TileEntity tile) {
        if (this.isConnectedInv(tile) && data.item instanceof IRoutedItem) {
            CoreRoutedPipe CRP;
            IRoutedItem routed = (IRoutedItem)data.item;
            if (this.hasRemoteConnection() && (CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) instanceof IDirectRoutingConnection) {
                IDirectRoutingConnection pipe = (IDirectRoutingConnection)((Object)CRP);
                pipe.addItem(ItemIdentifier.get(routed.getItemStack()), routed.getItemStack().field_77994_a, routed.getDestination(), routed.getTransportMode());
                MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this.worldObj, 4);
            }
        }
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    private void updateContentListener() {
        Set newList = this.getExpectedItems();
        if (!newList.equals(this.oldList)) {
            this.oldList = newList;
            MainProxy.sendToPlayerList(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), newList).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), this.getExpectedItems()).getPacket(), (Player)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setOrderManagerContent(Collection list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }
}

