/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import cpw.mods.fml.common.network.Player;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.HUDCraftingMK3;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.PipeItemsCraftingLogisticsMk2;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.CraftingPipeMk3Transport;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsCraftingLogisticsMk3
extends PipeItemsCraftingLogisticsMk2
implements ISimpleInventoryEventHandler,
IChestContentReceiver {
    public SimpleInventory inv = new SimpleInventory(16, "Buffer", 127);
    public List bufferList = new LinkedList();
    private HUDCraftingMK3 HUD = new HUDCraftingMK3(this);

    public PipeItemsCraftingLogisticsMk3(int itemID) {
        super(new CraftingPipeMk3Transport(), itemID);
        ((CraftingPipeMk3Transport)this.transport).pipe = this;
        this.inv.addListener(this);
    }

    @Override
    protected int neededEnergy() {
        return 20;
    }

    @Override
    protected int itemsToExtract() {
        return 128;
    }

    @Override
    protected int stacksToExtract() {
        if (SimpleServiceLocator.buildCraftProxy.checkMaxItems()) {
            return 8;
        }
        return 2;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.inv.isEmpty()) {
            return;
        }
        if (this.worldObj.func_72820_D() % 6L != 0L) {
            return;
        }
        List crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            this.sendBuffer();
            return;
        }
        boolean change = false;
        for (AdjacentTile tile : crafters) {
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                ItemStack slot = this.inv.func_70301_a(i);
                if (slot == null) continue;
                ForgeDirection insertion = tile.orientation.getOpposite();
                if (this.getUpgradeManager().hasSneakyUpgrade()) {
                    insertion = this.getUpgradeManager().getSneakyOrientation();
                }
                ItemStack toadd = slot.func_77946_l();
                toadd.field_77994_a = Math.min(toadd.field_77994_a, toadd.func_77976_d());
                toadd.field_77994_a = Math.min(toadd.field_77994_a, ((IInventory)tile.tile).func_70297_j_());
                ItemStack added = InventoryHelper.getTransactorFor(tile.tile).add(toadd, insertion, true);
                slot.field_77994_a -= added.field_77994_a;
                if (added.field_77994_a != 0) {
                    change = true;
                }
                if (slot.field_77994_a <= 0) {
                    this.inv.func_70299_a(i, null);
                    continue;
                }
                this.inv.func_70299_a(i, slot);
            }
        }
        if (!this._orderManager.hasOrders()) {
            this.sendBuffer();
        }
        if (change) {
            this.inv.func_70296_d();
        }
    }

    private void sendBuffer() {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stackToSend = this.inv.func_70301_a(i);
            if (stackToSend == null) continue;
            Position p = new Position((double)this.container.field_70329_l, (double)this.container.field_70330_m, (double)this.container.field_70327_n, null);
            Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((ItemStack)stackToSend), p.z + 0.5, ForgeDirection.UNKNOWN);
            EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
            entityItem.setSpeed(Utils.pipeNormalSpeed * 10.0f);
            ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entityItem, entityPos.orientation);
            this.inv.func_70299_a(i, null);
            break;
        }
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.inv.dropContents(this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_CRAFTERMK3_TEXTURE;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "buffer");
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), ItemIdentifierStack.getListFromInventory(this.inv, true)).getPacket(), this.localModeWatchers);
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        super.playerStartWatching(player, mode);
        if (mode == 1) {
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(52, this.getX(), this.getY(), this.getZ(), ItemIdentifierStack.getListFromInventory(this.inv, true)).getPacket(), (Player)player);
        }
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.bufferList.clear();
        this.bufferList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }
}

