/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDCrafting;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.logic.BaseLogicCrafting;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.network.packets.PacketPipeUpdate;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCQueued;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsOrderManager;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

@CCType(name="LogisticsPipes:Crafting")
public class PipeItemsCraftingLogistics
extends CoreRoutedPipe
implements ICraftItems,
IHeadUpDisplayRendererProvider,
IChangeListener,
IOrderManagerContentReceiver,
IHavePriority {
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager(this);
    public final LinkedList oldList = new LinkedList();
    public final LinkedList displayList = new LinkedList();
    public final List localModeWatchers = new ArrayList();
    private final HUDCrafting HUD = new HUDCrafting(this);
    public final LinkedList _extras = new LinkedList();
    private boolean init = false;
    private boolean doContentUpdate = true;
    public boolean waitingForCraft = false;
    private List _cachedCrafters = null;

    public PipeItemsCraftingLogistics(int itemID) {
        super(new BaseLogicCrafting(), itemID);
        ((BaseLogicCrafting)this.logic).setParentPipe(this);
    }

    public PipeItemsCraftingLogistics(PipeTransportLogistics transport, int itemID) {
        super(transport, new BaseLogicCrafting(), itemID);
        ((BaseLogicCrafting)this.logic).setParentPipe(this);
    }

    protected int neededEnergy() {
        return 10;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int stacksToExtract() {
        return 1;
    }

    protected List locateCrafters() {
        if (this._cachedCrafters != null) {
            return this._cachedCrafters;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        LinkedList<AdjacentTile> crafters = new LinkedList<AdjacentTile>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof IInventory)) continue;
            crafters.add(tile);
        }
        this._cachedCrafters = crafters;
        return this._cachedCrafters;
    }

    public void clearCraftersCache() {
        this._cachedCrafters = null;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.clearCraftersCache();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        while (this._orderManager.hasOrders()) {
            this._orderManager.sendFailed();
        }
    }

    private ItemStack extractFromISpecialInventory(ISpecialInventory inv, ItemIdentifier wanteditem, int count) {
        ItemStack[] stacks;
        ItemStack retstack = null;
        while (count > 0 && (stacks = inv.extractItem(false, ForgeDirection.UNKNOWN, 1)) != null && stacks.length >= 1 && stacks[0] != null) {
            ItemStack stack = stacks[0];
            if (stack.field_77994_a == 0 || (retstack != null ? !retstack.func_77969_a(stack) || !ItemStack.func_77970_a(retstack, (ItemStack)stack) : !wanteditem.fuzzyMatch(stack))) break;
            if (!this.useEnergy(this.neededEnergy() * stack.field_77994_a)) break;
            stacks = inv.extractItem(true, ForgeDirection.UNKNOWN, 1);
            if (stacks == null || stacks.length < 1 || stacks[0] == null) {
                LogisticsPipes.requestLog.info("crafting extractItem(true) got nothing from " + inv.toString());
                break;
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stacks[0])) {
                LogisticsPipes.requestLog.info("crafting extract got a unexpected item from " + inv.toString());
            }
            if (retstack == null) {
                retstack = stack;
            } else {
                retstack.field_77994_a += stack.field_77994_a;
            }
            count -= stack.field_77994_a;
        }
        return retstack;
    }

    private ItemStack extractFromIInventory(IInventory inv, ItemIdentifier wanteditem, int count) {
        IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
        int available = invUtil.itemCount(wanteditem);
        if (available == 0) {
            return null;
        }
        if (!this.useEnergy(this.neededEnergy() * Math.min(count, available))) {
            return null;
        }
        return invUtil.getMultipleItems(wanteditem, Math.min(count, available));
    }

    public void enableUpdateRequest() {
        this.init = false;
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        if (!this.init) {
            if (MainProxy.isClient(this.worldObj) && FMLClientHandler.instance().getClient() != null && FMLClientHandler.instance().getClient().field_71439_g != null && FMLClientHandler.instance().getClient().field_71439_g.field_71174_a != null) {
                MainProxy.sendPacketToServer(new PacketCoordinates(34, this.getX(), this.getY(), this.getZ()).getPacket());
            }
            this.init = true;
        }
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.doContentUpdate) {
            this.checkContentUpdate();
        }
        if (this.worldObj.func_72820_D() % 6L != 0L) {
            return;
        }
        this.waitingForCraft = false;
        if (!this._orderManager.hasOrders() && this._extras.isEmpty()) {
            return;
        }
        this.waitingForCraft = true;
        List crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            if (this._orderManager.hasOrders()) {
                this._orderManager.sendFailed();
            } else {
                this._extras.clear();
            }
            return;
        }
        List wanteditem = this.providedItem();
        if (wanteditem == null) {
            return;
        }
        MainProxy.sendSpawnParticlePacket(6, this.getX(), this.getY(), this.getZ(), this.worldObj, 2);
        int itemsleft = this.itemsToExtract();
        int stacksleft = this.stacksToExtract();
        block0: while (itemsleft > 0 && stacksleft > 0 && (this._orderManager.hasOrders() || !this._extras.isEmpty())) {
            Pair3 nextOrder;
            boolean processingOrder = false;
            if (this._orderManager.hasOrders()) {
                nextOrder = this._orderManager.peekAtTopRequest();
                processingOrder = true;
            } else {
                nextOrder = (Pair3)this._extras.getFirst();
            }
            int maxtosend = Math.min(itemsleft, ((ItemIdentifierStack)nextOrder.getValue1()).stackSize);
            maxtosend = Math.min(((ItemIdentifierStack)nextOrder.getValue1()).getItem().getMaxStackSize(), maxtosend);
            ItemStack extracted = null;
            AdjacentTile tile2 = null;
            for (AdjacentTile tile2 : crafters) {
                Object sidedadapter;
                if (tile2.tile instanceof ISpecialInventory) {
                    extracted = this.extractFromISpecialInventory((ISpecialInventory)tile2.tile, ((ItemIdentifierStack)nextOrder.getValue1()).getItem(), maxtosend);
                } else if (tile2.tile instanceof net.minecraft.inventory.ISidedInventory) {
                    sidedadapter = new SidedInventoryMinecraftAdapter((net.minecraft.inventory.ISidedInventory)tile2.tile, ForgeDirection.UNKNOWN);
                    extracted = this.extractFromIInventory((IInventory)sidedadapter, ((ItemIdentifierStack)nextOrder.getValue1()).getItem(), maxtosend);
                } else if (tile2.tile instanceof ISidedInventory) {
                    sidedadapter = new SidedInventoryForgeAdapter((ISidedInventory)tile2.tile, ForgeDirection.UNKNOWN);
                    extracted = this.extractFromIInventory((IInventory)sidedadapter, ((ItemIdentifierStack)nextOrder.getValue1()).getItem(), maxtosend);
                } else if (tile2.tile instanceof IInventory) {
                    extracted = this.extractFromIInventory((IInventory)tile2.tile, ((ItemIdentifierStack)nextOrder.getValue1()).getItem(), maxtosend);
                }
                if (extracted == null || extracted.field_77994_a <= 0) continue;
            }
            if (extracted == null || extracted.field_77994_a == 0) break;
            ItemIdentifier extractedID = ItemIdentifier.get(extracted);
            while (extracted.field_77994_a > 0) {
                int numtosend = Math.min(extracted.field_77994_a, extractedID.getMaxStackSize());
                if ((numtosend = Math.min(numtosend, ((ItemIdentifierStack)nextOrder.getValue1()).stackSize)) == 0) continue block0;
                --stacksleft;
                itemsleft -= numtosend;
                ItemStack stackToSend = extracted.func_77979_a(numtosend);
                if (processingOrder) {
                    IRoutedItem item = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stackToSend, this.worldObj);
                    item.setDestination(((IRequestItems)nextOrder.getValue2()).getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.addRelayPoints((List)nextOrder.getValue3());
                    super.queueRoutedItem(item, tile2.orientation);
                    this._orderManager.sendSuccessfull(stackToSend.field_77994_a, false);
                    if (this._orderManager.hasOrders()) {
                        nextOrder = this._orderManager.peekAtTopRequest();
                        continue;
                    }
                    processingOrder = false;
                    if (this._extras.isEmpty()) continue;
                    nextOrder = (Pair3)this._extras.getFirst();
                    continue;
                }
                this.removeExtras(numtosend, ((ItemIdentifierStack)nextOrder.getValue1()).getItem());
                Position p = new Position((double)tile2.tile.field_70329_l, (double)tile2.tile.field_70330_m, (double)tile2.tile.field_70327_n, tile2.orientation);
                LogisticsPipes.requestLog.info(stackToSend.field_77994_a + " extras dropped, " + this.countExtras() + " remaining");
                Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((ItemStack)stackToSend), p.z + 0.5, p.orientation.getOpposite());
                entityPos.moveForwards(0.5);
                EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
                entityItem.setSpeed(Utils.pipeNormalSpeed * 10.0f);
                ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entityItem, entityPos.orientation);
            }
        }
    }

    private void removeExtras(int numToSend, ItemIdentifier item) {
        Iterator i = this._extras.iterator();
        while (i.hasNext()) {
            ItemIdentifierStack e = (ItemIdentifierStack)((Pair3)i.next()).getValue1();
            if (e.getItem() != item) continue;
            if (numToSend >= e.stackSize) {
                i.remove();
                if ((numToSend -= e.stackSize) != 0) continue;
                return;
            }
            e.stackSize -= numToSend;
            break;
        }
    }

    private int countExtras() {
        if (this._extras == null) {
            return 0;
        }
        int count = 0;
        for (Pair3 e : this._extras) {
            count += ((ItemIdentifierStack)e.getValue1()).stackSize;
        }
        return count;
    }

    private List providedItem() {
        BaseLogicCrafting craftingLogic = (BaseLogicCrafting)this.logic;
        List stacks = craftingLogic.getCraftedItems();
        if (stacks == null) {
            return null;
        }
        ArrayList<ItemIdentifier> l = new ArrayList<ItemIdentifier>(stacks.size());
        for (ItemStack stack : stacks) {
            if (stacks == null) continue;
            l.add(ItemIdentifier.get(stack));
        }
        return l;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_CRAFTER_TEXTURE;
    }

    @Override
    public void canProvide(RequestTreeNode tree, int donePromisses, List filters) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._extras.isEmpty()) {
            return;
        }
        ItemIdentifier requestedItem = tree.getStackItem();
        List providedItem = this.providedItem();
        if (!providedItem.contains(requestedItem)) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(requestedItem.getUndamaged()) && !filter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (Pair3 extra : this._extras) {
            if (((ItemIdentifierStack)extra.getValue1()).getItem() != requestedItem) continue;
            remaining += ((ItemIdentifierStack)extra.getValue1()).stackSize;
        }
        if ((remaining -= donePromisses) < 1) {
            return;
        }
        LogisticsExtraPromise promise = new LogisticsExtraPromise();
        promise.item = requestedItem;
        promise.numberOfItems = Math.min(remaining, tree.getMissingItemCount());
        promise.sender = this;
        promise.provided = true;
        LinkedList<IFilter> relays = new LinkedList<IFilter>();
        for (IFilter filter : filters) {
            relays.add(filter);
        }
        promise.relayPoints = relays;
        tree.addPromise(promise);
    }

    @Override
    public CraftingTemplate addCrafting(ItemIdentifier toCraft) {
        int i;
        if (!this.isEnabled()) {
            return null;
        }
        BaseLogicCrafting craftingLogic = (BaseLogicCrafting)this.logic;
        List stack = craftingLogic.getCraftedItems();
        if (stack == null) {
            return null;
        }
        boolean found = false;
        ItemIdentifierStack craftingStack = null;
        for (ItemStack craftable : stack) {
            craftingStack = ItemIdentifierStack.GetFromStack(craftable);
            if (!craftingStack.getItem().equals(toCraft)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            target[i2] = this;
        }
        boolean hasSatellite = craftingLogic.isSatelliteConnected();
        if (!hasSatellite) {
            return null;
        }
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (craftingLogic.satelliteId != 0) {
                CoreRoutedPipe sat = craftingLogic.getSatelliteRouter(-1).getPipe();
                for (i = 6; i < 9; ++i) {
                    target[i] = sat;
                }
            }
        } else {
            for (int i3 = 0; i3 < 9; ++i3) {
                if (craftingLogic.advancedSatelliteIdArray[i3] == 0) continue;
                target[i3] = craftingLogic.getSatelliteRouter(i3).getPipe();
            }
        }
        CraftingTemplate template = new CraftingTemplate(craftingStack, this, craftingLogic.priority);
        for (i = 0; i < 9; ++i) {
            ItemStack resourceStack = craftingLogic.getMaterials(i);
            if (resourceStack == null || resourceStack.field_77994_a == 0) continue;
            template.addRequirement(ItemIdentifierStack.GetFromStack(resourceStack), target[i]);
        }
        int liquidCrafter = this.getUpgradeManager().getLiquidCrafter();
        IRequestLiquid[] liquidTarget = new IRequestLiquid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (craftingLogic.liquidSatelliteId != 0) {
                IRequestLiquid sat = (IRequestLiquid)((Object)craftingLogic.getLiquidSatelliteRouter(-1).getPipe());
                for (int i4 = 0; i4 < liquidCrafter; ++i4) {
                    liquidTarget[i4] = sat;
                }
            }
        } else {
            for (int i5 = 0; i5 < liquidCrafter; ++i5) {
                if (craftingLogic.liquidSatelliteIdArray[i5] == 0) continue;
                liquidTarget[i5] = (IRequestLiquid)((Object)craftingLogic.getLiquidSatelliteRouter(i5).getPipe());
            }
        }
        for (int i6 = 0; i6 < liquidCrafter; ++i6) {
            LiquidIdentifier liquid = craftingLogic.getLiquidMaterial(i6);
            int amount = craftingLogic.getLiquidAmount()[i6];
            if (liquid == null || amount <= 0 || liquidTarget[i6] == null) continue;
            template.addRequirement(liquid, amount, liquidTarget[i6]);
        }
        if (this.getUpgradeManager().hasByproductExtractor()) {
            template.addByproduct(ItemIdentifierStack.GetFromStack(((BaseLogicCrafting)this.logic).getByproductItem()));
        }
        return template;
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        if (promise instanceof LogisticsExtraPromise) {
            this.removeExtras(promise.numberOfItems, promise.item);
        }
        this._orderManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, promise.relayPoints);
        MainProxy.sendSpawnParticlePacket(1, this.getX(), this.getY(), this.getZ(), this.worldObj, 2);
    }

    @Override
    public void registerExtras(LogisticsPromise promise) {
        ItemIdentifierStack stack = new ItemIdentifierStack(promise.item, promise.numberOfItems);
        this._extras.add(new Pair3(stack, null, null));
        LogisticsPipes.requestLog.info(stack.stackSize + " extras registered");
    }

    @Override
    public void getAllItems(Map list, List filters) {
    }

    @Override
    public List getCraftedItems() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.providedItem();
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return new ModuleCrafter(this);
    }

    public boolean isAttachedSign(TileEntity entity) {
        return entity.field_70329_l == ((BaseLogicCrafting)this.logic).signEntityX && entity.field_70330_m == ((BaseLogicCrafting)this.logic).signEntityY && entity.field_70327_n == ((BaseLogicCrafting)this.logic).signEntityZ;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    public boolean hasOrder() {
        return this._orderManager.hasOrders();
    }

    @Override
    public int getTodo() {
        return this._orderManager.totalItemsCountInAllOrders();
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.getX(), this.getY(), this.getZ(), 1).getPacket());
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), this.oldList).getPacket(), (Player)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void listenedChanged() {
        this.doContentUpdate = true;
    }

    private void checkContentUpdate() {
        this.doContentUpdate = false;
        LinkedList all = this._orderManager.getContentList(this.worldObj);
        if (!this.oldList.equals(all)) {
            this.oldList.clear();
            this.oldList.addAll(all);
            MainProxy.sendToPlayerList(new PacketPipeInvContent(53, this.getX(), this.getY(), this.getZ(), all).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void setOrderManagerContent(Collection list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public double getLoadFactor() {
        return ((double)this._orderManager.totalItemsCountInAllOrders() + 63.0) / 64.0;
    }

    @CCCommand(description="Imports the crafting recipe from the connected machine/crafter")
    @CCQueued(prefunction="testImportAccess")
    public void reimport() {
        ((BaseLogicCrafting)this.logic).importFromCraftingTable(null);
    }

    @Override
    public Set getSpecificInterests() {
        List result = ((BaseLogicCrafting)this.logic).getCraftedItems();
        if (result == null) {
            return null;
        }
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (ItemStack craftable : result) {
            l1.add(ItemIdentifier.get(craftable));
        }
        return l1;
    }

    @Override
    public int getPriority() {
        return ((BaseLogicCrafting)this.logic).priority;
    }

    public List getCraftingSigns() {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 6; ++i) {
            if (!((BaseLogicCrafting)this.logic).craftingSigns[i]) continue;
            list.add(ForgeDirection.VALID_DIRECTIONS[i]);
        }
        return list;
    }

    public boolean setCraftingSign(ForgeDirection dir, boolean b, EntityPlayer player) {
        if (dir.ordinal() < 6 && ((BaseLogicCrafting)this.logic).craftingSigns[dir.ordinal()] != b) {
            ((BaseLogicCrafting)this.logic).craftingSigns[dir.ordinal()] = b;
            Packet packetA = new PacketPipeUpdate(36, this.getX(), this.getY(), this.getZ(), this.getLogisticsNetworkPacket()).getPacket();
            Packet packetB = new PacketInventoryChange(5, this.getX(), this.getY(), this.getZ(), ((BaseLogicCrafting)this.logic).getDummyInventory()).getPacket();
            if (player != null) {
                MainProxy.sendPacketToPlayer(packetA, (Player)player);
                MainProxy.sendPacketToPlayer(packetB, (Player)player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.worldObj), packetA);
            MainProxy.sendPacketToAllWatchingChunk(this.getX(), this.getZ(), MainProxy.getDimensionForWorld(this.worldObj), packetB);
            this.refreshRender(false);
            return true;
        }
        return false;
    }
}

