/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.ModuleApiaristAnalyser;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsApiaristAnalyser
extends CoreRoutedPipe
implements IInventoryProvider,
ISendRoutedItem {
    private ModuleApiaristAnalyser analyserModule = new ModuleApiaristAnalyser();

    public PipeItemsApiaristAnalyser(int itemID) {
        super(new TemporaryLogic(), itemID);
        this.analyserModule.registerHandler(this, this, this, this);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_APIARIST_ANALYSER_TEXTURE;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new TransportLayer(){

                @Override
                public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection blocked) {
                    return PipeItemsApiaristAnalyser.this.getPointedOrientation();
                }

                @Override
                public boolean stillWantItem(IRoutedItem item) {
                    return true;
                }
            };
        }
        return this._transportLayer;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (connection.equals((Object)this.getPointedOrientation())) {
            return Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return this.analyserModule;
    }

    @Override
    public Pair3 hasDestination(ItemIdentifier stack, boolean allowDefault, List routerIDsToExclude) {
        return SimpleServiceLocator.logisticsManager.hasDestination(stack, allowDefault, this.getRouter().getSimpleID(), routerIDsToExclude);
    }

    @Override
    public void sendStack(ItemStack stack, Pair3 reply, CoreRoutedPipe.ItemSendMode mode) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination((Integer)reply.getValue1());
        if (((SinkReply)reply.getValue2()).isPassive) {
            if (((SinkReply)reply.getValue2()).isDefault) {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Default);
            } else {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
            }
        }
        LinkedList<IFilter> list = new LinkedList<IFilter>();
        if (reply.getValue3() != null) {
            for (IFilter filter : (List)reply.getValue3()) {
                list.add(filter);
            }
        }
        itemToSend.addRelayPoints(list);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
    }

    @Override
    public void sendStack(ItemStack stack, int destination, CoreRoutedPipe.ItemSendMode mode, List relays) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        itemToSend.addRelayPoints(relays);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
    }

    private ForgeDirection getPointedOrientation() {
        for (ForgeDirection ori : ForgeDirection.values()) {
            Position pos = new Position((TileEntity)this.container);
            pos.orientation = ori;
            pos.moveForwards(1.0);
            TileEntity tile = this.worldObj.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile == null || !SimpleServiceLocator.forestryProxy.isTileAnalyser(tile)) continue;
            return ori;
        }
        return null;
    }

    private TileEntity getPointedTileEntity() {
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (tile.tile == null || !SimpleServiceLocator.forestryProxy.isTileAnalyser(tile.tile)) continue;
            return tile.tile;
        }
        return null;
    }

    @Override
    public IInventoryUtil getPointedInventory() {
        return null;
    }

    @Override
    public IInventoryUtil getPointedInventory(ExtractionMode mode) {
        return null;
    }

    @Override
    public IInventoryUtil getSneakyInventory() {
        return null;
    }

    @Override
    public IInventoryUtil getSneakyInventory(ForgeDirection _sneakyOrientation) {
        return null;
    }

    @Override
    public IInventoryUtil getUnsidedInventory() {
        IInventory inv = this.getRealInventory();
        if (inv == null) {
            return null;
        }
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
    }

    @Override
    public IInventory getRealInventory() {
        TileEntity tile = this.getPointedTileEntity();
        if (tile == null) {
            return null;
        }
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof IInventory)) {
            return null;
        }
        return InventoryHelper.getInventory((IInventory)tile);
    }

    @Override
    public ForgeDirection inventoryOrientation() {
        return this.getPointedOrientation();
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    public void setTile(TileEntity tile) {
        super.setTile(tile);
        this.analyserModule.registerSlot(0);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }
}

