/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.nbt.NBTTagCompound;

public class PacketRequestSubmit
extends PacketCoordinates {
    public int itemID;
    public int dataValue;
    public int amount;
    public NBTTagCompound tag;
    public int dimension;

    public PacketRequestSubmit() {
    }

    public PacketRequestSubmit(int x, int y, int z, int dim, ItemIdentifier selectedItem, int amount) {
        this(x, y, z, dim, selectedItem, amount, 11);
    }

    public PacketRequestSubmit(int x, int y, int z, int dim, ItemIdentifier selectedItem, int amount, int id) {
        super(id, x, y, z);
        this.itemID = selectedItem.itemID;
        this.dataValue = selectedItem.itemDamage;
        this.tag = selectedItem.tag;
        this.amount = amount;
        this.dimension = dim;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.itemID);
        data.writeInt(this.dataValue);
        data.writeInt(this.amount);
        SendNBTTagCompound.writeNBTTagCompound(this.tag, data);
        data.writeInt(this.dimension);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.itemID = data.readInt();
        this.dataValue = data.readInt();
        this.amount = data.readInt();
        this.tag = SendNBTTagCompound.readNBTTagCompound(data);
        this.dimension = data.readInt();
    }
}

