/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.packets.LogisticsPipesPacket;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketRequestGuiContent
extends LogisticsPipesPacket {
    public Collection _allItems;
    private int id;

    public PacketRequestGuiContent() {
        this._allItems = new TreeSet(new ItemIdentifierStack.itemComparitor());
    }

    public PacketRequestGuiContent(TreeSet _allItems2) {
        this._allItems = _allItems2;
        this.id = 13;
    }

    public PacketRequestGuiContent(Collection allItems, int id) {
        this._allItems = allItems;
        this.id = id;
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (ItemIdentifierStack item : this._allItems) {
            data.write(1);
            data.writeInt(item.getItem().itemID);
            data.writeInt(item.getItem().itemDamage);
            data.writeInt(item.stackSize);
            SendNBTTagCompound.writeNBTTagCompound(item.getItem().tag, data);
        }
        data.write(0);
    }

    public void readData(DataInputStream data) throws IOException {
        while (data.read() != 0) {
            int itemID = data.readInt();
            int dataValue = data.readInt();
            int amount = data.readInt();
            NBTTagCompound tag = SendNBTTagCompound.readNBTTagCompound(data);
            this._allItems.add(ItemIdentifier.get(itemID, dataValue, tag).makeStack(amount));
        }
    }

    public int getID() {
        return this.id;
    }
}

