/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.packets.LogisticsPipesPacket;
import logisticspipes.utils.ItemIdentifier;

public class PacketNameUpdatePacket
extends LogisticsPipesPacket {
    public ItemIdentifier item;
    public String name;

    public PacketNameUpdatePacket(ItemIdentifier item) {
        this.item = item;
        this.name = item.getFriendlyName();
    }

    public PacketNameUpdatePacket(ItemIdentifier item, String name) {
        this.item = item;
        this.name = name;
    }

    public PacketNameUpdatePacket() {
    }

    public int getID() {
        return 82;
    }

    public void readData(DataInputStream data) throws IOException {
        this.item = ItemIdentifier.get(data.readInt(), data.readInt(), null);
        this.name = data.readUTF();
    }

    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.item.itemID);
        data.writeInt(this.item.itemDamage);
        data.writeUTF(this.name);
    }
}

