/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import logisticspipes.network.packets.BitSetHelper;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.proxy.MainProxy;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class PacketLiquidUpdate
extends PacketCoordinates {
    public LiquidStack[] renderCache = new LiquidStack[ForgeDirection.values().length];
    public BitSet delta;

    public PacketLiquidUpdate(int xCoord, int yCoord, int zCoord) {
        super(83, xCoord, yCoord, zCoord);
    }

    public PacketLiquidUpdate(int xCoord, int yCoord, int zCoord, boolean chunkPacket) {
        super(83, xCoord, yCoord, zCoord);
        this.isChunkDataPacket = chunkPacket;
    }

    public PacketLiquidUpdate() {
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        World world = MainProxy.getClientMainWorld();
        if (!world.func_72899_e(this.posX, this.posY, this.posZ)) {
            return;
        }
        TileEntity entity = world.func_72796_p(this.posX, this.posY, this.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeLiquidTransportLogistics)) {
            return;
        }
        PipeLiquidTransportLogistics transLiq = (PipeLiquidTransportLogistics)pipe.pipe.transport;
        this.renderCache = transLiq.renderCache;
        this.delta = BitSetHelper.read(data);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (this.renderCache[dir.ordinal()] == null) {
                this.renderCache[dir.ordinal()] = new LiquidStack(0, 0, 0);
            }
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                this.renderCache[dir.ordinal()] = new LiquidStack((int)data.readShort(), this.renderCache[dir.ordinal()].amount);
            }
            if (this.delta.get(dir.ordinal() * 3 + 1)) {
                this.renderCache[dir.ordinal()] = new LiquidStack(this.renderCache[dir.ordinal()].itemID, this.renderCache[dir.ordinal()].amount, (int)data.readShort());
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            this.renderCache[dir.ordinal()].amount = dir != ForgeDirection.UNKNOWN ? Math.min(transLiq.getSideCapacity(), data.readShort()) : Math.min(transLiq.getInnerCapacity(), data.readShort());
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        BitSetHelper.write(data, this.delta);
        for (ForgeDirection dir : ForgeDirection.values()) {
            LiquidStack liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                if (liquid != null) {
                    data.writeShort(liquid.itemID);
                } else {
                    data.writeShort(0);
                }
            }
            if (this.delta.get(dir.ordinal() * 3 + 1)) {
                if (liquid != null) {
                    data.writeShort(liquid.itemMeta);
                } else {
                    data.writeShort(0);
                }
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            if (liquid != null) {
                data.writeShort(liquid.amount);
                continue;
            }
            data.writeShort(0);
        }
    }
}

