/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.packets.PacketCoordinates;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class PacketInventoryChange
extends PacketCoordinates {
    public IInventory inventory;
    public LinkedList itemStacks;

    public PacketInventoryChange() {
    }

    public PacketInventoryChange(int id, int x, int y, int z, IInventory inventory) {
        super(id, x, y, z);
        this.inventory = inventory;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            data.writeByte(i);
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack != null) {
                data.writeInt(itemstack.field_77993_c);
                data.writeInt(itemstack.field_77994_a);
                data.writeInt(itemstack.func_77960_j());
                SendNBTTagCompound.writeNBTTagCompound(itemstack.func_77978_p(), data);
                continue;
            }
            data.writeInt(0);
        }
        data.writeByte(-1);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.itemStacks = new LinkedList();
        byte index = data.readByte();
        while (index != -1) {
            int itemID = data.readInt();
            if (itemID == 0) {
                this.itemStacks.addLast(null);
            } else {
                ItemStack stack = new ItemStack(itemID, data.readInt(), data.readInt());
                stack.func_77982_d(SendNBTTagCompound.readNBTTagCompound(data));
                this.itemStacks.addLast(stack);
            }
            index = data.readByte();
        }
    }
}

