/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public class BitSetHelper {
    public static BitSet read(DataInputStream data) throws IOException {
        byte size = data.readByte();
        byte[] bytes = new byte[size];
        data.read(bytes);
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static void write(DataOutputStream data, BitSet bits) throws IOException {
        byte[] bytes = new byte[(bits.length() + 7) / 8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        data.writeByte(bytes.length);
        data.write(bytes);
    }
}

