/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDProviderModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.logisticspipes.ExtractionMode;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsOrderManager;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleProvider
implements ILogisticsGuiModule,
ILegacyActiveModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive {
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected IRoutedPowerProvider _power;
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager();
    private List _previousLegacyModules = new LinkedList();
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Items to provide (or empty for all)", 1);
    protected final int ticksToAction = 6;
    protected int currentTick = 0;
    protected boolean isExcludeFilter = false;
    protected ExtractionMode _extractionMode = ExtractionMode.Normal;
    private int slot = 0;
    private IWorldProvider _world;
    private final Map displayMap = new HashMap();
    public final ArrayList displayList = new ArrayList();
    private final ArrayList oldList = new ArrayList();
    private IHUDModuleRenderer HUD = new HUDProviderModule(this);
    private final List localModeWatchers = new ArrayList();

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.isExcludeFilter = nbttagcompound.func_74767_n("filterisexclude");
        this._extractionMode = ExtractionMode.getMode(nbttagcompound.func_74762_e("extractionMode"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("filterisexclude", this.isExcludeFilter);
        nbttagcompound.func_74768_a("extractionMode", this._extractionMode.ordinal());
    }

    @Override
    public int getGuiHandlerID() {
        return 24;
    }

    protected int neededEnergy() {
        return 1;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    protected int itemsToExtract() {
        return 8;
    }

    protected int stacksToExtract() {
        return 1;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        int sent;
        if (++this.currentTick < 6) {
            return;
        }
        this.currentTick = 0;
        this.checkUpdate(null);
        int itemsleft = this.itemsToExtract();
        Pair3 firstOrder = null;
        Pair3 order = null;
        for (int stacksleft = this.stacksToExtract(); itemsleft > 0 && stacksleft > 0 && this._orderManager.hasOrders() && (firstOrder == null || firstOrder != order); --stacksleft, itemsleft -= sent) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((sent = this.sendStack((ItemIdentifierStack)(order = this._orderManager.peekAtTopRequest()).getValue1(), itemsleft, ((IRequestItems)order.getValue2()).getRouter().getSimpleID(), (List)order.getValue3())) < 0) break;
            MainProxy.sendSpawnParticlePacket(6, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 3);
        }
    }

    @Override
    public void registerPreviousLegacyModules(List previousModules) {
        this._previousLegacyModules = previousModules;
    }

    @Override
    public boolean filterAllowsItem(ItemIdentifier item) {
        if (!this.hasFilter()) {
            return true;
        }
        boolean isFiltered = this.itemIsFiltered(item);
        return this.isExcludeFilter ^ isFiltered;
    }

    @Override
    public void onBlockRemoval() {
        while (this._orderManager.hasOrders()) {
            this._orderManager.sendFailed();
        }
    }

    @Override
    public void canProvide(RequestTreeNode tree, int donePromisses, List filters) {
        int canProvide = this.getAvailableItemCount(tree.getStackItem());
        if ((canProvide -= donePromisses) < 1) {
            return;
        }
        LogisticsPromise promise = new LogisticsPromise();
        promise.item = tree.getStackItem();
        promise.numberOfItems = Math.min(canProvide, tree.getMissingItemCount());
        promise.sender = (IProvideItems)((Object)this._itemSender);
        promise.relayPoints = new LinkedList(filters);
        tree.addPromise(promise);
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        this._orderManager.addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, promise.relayPoints);
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        return this.getTotalItemCount(item) - this._orderManager.totalItemsCountInOrders(item);
    }

    @Override
    public void getAllItems(Map items, List filters) {
        if (this._invProvider.getPointedInventory(this._extractionMode) == null) {
            return;
        }
        IInventoryUtil inv = this._invProvider.getPointedInventory(this._extractionMode);
        Map currentInv = inv.getItemsAndCount();
        block0: for (Map.Entry currItem : currentInv.entrySet()) {
            if (items.containsKey(currItem.getKey()) || !this.filterAllowsItem((ItemIdentifier)currItem.getKey())) continue;
            for (ILegacyActiveModule m : this._previousLegacyModules) {
                if (!m.filterAllowsItem((ItemIdentifier)currItem.getKey())) continue;
                continue block0;
            }
            for (IFilter filter : filters) {
                if (filter.isBlocked() != filter.isFilteredItem(((ItemIdentifier)currItem.getKey()).getUndamaged()) && !filter.blockProvider()) continue;
                continue block0;
            }
            int remaining = (Integer)currItem.getValue() - this._orderManager.totalItemsCountInOrders((ItemIdentifier)currItem.getKey());
            if (remaining < 1) continue;
            items.put(currItem.getKey(), remaining);
        }
    }

    private int sendStack(ItemIdentifierStack stack, int maxCount, int destination, List relays) {
        ItemIdentifier item = stack.getItem();
        if (this._invProvider.getPointedInventory(this._extractionMode) == null) {
            this._orderManager.sendFailed();
            return 0;
        }
        IInventoryUtil inv = this._invProvider.getPointedInventory(this._extractionMode);
        int available = inv.itemCount(item);
        if (available == 0) {
            this._orderManager.sendFailed();
            return 0;
        }
        int wanted = Math.min(available, stack.stackSize);
        wanted = Math.min(wanted, maxCount);
        wanted = Math.min(wanted, item.getMaxStackSize());
        IRouter dRtr = SimpleServiceLocator.routerManager.getRouterUnsafe(destination, false);
        if (dRtr == null) {
            this._orderManager.sendFailed();
            return 0;
        }
        SinkReply reply = LogisticsManagerV2.canSink(dRtr, null, true, stack.getItem(), null, true, false);
        boolean defersend = false;
        if (reply != null && reply.maxNumberOfItems < wanted) {
            wanted = reply.maxNumberOfItems;
            if (wanted <= 0) {
                this._orderManager.deferSend();
                return 0;
            }
            defersend = true;
        }
        if (!this._power.canUseEnergy(wanted * this.neededEnergy())) {
            return -1;
        }
        ItemStack removed = inv.getMultipleItems(item, wanted);
        int sent = removed.field_77994_a;
        this._power.useEnergy(sent * this.neededEnergy());
        this._itemSender.sendStack(removed, destination, this.itemSendMode(), relays);
        this._orderManager.sendSuccessfull(sent, defersend);
        return sent;
    }

    private int getTotalItemCount(ItemIdentifier item) {
        if (this._invProvider.getPointedInventory(this._extractionMode) == null) {
            return 0;
        }
        if (!this.filterAllowsItem(item)) {
            return 0;
        }
        IInventoryUtil inv = this._invProvider.getPointedInventory(this._extractionMode);
        return inv.itemCount(item);
    }

    private boolean hasFilter() {
        return !this._filterInventory.isEmpty();
    }

    private boolean itemIsFiltered(ItemIdentifier item) {
        return this._filterInventory.containsItem(item);
    }

    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isExcludeFilter() {
        return this.isExcludeFilter;
    }

    public void setFilterExcluded(boolean isExcludeFilter) {
        this.isExcludeFilter = isExcludeFilter;
    }

    public ExtractionMode getExtractionMode() {
        return this._extractionMode;
    }

    public void setExtractionMode(int id) {
        this._extractionMode = ExtractionMode.getMode(id);
    }

    public void nextExtractionMode() {
        this._extractionMode = this._extractionMode.next();
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(!this.isExcludeFilter ? "Included" : "Excluded");
        list.add("Mode: " + this._extractionMode.getExtractionModeString());
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1 - this.slot;
    }

    private void checkUpdate(EntityPlayer player) {
        if (this.localModeWatchers.size() == 0 && player == null) {
            return;
        }
        this.displayList.clear();
        this.displayMap.clear();
        this.getAllItems(this.displayMap, new ArrayList(0));
        this.displayList.ensureCapacity(this.displayMap.size());
        for (Map.Entry item : this.displayMap.entrySet()) {
            this.displayList.add(new ItemIdentifierStack((ItemIdentifier)item.getKey(), (Integer)item.getValue()));
        }
        if (!this.oldList.equals(this.displayList)) {
            this.oldList.clear();
            this.oldList.ensureCapacity(this.displayList.size());
            this.oldList.addAll(this.displayList);
            MainProxy.sendCompressedToPlayerList(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, this.displayList).getPacket(), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendCompressedPacketToPlayer(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, this.displayList).getPacket(), (Player)player);
        }
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        this.checkUpdate(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        if (this.isExcludeFilter || this._filterInventory.isEmpty()) {
            return null;
        }
        Map mapIC = this._filterInventory.getItemsAndCount();
        ArrayList li = new ArrayList(mapIC.size());
        li.addAll(mapIC.keySet());
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return this.isExcludeFilter || this._filterInventory.isEmpty();
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleProvider");
    }
}

