/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleItemSink
implements ILogisticsGuiModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Requested items", 1);
    private boolean _isDefaultRoute;
    private int slot = 0;
    private IHUDModuleRenderer HUD = new HUDItemSink(this);
    private IRoutedPowerProvider _power;
    private final List localModeWatchers = new ArrayList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0);
    private static final SinkReply _sinkReplyDefault = new SinkReply(SinkReply.FixedPriority.DefaultRoute, 0, true, true, 1, 0);

    public ModuleItemSink() {
        this._filterInventory.addListener(this);
    }

    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDefaultRoute() {
        return this._isDefaultRoute;
    }

    public void setDefaultRoute(boolean isDefaultRoute) {
        this._isDefaultRoute = isDefaultRoute;
        MainProxy.sendToPlayerList(new PacketModuleInteger(17, this.getX(), this.getY(), this.getZ(), this.slot, this.isDefaultRoute() ? 1 : 0).getPacket(), this.localModeWatchers);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._power = powerprovider;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return -1 - this.slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (this._isDefaultRoute && !allowDefault) {
            return null;
        }
        if (bestPriority > ModuleItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleItemSink._sinkReply.customPriority) {
            return null;
        }
        if (this._filterInventory.containsUndamagedItem(item.getUndamaged())) {
            if (this._power.canUseEnergy(1)) {
                return _sinkReply;
            }
            return null;
        }
        if (this._isDefaultRoute) {
            if (bestPriority > ModuleItemSink._sinkReplyDefault.fixedPriority.ordinal() || bestPriority == ModuleItemSink._sinkReplyDefault.fixedPriority.ordinal() && bestCustomPriority >= ModuleItemSink._sinkReplyDefault.customPriority) {
                return null;
            }
            if (this._power.canUseEnergy(1)) {
                return _sinkReplyDefault;
            }
            return null;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 21;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDefaultRoute(nbttagcompound.func_74767_n("defaultdestination"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("defaultdestination", this.isDefaultRoute());
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Default: " + (this.isDefaultRoute() ? "Yes" : "No"));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(17, this.getX(), this.getY(), this.getZ(), this.slot, this.isDefaultRoute() ? 1 : 0).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, ItemIdentifierStack.getListFromInventory(inventory)).getPacket(), this.localModeWatchers);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return this._isDefaultRoute;
    }

    @Override
    public List getSpecificInterests() {
        if (this._isDefaultRoute) {
            return null;
        }
        Map mapIC = this._filterInventory.getItemsAndCount();
        ArrayList<Object> li = new ArrayList<Object>(mapIC.size());
        li.addAll(mapIC.keySet());
        for (ItemIdentifier id : mapIC.keySet()) {
            li.add(id.getUndamaged());
        }
        return li;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleItemSink");
    }
}

