/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ModuleExtractor
implements ILogisticsGuiModule,
ISneakyDirectionReceiver,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    private int currentTick = 0;
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private IRoutedPowerProvider _power;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private IWorldProvider _world;
    private int slot = 0;
    private IHUDModuleRenderer HUD = new HUDExtractor(this);
    private final List localModeWatchers = new ArrayList();

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int neededEnergy() {
        return 5;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
        MainProxy.sendToPlayerList(new PacketModuleInteger(25, this.getX(), this.getY(), this.getZ(), this.slot, this._sneakyDirection.ordinal()).getPacket(), this.localModeWatchers);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 20;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.func_74762_e("sneakydirection")];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        IInventory realInventory = this._invProvider.getRealInventory();
        if (realInventory == null) {
            return;
        }
        ForgeDirection extractOrientation = this._sneakyDirection;
        if (extractOrientation == ForgeDirection.UNKNOWN) {
            extractOrientation = this._invProvider.inventoryOrientation().getOpposite();
        }
        IInventoryUtil targetUtil = this._invProvider.getSneakyInventory(extractOrientation);
        if (realInventory instanceof ISpecialInventory && !targetUtil.isSpecialInventory()) {
            ItemStack[] stack = ((ISpecialInventory)realInventory).extractItem(false, extractOrientation, 1);
            if (stack == null || stack.length < 1 || stack[0] == null || stack[0].field_77994_a == 0) {
                return;
            }
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(stack[0]), true, new ArrayList());
            if (reply == null) {
                return;
            }
            ItemStack[] stacks = ((ISpecialInventory)realInventory).extractItem(true, extractOrientation, 1);
            if (stacks == null || stacks.length < 1 || stacks[0] == null || stacks[0].field_77994_a == 0) {
                LogisticsPipes.log.info("extractor extractItem(true) got nothing from " + realInventory.toString());
                return;
            }
            if (!ItemStack.func_77989_b((ItemStack)stack[0], (ItemStack)stacks[0])) {
                LogisticsPipes.log.info("extractor extract got a unexpected item from " + realInventory.toString());
            }
            this._itemSender.sendStack(stacks[0], reply, this.itemSendMode());
            return;
        }
        block0: for (int i = 0; i < targetUtil.getSizeInventory(); ++i) {
            ItemStack slot = targetUtil.getStackInSlot(i);
            if (slot == null) continue;
            LinkedList<Object> jamList = new LinkedList<Object>();
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            if (reply == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                int count = Math.min(itemsleft, slot.field_77994_a);
                if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                    count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                }
                while (!this._power.useEnergy(this.neededEnergy() * count) && count > 0) {
                    MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 2);
                    --count;
                }
                if (count <= 0) break block0;
                ItemStack stackToSend = targetUtil.decrStackSize(i, count);
                this._itemSender.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems() || (slot = targetUtil.getStackInSlot(i)) == null) break block0;
                jamList.add(reply.getValue1());
                reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), true, jamList);
            }
            break;
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        return list;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1 - this.slot;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendToPlayerList(new PacketModuleInteger(25, this.getX(), this.getY(), this.getZ(), this.slot, this._sneakyDirection.ordinal()).getPacket(), this.localModeWatchers);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleExtractor");
    }
}

