/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleElectricBuffer
implements ILogisticsModule {
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private ISendRoutedItem _itemSender;
    private IWorldProvider _world;
    private int currentTickCount = 0;
    private int ticksToAction = 80;
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricNetwork, 0, true, false, 1, 0);

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerProvider) {
        this._invProvider = invProvider;
        this._power = powerProvider;
        this._world = world;
        this._itemSender = itemSender;
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this._power.getX();
    }

    @Override
    public final int getY() {
        return this._power.getX();
    }

    @Override
    public final int getZ() {
        return this._power.getX();
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stack, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricNetwork.ordinal()) {
            return null;
        }
        if (SimpleServiceLocator.IC2Proxy.isElectricItem(stack.makeNormalStack(1)) && this._power.canUseEnergy(1)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (++this.currentTickCount < this.ticksToAction) {
            return;
        }
        this.currentTickCount = 0;
        IInventoryUtil inv = this._invProvider.getPointedInventory();
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            Pair3 reply;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || !SimpleServiceLocator.IC2Proxy.isElectricItem(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork)) == null) continue;
            MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 2);
            this._itemSender.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleElectricBuffer");
    }
}

