/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleApiaristAnalyser
implements ILogisticsGuiModule,
IClientInformationProvider,
IModuleWatchReciver {
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private int ticksToAction = 100;
    private int currentTick = 0;
    private int slot = 0;
    private final List localModeWatchers = new ArrayList();
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    public boolean extractMode = true;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.APIARIST_Analyser, 0, true, false, 3, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.extractMode = nbt.func_74767_n("extractMode");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("extractMode", this.extractMode);
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier itemID, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > ModuleApiaristAnalyser._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleApiaristAnalyser._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleApiaristAnalyser._sinkReply.customPriority) {
            return null;
        }
        ItemStack item = itemID.makeNormalStack(1);
        if (SimpleServiceLocator.forestryProxy.isBee(item) && !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this._power.canUseEnergy(3)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (this.extractMode) {
            if (++this.currentTick < this.ticksToAction) {
                return;
            }
            this.currentTick = 0;
            IInventoryUtil inv = this._invProvider.getUnsidedInventory();
            if (inv == null) {
                return;
            }
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                Pair3 reply;
                ItemStack item = inv.getStackInSlot(i);
                if (!SimpleServiceLocator.forestryProxy.isBee(item) || !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) || (reply = this._itemSender.hasDestination(ItemIdentifier.get(item), true, new ArrayList())) == null || !this._power.useEnergy(6)) continue;
                this._itemSender.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            }
        }
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._invProvider.getY();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._invProvider.getZ();
        }
        return -1 - this.slot;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    public int getGuiHandlerID() {
        return 42;
    }

    public void setExtractMode(int mode) {
        if (this.getExtractMode() == mode) {
            return;
        }
        if (mode == 1) {
            this.extractMode = true;
        } else if (mode == 0) {
            this.extractMode = false;
        }
        this.modeChanged();
    }

    public int getExtractMode() {
        return this.extractMode ? 1 : 0;
    }

    public void modeChanged() {
        if (this._world != null) {
            if (MainProxy.isServer(this._world.getWorld())) {
                MainProxy.sendToPlayerList(new PacketModuleInteger(103, this.getX(), this.getY(), this.getZ(), this.slot, this.getExtractMode()).getPacket(), this.localModeWatchers);
            } else {
                MainProxy.sendPacketToServer(new PacketModuleInteger(103, this.getX(), this.getY(), this.getZ(), this.slot, this.getExtractMode()).getPacket());
            }
        } else {
            MainProxy.sendPacketToServer(new PacketModuleInteger(103, this.getX(), this.getY(), this.getZ(), this.slot, this.getExtractMode()).getPacket());
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Extract Mode:");
        info.add(" - " + (this.extractMode ? "on" : "off"));
        return info;
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(103, this.getX(), this.getY(), this.getZ(), this.slot, this.getExtractMode()).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleApiaristAnalyser");
    }
}

