/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDAdvancedExtractor;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISneakyDirectionReceiver;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ModuleAdvancedExtractor
implements ILogisticsGuiModule,
ISneakyDirectionReceiver,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
ISimpleInventoryEventHandler {
    protected int currentTick = 0;
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Item list", 1);
    private boolean _itemsIncluded = true;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected IRoutedPowerProvider _power;
    private ForgeDirection _sneakyDirection = ForgeDirection.UNKNOWN;
    private int slot = 0;
    private IWorldProvider _world;
    private IHUDModuleRenderer HUD = new HUDAdvancedExtractor(this);
    private final List localModeWatchers = new ArrayList();

    public ModuleAdvancedExtractor() {
        this._filterInventory.addListener(this);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    public SimpleInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public ForgeDirection getSneakyDirection() {
        return this._sneakyDirection;
    }

    @Override
    public void setSneakyDirection(ForgeDirection sneakyDirection) {
        this._sneakyDirection = sneakyDirection;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound);
        this.setItemsIncluded(nbttagcompound.func_74767_n("itemsIncluded"));
        if (nbttagcompound.func_74764_b("sneakydirection")) {
            this._sneakyDirection = ForgeDirection.values()[nbttagcompound.func_74762_e("sneakydirection")];
        } else if (nbttagcompound.func_74764_b("sneakyorientation")) {
            int t = nbttagcompound.func_74762_e("sneakyorientation");
            switch (t) {
                default: {
                    this._sneakyDirection = ForgeDirection.UNKNOWN;
                    break;
                }
                case 1: {
                    this._sneakyDirection = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    this._sneakyDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._sneakyDirection = ForgeDirection.DOWN;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("itemsIncluded", this.areItemsIncluded());
        nbttagcompound.func_74768_a("sneakydirection", this._sneakyDirection.ordinal());
    }

    @Override
    public int getGuiHandlerID() {
        return 27;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    protected int neededEnergy() {
        return 6;
    }

    protected CoreRoutedPipe.ItemSendMode itemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void tick() {
        IInventoryUtil inventory;
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        ForgeDirection extractOrientation = this._sneakyDirection;
        if (extractOrientation == ForgeDirection.UNKNOWN) {
            extractOrientation = this._invProvider.inventoryOrientation().getOpposite();
        }
        if ((inventory = this._invProvider.getSneakyInventory(extractOrientation)) == null) {
            return;
        }
        this.checkExtract(inventory);
    }

    private void checkExtract(IInventoryUtil invUtil) {
        Map items = invUtil.getItemsAndCount();
        for (Map.Entry item : items.entrySet()) {
            if (!this.CanExtract(((ItemIdentifier)item.getKey()).makeNormalStack((Integer)item.getValue()))) continue;
            LinkedList<Object> jamList = new LinkedList<Object>();
            Pair3 reply = this._itemSender.hasDestination((ItemIdentifier)item.getKey(), true, jamList);
            if (reply == null) continue;
            int itemsleft = this.itemsToExtract();
            while (reply != null) {
                int count = Math.min(itemsleft, (Integer)item.getValue());
                if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                    count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                }
                while (!this._power.useEnergy(this.neededEnergy() * count) && count > 0) {
                    MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 2);
                    --count;
                }
                if (count <= 0) break;
                ItemStack stackToSend = invUtil.getMultipleItems((ItemIdentifier)item.getKey(), (Integer)item.getValue());
                this._itemSender.sendStack(stackToSend, reply, this.itemSendMode());
                if ((itemsleft -= count) <= 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems()) break;
                jamList.add(reply.getValue1());
                reply = this._itemSender.hasDestination((ItemIdentifier)item.getKey(), true, jamList);
            }
            return;
        }
    }

    public boolean CanExtract(ItemStack item) {
        for (int i = 0; i < this._filterInventory.func_70302_i_(); ++i) {
            ItemStack stack = this._filterInventory.func_70301_a(i);
            if (stack == null || stack.field_77993_c != item.field_77993_c) continue;
            if (Item.field_77698_e[item.field_77993_c].func_77645_m()) {
                return this.areItemsIncluded();
            }
            if (stack.func_77960_j() != item.func_77960_j()) continue;
            return this.areItemsIncluded();
        }
        return !this.areItemsIncluded();
    }

    public boolean areItemsIncluded() {
        return this._itemsIncluded;
    }

    public void setItemsIncluded(boolean flag) {
        this._itemsIncluded = flag;
        MainProxy.sendToPlayerList(new PacketModuleInteger(31, this.getX(), this.getY(), this.getZ(), this.slot, this.areItemsIncluded() ? 1 : 0).getPacket(), this.localModeWatchers);
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add(this.areItemsIncluded() ? "Included" : "Excluded");
        list.add("Extraction: " + (this._sneakyDirection == ForgeDirection.UNKNOWN ? "DEFAULT" : this._sneakyDirection.name()));
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return -1 - this.slot;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, ItemIdentifierStack.getListFromInventory(inventory)).getPacket(), this.localModeWatchers);
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.getX(), this.getY(), this.getZ(), this.slot).getPacket());
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInvContent(62, this.getX(), this.getY(), this.getZ(), this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(25, this.getX(), this.getY(), this.getZ(), this.slot, this._sneakyDirection.ordinal()).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(31, this.getX(), this.getY(), this.getZ(), this.slot, this.areItemsIncluded() ? 1 : 0).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleAdvancedExtractor");
    }
}

