/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.utils.SinkReply;
import net.minecraftforge.common.ForgeDirection;

public class ChassiTransportLayer
extends TransportLayer {
    private final PipeLogisticsChassi _chassiPipe;

    public ChassiTransportLayer(PipeLogisticsChassi chassiPipe) {
        this._chassiPipe = chassiPipe;
    }

    @Override
    public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection blocked) {
        item.setArrived(true);
        this._chassiPipe.getRouter().inboundItemArrived((RoutedEntityItem)item);
        return this._chassiPipe.getPointedOrientation();
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        ILogisticsModule module = this._chassiPipe.getLogisticsModule();
        if (module == null) {
            return false;
        }
        if (!this._chassiPipe.isEnabled()) {
            return false;
        }
        SinkReply reply = module.sinksItem(item.getIDStack().getItem(), -1, 0, true, false);
        if (reply == null) {
            return false;
        }
        if (reply.maxNumberOfItems != 0 && item.getItemStack().field_77994_a > reply.maxNumberOfItems) {
            ForgeDirection o = this._chassiPipe.getPointedOrientation();
            if (o == null || o == ForgeDirection.UNKNOWN) {
                o = ForgeDirection.UP;
            }
            item.split(this._chassiPipe.worldObj, reply.maxNumberOfItems, o);
        }
        return true;
    }
}

