/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.ILiquidSink;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.logistics.ILogisticsLiquidManager;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.LiquidStack;

public class LogisticsLiquidManager
implements ILogisticsLiquidManager {
    @Override
    public Pair getBestReply(LiquidStack stack, IRouter sourceRouter, List jamList) {
        for (ExitRoute candidateRouter : sourceRouter.getIRoutersByCost()) {
            int amount;
            CoreRoutedPipe pipe;
            if (!candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo) || candidateRouter.destination.getSimpleID() == sourceRouter.getSimpleID() || jamList.contains(candidateRouter.destination.getSimpleID()) || candidateRouter.destination.getPipe() == null || !candidateRouter.destination.getPipe().isEnabled() || !((pipe = candidateRouter.destination.getPipe()) instanceof ILiquidSink) || (amount = ((ILiquidSink)((Object)pipe)).sinkAmount(stack)) <= 0) continue;
            Pair result = new Pair(candidateRouter.destination.getSimpleID(), amount);
            return result;
        }
        Pair result = new Pair(0, 0);
        return result;
    }

    @Override
    public ItemStack getLiquidContainer(LiquidStack stack) {
        ItemStack item = new ItemStack(LogisticsPipes.LogisticsLiquidContainer, 1);
        NBTTagCompound nbt = new NBTTagCompound("tag");
        stack.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return item;
    }

    @Override
    public LiquidStack getLiquidFromContainer(ItemStack stack) {
        if (stack.func_77973_b() instanceof LogisticsLiquidContainer && stack.func_77942_o()) {
            return LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)stack.func_77978_p());
        }
        return null;
    }

    @Override
    public TreeSet getAvailableLiquid(List validDestinations) {
        HashMap allAvailableItems = new HashMap();
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof ILiquidProvider)) continue;
            ILiquidProvider provider = (ILiquidProvider)((Object)r.destination.getPipe());
            Map allItems = provider.getAvailableLiquids();
            for (Map.Entry liquid : allItems.entrySet()) {
                Integer amount = (Integer)allAvailableItems.get(((LiquidIdentifier)liquid.getKey()).getItemIdentifier());
                if (amount == null) {
                    allAvailableItems.put(((LiquidIdentifier)liquid.getKey()).getItemIdentifier(), liquid.getValue());
                    continue;
                }
                allAvailableItems.put(((LiquidIdentifier)liquid.getKey()).getItemIdentifier(), amount + (Integer)liquid.getValue());
            }
        }
        TreeSet<ItemIdentifierStack> itemIdentifierStackList = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry item : allAvailableItems.entrySet()) {
            itemIdentifierStackList.add(new ItemIdentifierStack((ItemIdentifier)item.getKey(), (Integer)item.getValue()));
        }
        return itemIdentifierStackList;
    }
}

