/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.pipes.PipeItemsLiquidSupplier;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class LogicLiquidSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Liquids to keep stocked", 127);
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public IRoutedPowerProvider _power;

    public LogicLiquidSupplier() {
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void throttledUpdateEntity() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            ILiquidTank[] result;
            ITankContainer container;
            if (!(tile.tile instanceof ITankContainer) || tile.tile instanceof TileGenericPipe || (container = (ITankContainer)tile.tile).getTanks(ForgeDirection.UNKNOWN) == null || container.getTanks(ForgeDirection.UNKNOWN).length == 0) continue;
            Map wantContainers = this.dummyInventory.getItemsAndCount();
            HashMap<LiquidIdentifier, Integer> wantLiquids = new HashMap<LiquidIdentifier, Integer>();
            for (Map.Entry item : wantContainers.entrySet()) {
                ItemStack wantItem = ((ItemIdentifier)item.getKey()).unsafeMakeNormalStack(1);
                LiquidStack liquidStack = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)wantItem);
                if (liquidStack == null) continue;
                wantLiquids.put(LiquidIdentifier.get(liquidStack), (Integer)item.getValue() * liquidStack.amount);
            }
            HashMap<LiquidIdentifier, Integer> haveLiquids = new HashMap<LiquidIdentifier, Integer>();
            for (ILiquidTank slot : result = container.getTanks(ForgeDirection.UNKNOWN)) {
                if (slot.getLiquid() == null || !wantLiquids.containsKey(LiquidIdentifier.get(slot.getLiquid()))) continue;
                Integer liquidWant = (Integer)haveLiquids.get(LiquidIdentifier.get(slot.getLiquid()));
                if (liquidWant == null) {
                    haveLiquids.put(LiquidIdentifier.get(slot.getLiquid()), slot.getLiquid().amount);
                    continue;
                }
                haveLiquids.put(LiquidIdentifier.get(slot.getLiquid()), liquidWant + slot.getLiquid().amount);
            }
            for (Map.Entry entry : wantLiquids.entrySet()) {
                Integer haveCount = (Integer)haveLiquids.get(entry.getKey());
                if (haveCount != null) {
                    entry.setValue((Integer)entry.getValue() - haveCount);
                }
                for (Map.Entry requestedItem : this._requestedItems.entrySet()) {
                    ItemStack wantItem = ((ItemIdentifier)requestedItem.getKey()).unsafeMakeNormalStack(1);
                    LiquidStack requestedLiquidId = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)wantItem);
                    if (requestedLiquidId == null) continue;
                    entry.setValue((Integer)entry.getValue() - (Integer)requestedItem.getValue() * requestedLiquidId.amount);
                }
            }
            ((PipeItemsLiquidSupplier)this.container.pipe).setRequestFailed(false);
            for (ItemIdentifier itemIdentifier : wantContainers.keySet()) {
                int countToRequest;
                LiquidStack requestedLiquidId = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemIdentifier.unsafeMakeNormalStack(1));
                if (requestedLiquidId == null || !wantLiquids.containsKey(LiquidIdentifier.get(requestedLiquidId)) || (countToRequest = (Integer)wantLiquids.get(LiquidIdentifier.get(requestedLiquidId)) / requestedLiquidId.amount) < 1) continue;
                if (!this._power.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestPartial(itemIdentifier.makeStack(countToRequest), (IRequestItems)this.container.pipe)) > 0) {
                        success = true;
                    }
                } else {
                    boolean bl = success = RequestTree.request(itemIdentifier.makeStack(countToRequest), (IRequestItems)this.container.pipe, null) > 0;
                }
                if (success) {
                    Integer currentRequest = (Integer)this._requestedItems.get(itemIdentifier);
                    if (currentRequest == null) {
                        this._requestedItems.put(itemIdentifier, countToRequest);
                        continue;
                    }
                    this._requestedItems.put(itemIdentifier, currentRequest + countToRequest);
                    continue;
                }
                ((PipeItemsLiquidSupplier)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.stackSize;
        Integer count = (Integer)this._requestedItems.get(item.getItem());
        if (count != null) {
            this._requestedItems.put(item.getItem(), Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry entry : this._requestedItems.entrySet()) {
            if (((ItemIdentifier)entry.getKey()).itemID == item.getItem().itemID && ((ItemIdentifier)entry.getKey()).itemDamage == item.getItem().itemDamage) {
                int expected = (Integer)entry.getValue();
                entry.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        LogisticsPipes.requestLog.info("liquid supplier got unexpected item " + item.toString());
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
        this.decreaseRequested(item);
        this.delayThrottle();
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            entityplayer.openGui((Object)LogisticsPipes.instance, 11, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public SimpleInventory getDummyInventory() {
        return this.dummyInventory;
    }
}

