/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.DelayQueue;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseLogicLiquidSatellite;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.network.packets.GuiArgumentPacket;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketInventoryChange;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BaseLogicCrafting
extends BaseRoutingLogic
implements IRequireReliableTransport {
    protected SimpleInventory _dummyInventory = new SimpleInventory(11, "Requested items", 127);
    protected SimpleInventory _liquidInventory = new SimpleInventory(3, "Liquid items", 1);
    @TileNetworkData(staticSize=3)
    protected int[] amount = new int[3];
    @TileNetworkData(staticSize=3)
    public int[] liquidSatelliteIdArray = new int[3];
    @TileNetworkData
    public int liquidSatelliteId = 0;
    @TileNetworkData
    public int signEntityX = 0;
    @TileNetworkData
    public int signEntityY = 0;
    @TileNetworkData
    public int signEntityZ = 0;
    @TileNetworkData(staticSize=6)
    public boolean[] craftingSigns = new boolean[6];
    protected final DelayQueue _lostItems = new DelayQueue();
    @TileNetworkData
    public int satelliteId = 0;
    @TileNetworkData(staticSize=9)
    public int[] advancedSatelliteIdArray = new int[9];
    @TileNetworkData
    public int priority = 0;
    private PipeItemsCraftingLogistics _pipe = null;

    public BaseLogicCrafting() {
        this.throttleTime = 40;
    }

    protected int getNextConnectSatelliteId(boolean prev, int x) {
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            CoreRoutedPipe satPipe = satellite.getRoutedPipe();
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || satPipe.isLiquidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            ExitRoute route = this.getRoutedPipe().getRouter().getDistanceTo(satRouter);
            if (route == null) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.satelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.satelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.advancedSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.advancedSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.satelliteId;
            }
            return this.advancedSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    protected int getNextConnectLiquidSatelliteId(boolean prev, int x) {
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
            CoreRoutedPipe satPipe = satellite.getRoutedPipe();
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || !satPipe.isLiquidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            ExitRoute route = this.getRoutedPipe().getRouter().getDistanceTo(satRouter);
            if (route == null) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.liquidSatelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.liquidSatelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.liquidSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.liquidSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.liquidSatelliteId;
            }
            return this.liquidSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    public void setNextSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketCoordinates packet = new PacketCoordinates(1, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(false, -1);
            PacketPipeInteger packet = new PacketPipeInteger(3, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setSatelliteId(int satelliteId, int x) {
        if (x == -1) {
            this.satelliteId = satelliteId;
        } else {
            this.advancedSatelliteIdArray[x] = satelliteId;
        }
    }

    public void setPrevSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketCoordinates packet = new PacketCoordinates(2, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(true, -1);
            PacketPipeInteger packet = new PacketPipeInteger(3, this.xCoord, this.yCoord, this.zCoord, this.satelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public boolean isSatelliteConnected() {
        List routes = this.getRoutedPipe().getRouter().getIRoutersByCost();
        if (!((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteId == 0) {
                return true;
            }
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                IRouter satRouter = satPipe.getRouter();
                for (ExitRoute route : routes) {
                    if (route.destination != satRouter) continue;
                    return true;
                }
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                boolean foundOne = false;
                if (this.advancedSatelliteIdArray[i] == 0) continue;
                block3: for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                    CoreRoutedPipe satPipe;
                    if (satellite.satelliteId != this.advancedSatelliteIdArray[i] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                    IRouter satRouter = satPipe.getRouter();
                    for (ExitRoute route : routes) {
                        if (route.destination != satRouter) continue;
                        foundOne = true;
                        continue block3;
                    }
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    public IRouter getSatelliteRouter(int x) {
        if (x == -1) {
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.advancedSatelliteIdArray[x] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this._liquidInventory.readFromNBT(nbttagcompound, "LiquidInv");
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.signEntityX = nbttagcompound.func_74762_e("CraftingSignEntityX");
        this.signEntityY = nbttagcompound.func_74762_e("CraftingSignEntityY");
        this.signEntityZ = nbttagcompound.func_74762_e("CraftingSignEntityZ");
        this.priority = nbttagcompound.func_74762_e("priority");
        for (i = 0; i < 9; ++i) {
            this.advancedSatelliteIdArray[i] = nbttagcompound.func_74762_e("advancedSatelliteId" + i);
        }
        for (i = 0; i < 6; ++i) {
            this.craftingSigns[i] = nbttagcompound.func_74767_n("craftingSigns" + i);
        }
        if (nbttagcompound.func_74764_b("LiquidAmount")) {
            this.amount = nbttagcompound.func_74759_k("LiquidAmount");
        }
        if (this.amount.length < 3) {
            this.amount = new int[3];
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        this.liquidSatelliteId = nbttagcompound.func_74762_e("liquidSatelliteId");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        this._liquidInventory.writeToNBT(nbttagcompound, "LiquidInv");
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        nbttagcompound.func_74768_a("CraftingSignEntityX", this.signEntityX);
        nbttagcompound.func_74768_a("CraftingSignEntityY", this.signEntityY);
        nbttagcompound.func_74768_a("CraftingSignEntityZ", this.signEntityZ);
        nbttagcompound.func_74768_a("priority", this.priority);
        for (i = 0; i < 9; ++i) {
            nbttagcompound.func_74768_a("advancedSatelliteId" + i, this.advancedSatelliteIdArray[i]);
        }
        for (i = 0; i < 6; ++i) {
            nbttagcompound.func_74757_a("craftingSigns" + i, this.craftingSigns[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbttagcompound.func_74768_a("liquidSatelliteIdArray" + i, this.liquidSatelliteIdArray[i]);
        }
        nbttagcompound.func_74783_a("LiquidAmount", this.amount);
        nbttagcompound.func_74768_a("liquidSatelliteId", this.liquidSatelliteId);
    }

    @Override
    public void destroy() {
        if (this.signEntityX != 0 && this.signEntityY != 0 && this.signEntityZ != 0) {
            this.worldObj.func_72921_c(this.signEntityX, this.signEntityY, this.signEntityZ, 0, 1);
            this.signEntityX = 0;
            this.signEntityY = 0;
            this.signEntityZ = 0;
        }
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            MainProxy.sendPacketToPlayer(new GuiArgumentPacket(10, ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter(), ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().getLiquidCrafter(), this.amount, ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().hasByproductExtractor()).getPacket(), (Player)entityplayer);
            entityplayer.openGui((Object)LogisticsPipes.instance, 10, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        while (lostItem != null) {
            SinkReply reply;
            ItemIdentifierStack stack = (ItemIdentifierStack)lostItem.get();
            if (!(this._pipe == null || this._pipe.hasOrder() || (reply = LogisticsManagerV2.canSink(this._pipe.getRouter(), null, true, stack.getItem(), null, true, true)) != null && reply.maxNumberOfItems >= 1)) {
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestTree.requestPartial(stack, (CoreRoutedPipe)this.container.pipe);
            if (received < stack.stackSize) {
                stack.stackSize -= received;
                this._lostItems.add(new DelayedGeneric(stack, 5000L));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this._lostItems.add(new DelayedGeneric(item, 5000L));
    }

    public void openAttachedGui(EntityPlayer player) {
        int i;
        if (MainProxy.isClient(player.field_70170_p)) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71053_j();
            } else if (player instanceof EntityPlayerSP) {
                ((EntityPlayerSP)player).func_71053_j();
            }
            PacketCoordinates packet = new PacketCoordinates(35, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
            return;
        }
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            Block block;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                boolean bl = found = tile.tile instanceof IInventory && !(tile.tile instanceof TileGenericPipe);
            }
            if (!found || (block = this.worldObj.func_72798_a(tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n) < Block.field_71973_m.length ? Block.field_71973_m[this.worldObj.func_72798_a(tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n)] : null) == null || !block.func_71903_a(this.worldObj, tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n, player, 0, 0.0f, 0.0f, 0.0f)) continue;
            break;
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    public void importFromCraftingTable(EntityPlayer player) {
        PacketCoordinates packet;
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            ICraftingRecipeProvider provider;
            Iterator i$ = SimpleServiceLocator.craftingRecipeProviders.iterator();
            while (i$.hasNext() && !(provider = (ICraftingRecipeProvider)i$.next()).importRecipe(tile.tile, this._dummyInventory)) {
            }
        }
        if (player == null) {
            return;
        }
        if (MainProxy.isClient(player.field_70170_p)) {
            packet = new PacketCoordinates(4, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            packet = new PacketInventoryChange(5, this.xCoord, this.yCoord, this.zCoord, this._dummyInventory);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void handleStackMove(int number) {
        ItemStack stack;
        if (MainProxy.isClient(this.worldObj)) {
            MainProxy.sendPacketToServer(new PacketPipeInteger(58, this.xCoord, this.yCoord, this.zCoord, number).getPacket());
        }
        if ((stack = this._dummyInventory.func_70301_a(number)) == null) {
            return;
        }
        for (int i = 6; i < 9; ++i) {
            ItemStack stackb = this._dummyInventory.func_70301_a(i);
            if (stackb != null) continue;
            this._dummyInventory.func_70299_a(i, stack);
            this._dummyInventory.func_70299_a(number, null);
            break;
        }
    }

    public void priorityUp(EntityPlayer player) {
        ++this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(new PacketCoordinates(69, this.xCoord, this.yCoord, this.zCoord).getPacket());
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(68, this.xCoord, this.yCoord, this.zCoord, this.priority).getPacket(), (Player)player);
        }
    }

    public void priorityDown(EntityPlayer player) {
        --this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(new PacketCoordinates(70, this.xCoord, this.yCoord, this.zCoord).getPacket());
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(new PacketPipeInteger(68, this.xCoord, this.yCoord, this.zCoord, this.priority).getPacket(), (Player)player);
        }
    }

    public void setPriority(int amount) {
        this.priority = amount;
    }

    public List getCraftedItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        if (this._dummyInventory.func_70301_a(9) != null) {
            list.add(this._dummyInventory.func_70301_a(9));
        }
        return list;
    }

    public ItemStack getByproductItem() {
        return this._dummyInventory.func_70301_a(10);
    }

    public ItemStack getMaterials(int slotnr) {
        return this._dummyInventory.func_70301_a(slotnr);
    }

    public LiquidIdentifier getLiquidMaterial(int slotnr) {
        ItemStack stack = this._liquidInventory.func_70301_a(slotnr);
        if (stack == null) {
            return null;
        }
        return ItemIdentifier.get(stack).getLiquidIdentifier();
    }

    public SimpleInventory getDummyInventory() {
        return this._dummyInventory;
    }

    public SimpleInventory getLiquidInventory() {
        return this._liquidInventory;
    }

    public void setDummyInventorySlot(int slot, ItemStack itemstack) {
        this._dummyInventory.func_70299_a(slot, itemstack);
    }

    public void setNextSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketPipeInteger packet = new PacketPipeInteger(98, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(false, i);
            PacketModuleInteger packet = new PacketModuleInteger(100, this.xCoord, this.yCoord, this.zCoord, i, this.advancedSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setPrevSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketPipeInteger packet = new PacketPipeInteger(99, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(true, i);
            PacketModuleInteger packet = new PacketModuleInteger(100, this.xCoord, this.yCoord, this.zCoord, i, this.advancedSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setParentPipe(PipeItemsCraftingLogistics pipeItemsCraftingLogistics) {
        this._pipe = pipeItemsCraftingLogistics;
    }

    public void changeLiquidAmount(int change, int slot, EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketModuleInteger packet = new PacketModuleInteger(112, this.xCoord, this.yCoord, this.zCoord, slot, change);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else {
            int n = slot;
            this.amount[n] = this.amount[n] + change;
            if (this.amount[slot] <= 0) {
                this.amount[slot] = 0;
            }
            PacketModuleInteger packet = new PacketModuleInteger(112, this.xCoord, this.yCoord, this.zCoord, slot, this.amount[slot]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setPrevLiquidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketPipeInteger packet = new PacketPipeInteger(110, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectLiquidSatelliteId(true, i);
            PacketModuleInteger packet = new PacketModuleInteger(111, this.xCoord, this.yCoord, this.zCoord, i, this.liquidSatelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectLiquidSatelliteId(true, i);
            PacketModuleInteger packet = new PacketModuleInteger(111, this.xCoord, this.yCoord, this.zCoord, i, this.liquidSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setNextLiquidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            PacketPipeInteger packet = new PacketPipeInteger(109, this.xCoord, this.yCoord, this.zCoord, i);
            MainProxy.sendPacketToServer(packet.getPacket());
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectLiquidSatelliteId(false, i);
            PacketModuleInteger packet = new PacketModuleInteger(111, this.xCoord, this.yCoord, this.zCoord, i, this.liquidSatelliteId);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectLiquidSatelliteId(false, i);
            PacketModuleInteger packet = new PacketModuleInteger(111, this.xCoord, this.yCoord, this.zCoord, i, this.liquidSatelliteIdArray[i]);
            MainProxy.sendPacketToPlayer(packet.getPacket(), (Player)player);
        }
    }

    public void setLiquidAmount(int[] amount) {
        if (MainProxy.isClient(this.worldObj)) {
            this.amount = amount;
        }
    }

    public void defineLiquidAmount(int integer, int slot) {
        if (MainProxy.isClient(this.worldObj)) {
            this.amount[slot] = integer;
        }
    }

    public int[] getLiquidAmount() {
        return this.amount;
    }

    public void setLiquidSatelliteId(int integer, int slot) {
        if (slot == -1) {
            this.liquidSatelliteId = integer;
        } else {
            this.liquidSatelliteIdArray[slot] = integer;
        }
    }

    public IRouter getLiquidSatelliteRouter(int x) {
        if (x == -1) {
            for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.liquidSatelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.liquidSatelliteIdArray[x] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }
}

