/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.config.Configs;
import logisticspipes.gui.hud.HUDPowerJunction;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class LogisticsPowerJuntionTileEntity_BuildCraft
extends TileEntity
implements IPowerReceptor,
ILogisticsPowerProvider,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler {
    public boolean needMorePowerTriggerCheck = true;
    public final int BuildCraftMultiplier = 5;
    public final int MAX_STORAGE = 2000000;
    private IPowerProvider powerFramework;
    private List guiListener = new ArrayList();
    private int internalStorage = 0;
    private int lastUpdateStorage = 0;
    private boolean init = false;
    private List watcherList = new ArrayList();
    private IHeadUpDisplayRenderer HUD;

    public LogisticsPowerJuntionTileEntity_BuildCraft() {
        this.powerFramework = PowerFramework.currentFramework.createPowerProvider();
        this.powerFramework.configure(0, 1, 250, 1, 750);
        this.HUD = new HUDPowerJunction(this);
    }

    @Override
    public boolean useEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        if (this.canUseEnergy(amount, null)) {
            this.internalStorage -= amount * Configs.POWER_USAGE_MULTIPLIER;
            if (this.internalStorage < 1000000) {
                this.needMorePowerTriggerCheck = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        return this.internalStorage >= amount * Configs.POWER_USAGE_MULTIPLIER;
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null);
    }

    public int freeSpace() {
        return 2000000 - this.internalStorage;
    }

    public void updateClients() {
        MainProxy.sendToPlayerList(new PacketPipeInteger(71, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.internalStorage).getPacket(), this.guiListener);
        MainProxy.sendToPlayerList(new PacketPipeInteger(71, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.internalStorage).getPacket(), this.watcherList);
        this.lastUpdateStorage = this.internalStorage;
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    public void addEnergy(float amount) {
        this.internalStorage = (int)((float)this.internalStorage + amount);
        if (this.internalStorage > 2000000) {
            this.internalStorage = 2000000;
        }
        if (this.internalStorage == 2000000) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.internalStorage = par1nbtTagCompound.func_74762_e("powerLevel");
        if (par1nbtTagCompound.func_74764_b("needMorePowerTriggerCheck")) {
            this.needMorePowerTriggerCheck = par1nbtTagCompound.func_74767_n("needMorePowerTriggerCheck");
        }
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("powerLevel", this.internalStorage);
        par1nbtTagCompound.func_74757_a("needMorePowerTriggerCheck", this.needMorePowerTriggerCheck);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (MainProxy.isServer(this.field_70331_k)) {
            float energy = Math.min(this.powerFramework.getEnergyStored(), (float)(this.freeSpace() / 5));
            if (this.freeSpace() > 0 && energy == 0.0f && this.powerFramework.getEnergyStored() > 0.0f) {
                energy = 1.0f;
            }
            if (this.powerFramework.useEnergy(energy, energy, false) == energy) {
                this.powerFramework.useEnergy(energy, energy, true);
                this.addEnergy(energy * 5.0f);
            }
            if (this.internalStorage != this.lastUpdateStorage) {
                this.updateClients();
            }
        }
        if (!this.init) {
            if (MainProxy.isClient(this.field_70331_k)) {
                LogisticsHUDRenderer.instance().add(this);
            }
            this.init = true;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (MainProxy.isClient(this.field_70331_k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (MainProxy.isClient(this.field_70331_k)) {
            this.init = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.field_70331_k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
    }

    public void setPowerProvider(IPowerProvider provider) {
        this.powerFramework = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerFramework;
    }

    public void doWork() {
    }

    public int powerRequest(ForgeDirection from) {
        return Math.min(this.powerFramework.getMaxEnergyReceived(), this.freeSpace() / 5);
    }

    @Override
    public int getPowerLevel() {
        return this.internalStorage;
    }

    public int getChargeState() {
        return this.internalStorage * 100 / 2000000;
    }

    public Container createContainer(EntityPlayer player) {
        DummyContainer dummy = new DummyContainer(player, null, this);
        dummy.addNormalSlotsForPlayerInventory(8, 80);
        return dummy;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiListener.remove(player);
    }

    public void handlePowerPacket(PacketPipeInteger packet) {
        if (MainProxy.isClient(this.field_70331_k)) {
            this.internalStorage = packet.integer;
        }
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.field_70329_l;
    }

    @Override
    public int getY() {
        return this.field_70330_m;
    }

    @Override
    public int getZ() {
        return this.field_70327_n;
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketCoordinates(72, this.field_70329_l, this.field_70330_m, this.field_70327_n).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketCoordinates(73, this.field_70329_l, this.field_70330_m, this.field_70327_n).getPacket());
    }

    @Override
    public void playerStartWatching(EntityPlayer player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(EntityPlayer player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isExistend() {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_85027_a(CrashReportCategory par1CrashReportCategory) {
        super.func_85027_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.7.3.7:false");
    }
}

