/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.LogisticsSolderingTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJuntionTileEntity_BuildCraft;
import logisticspipes.interfaces.IRotationProvider;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LogisticsSolidBlock
extends BlockContainer {
    public static final int SOLDERING_STATION = 0;
    public static final int LOGISTICS_POWER_JUNCTION = 1;
    public static final int LOGISTICS_SECURITY_STATION = 2;
    private static final Icon[] icons = new Icon[10];

    public LogisticsSolidBlock(int par1) {
        super(par1, Material.field_76243_f);
        this.func_71849_a(CreativeTabs.field_78030_b);
        this.func_71848_c(6.0f);
    }

    public void func_71921_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        super.func_71921_a(par1World, par2, par3, par4, par5EntityPlayer);
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (!par5EntityPlayer.func_70093_af()) {
            switch (par1World.func_72805_g(par2, par3, par4)) {
                case 0: {
                    par5EntityPlayer.openGui((Object)LogisticsPipes.instance, 50, par1World, par2, par3, par4);
                    return true;
                }
                case 1: {
                    par5EntityPlayer.openGui((Object)LogisticsPipes.instance, 51, par1World, par2, par3, par4);
                    return true;
                }
                case 2: {
                    par5EntityPlayer.openGui((Object)LogisticsPipes.instance, 52, par1World, par2, par3, par4);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving, ItemStack itemStack) {
        super.func_71860_a(par1World, par2, par3, par4, par5EntityLiving, itemStack);
        TileEntity tile = par1World.func_72796_p(par2, par3, par4);
        if (tile instanceof IRotationProvider) {
            double x = (double)tile.field_70329_l - par5EntityLiving.field_70165_t;
            double z = (double)tile.field_70327_n - par5EntityLiving.field_70161_v;
            double w = Math.atan2(x, z);
            double halfPI = 1.5707963267948966;
            double halfhalfPI = halfPI / 2.0;
            if ((w -= halfhalfPI) < 0.0) {
                w += Math.PI * 2;
            }
            if (0.0 < w && w <= halfPI) {
                ((IRotationProvider)tile).setRotation(1);
            } else if (halfPI < w && w <= 2.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(2);
            } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(0);
            } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
                ((IRotationProvider)tile).setRotation(3);
            }
        }
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntity tile = par1World.func_72796_p(par2, par3, par4);
        if (tile instanceof LogisticsSolderingTileEntity) {
            ((LogisticsSolderingTileEntity)tile).onBlockBreak();
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    public Icon func_71858_a(int side, int meta) {
        return this.getRotatedTexture(meta, side, 2, 0);
    }

    public TileEntity func_72274_a(World var1) {
        new UnsupportedOperationException("Please call createNewTileEntity(World,int) instead of createNewTileEntity(World).").printStackTrace();
        return this.createTileEntity(var1, 0);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new LogisticsSolderingTileEntity();
            }
            case 1: {
                LogisticsPowerJuntionTileEntity_BuildCraft instance;
                try {
                    instance = (LogisticsPowerJuntionTileEntity_BuildCraft)LogisticsPipes.powerTileEntity.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    instance = new LogisticsPowerJuntionTileEntity_BuildCraft();
                }
                return instance;
            }
            case 2: {
                return new LogisticsSecurityTileEntity();
            }
        }
        return null;
    }

    public int func_71899_b(int par1) {
        switch (par1) {
            case 0: 
            case 1: 
            case 2: {
                return par1;
            }
        }
        return super.func_71899_b(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        TileEntity tile = access.func_72796_p(x, y, z);
        if (tile instanceof IRotationProvider) {
            return this.getRotatedTexture(meta, side, ((IRotationProvider)tile).getRotation(), ((IRotationProvider)tile).getFrontTexture());
        }
        return this.getRotatedTexture(meta, side, 3, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        for (int i = 0; i < 10; ++i) {
            LogisticsSolidBlock.icons[i] = par1IconRegister.func_94245_a("logisticspipes:lpsolidblock/" + i);
        }
    }

    private Icon getRotatedTexture(int meta, int side, int rotation, int front) {
        switch (meta) {
            case 0: {
                if (front == 0) {
                    front = 8;
                }
                switch (side) {
                    case 1: {
                        return icons[1];
                    }
                    case 0: {
                        return icons[2];
                    }
                    case 2: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 3: 
                        }
                        return icons[front];
                    }
                    case 3: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 2: 
                        }
                        return icons[front];
                    }
                    case 4: {
                        switch (rotation) {
                            default: {
                                return icons[7];
                            }
                            case 1: 
                        }
                        return icons[front];
                    }
                    case 5: {
                        switch (rotation) {
                            case 0: {
                                return icons[front];
                            }
                        }
                        return icons[7];
                    }
                }
                return icons[0];
            }
            case 1: {
                switch (side) {
                    case 1: {
                        return icons[4];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
            case 2: {
                switch (side) {
                    case 1: {
                        return icons[9];
                    }
                    case 0: {
                        return icons[5];
                    }
                }
                return icons[6];
            }
        }
        return icons[0];
    }
}

