/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.ISecurityProvider;
import logisticspipes.network.packets.PacketCoordinatesUUID;
import logisticspipes.network.packets.PacketNBT;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.security.SecuritySettings;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class LogisticsSecurityTileEntity
extends TileEntity
implements IGuiOpenControler,
ISecurityProvider {
    public SimpleInventory inv = new SimpleInventory(1, "ID Slots", 64);
    private List listener = new ArrayList();
    private UUID secId = null;
    private Map settingsList = new HashMap();
    public List excludedCC = new ArrayList();
    public boolean allowCC = false;
    public boolean allowAutoDestroy = false;

    public void func_70313_j() {
        super.func_70313_j();
        if (MainProxy.isServer(this.field_70331_k)) {
            SimpleServiceLocator.securityStationManager.remove(this);
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (MainProxy.isServer(this.field_70331_k)) {
            SimpleServiceLocator.securityStationManager.add(this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isServer(this.field_70331_k)) {
            SimpleServiceLocator.securityStationManager.remove(this);
        }
    }

    public void deauthorizeStation() {
        SimpleServiceLocator.securityStationManager.deauthorizeUUID(this.getSecId());
    }

    public void authorizeStation() {
        SimpleServiceLocator.securityStationManager.authorizeUUID(this.getSecId());
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(new PacketPipeInteger(96, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.allowCC ? 1 : 0).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketPipeInteger(108, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.allowAutoDestroy ? 1 : 0).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketCoordinatesUUID(93, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getSecId()).getPacket(), (Player)player);
        SimpleServiceLocator.securityStationManager.sendClientAuthorizationList();
        this.listener.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.listener.remove(player);
    }

    public UUID getSecId() {
        if (MainProxy.isServer(this.field_70331_k) && this.secId == null) {
            this.secId = UUID.randomUUID();
        }
        return this.secId;
    }

    public void setClientUUID(UUID id) {
        if (MainProxy.isClient(this.field_70331_k)) {
            this.secId = id;
        }
    }

    public void setClientCC(boolean flag) {
        if (MainProxy.isClient(this.field_70331_k)) {
            this.allowCC = flag;
        }
    }

    public void setClientDestroy(boolean flag) {
        if (MainProxy.isClient(this.field_70331_k)) {
            this.allowAutoDestroy = flag;
        }
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        NBTBase base;
        super.func_70307_a(par1nbtTagCompound);
        if (par1nbtTagCompound.func_74764_b("UUID")) {
            this.secId = UUID.fromString(par1nbtTagCompound.func_74779_i("UUID"));
        }
        this.allowCC = par1nbtTagCompound.func_74767_n("allowCC");
        this.allowAutoDestroy = par1nbtTagCompound.func_74767_n("allowAutoDestroy");
        this.inv.readFromNBT(par1nbtTagCompound);
        this.settingsList.clear();
        NBTTagList list = par1nbtTagCompound.func_74761_m("settings");
        while (list.func_74745_c() > 0) {
            base = list.func_74744_a(0);
            String name = ((NBTTagCompound)base).func_74779_i("name");
            NBTTagCompound value = ((NBTTagCompound)base).func_74775_l("content");
            SecuritySettings settings = new SecuritySettings(name);
            settings.readFromNBT(value);
            this.settingsList.put(name, settings);
        }
        this.excludedCC.clear();
        list = par1nbtTagCompound.func_74761_m("excludedCC");
        while (list.func_74745_c() > 0) {
            base = list.func_74744_a(0);
            this.excludedCC.add(((NBTTagInt)base).field_74748_a);
        }
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74778_a("UUID", this.getSecId().toString());
        par1nbtTagCompound.func_74757_a("allowCC", this.allowCC);
        par1nbtTagCompound.func_74757_a("allowAutoDestroy", this.allowAutoDestroy);
        this.inv.writeToNBT(par1nbtTagCompound);
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : this.settingsList.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", (String)entry.getKey());
            NBTTagCompound value = new NBTTagCompound();
            ((SecuritySettings)entry.getValue()).writeToNBT(value);
            nbt.func_74766_a("content", value);
            list.func_74742_a((NBTBase)nbt);
        }
        par1nbtTagCompound.func_74782_a("settings", (NBTBase)list);
        list = new NBTTagList();
        int count = 0;
        for (Integer i : this.excludedCC) {
            list.func_74742_a((NBTBase)new NBTTagInt("Part: " + count++, i.intValue()));
        }
        par1nbtTagCompound.func_74782_a("excludedCC", (NBTBase)list);
    }

    public void buttonFreqCard(int integer, EntityPlayer player) {
        switch (integer) {
            case 0: {
                this.inv.func_70299_a(0, null);
                break;
            }
            case 1: {
                if (this.inv.func_70301_a(0) == null) {
                    return;
                }
                --this.inv.func_70301_a((int)0).field_77994_a;
                if (this.inv.func_70301_a((int)0).field_77994_a > 0) break;
                this.inv.func_70299_a(0, null);
                break;
            }
            case 2: {
                if (!this.useEnergy(10)) {
                    player.func_70006_a("No Energy");
                    return;
                }
                if (this.inv.func_70301_a(0) == null) {
                    ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 1, 1);
                    stack.func_77982_d(new NBTTagCompound("tag"));
                    stack.func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                    this.inv.func_70299_a(0, stack);
                    break;
                }
                if (this.inv.func_70301_a((int)0).field_77994_a >= 64) break;
                ++this.inv.func_70301_a((int)0).field_77994_a;
                this.inv.func_70301_a(0).func_77982_d(new NBTTagCompound("tag"));
                this.inv.func_70301_a(0).func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                break;
            }
            case 3: {
                if (!this.useEnergy(640)) {
                    player.func_70006_a("No Energy");
                    return;
                }
                ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 64, 1);
                stack.func_77982_d(new NBTTagCompound("tag"));
                stack.func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                this.inv.func_70299_a(0, stack);
            }
        }
    }

    public void handleOpenSecurityPlayer(EntityPlayerMP player, String string) {
        SecuritySettings setting = (SecuritySettings)this.settingsList.get(string);
        if (setting == null && string != "" && string != null) {
            setting = new SecuritySettings(string);
            this.settingsList.put(string, setting);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        setting.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(new PacketNBT(94, nbt).getPacket(), (Player)player);
    }

    public void saveNewSecuritySettings(NBTTagCompound tag) {
        SecuritySettings setting = (SecuritySettings)this.settingsList.get(tag.func_74779_i("name"));
        if (setting == null) {
            setting = new SecuritySettings(tag.func_74779_i("name"));
            this.settingsList.put(tag.func_74779_i("name"), setting);
        }
        setting.readFromNBT(tag);
    }

    public SecuritySettings getSecuritySettingsForPlayer(EntityPlayer entityplayer, boolean usePower) {
        if (usePower && !this.useEnergy(10)) {
            entityplayer.func_70006_a("No Energy");
            return new SecuritySettings("No Energy");
        }
        SecuritySettings setting = (SecuritySettings)this.settingsList.get(entityplayer.field_71092_bJ);
        if (setting == null) {
            setting = new SecuritySettings(entityplayer.field_71092_bJ);
            this.settingsList.put(entityplayer.field_71092_bJ, setting);
        }
        return setting;
    }

    public void changeCC() {
        this.allowCC = !this.allowCC;
        MainProxy.sendToPlayerList(new PacketPipeInteger(96, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.allowCC ? 1 : 0).getPacket(), this.listener);
    }

    public void changeDestroy() {
        this.allowAutoDestroy = !this.allowAutoDestroy;
        MainProxy.sendToPlayerList(new PacketPipeInteger(108, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.allowAutoDestroy ? 1 : 0).getPacket(), this.listener);
    }

    public void addCCToList(Integer id) {
        if (!this.excludedCC.contains(id)) {
            this.excludedCC.add(id);
        }
        Collections.sort(this.excludedCC);
    }

    public void removeCCFromList(Integer id) {
        this.excludedCC.remove(id);
    }

    public void requestList(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Integer i : this.excludedCC) {
            list.func_74742_a((NBTBase)new NBTTagInt("" + i, i.intValue()));
        }
        tag.func_74782_a("list", (NBTBase)list);
        MainProxy.sendPacketToPlayer(new PacketNBT(107, this.field_70329_l, this.field_70330_m, this.field_70327_n, tag).getPacket(), (Player)player);
    }

    public void handleListPacket(PacketNBT packet) {
        this.excludedCC.clear();
        NBTTagList list = packet.tag.func_74761_m("list");
        while (list.func_74745_c() > 0) {
            NBTBase base = list.func_74744_a(0);
            this.excludedCC.add(((NBTTagInt)base).field_74748_a);
        }
    }

    @Override
    public boolean getAllowCC(int id) {
        if (!this.useEnergy(10)) {
            return false;
        }
        return this.allowCC != this.excludedCC.contains(id);
    }

    @Override
    public boolean canAutomatedDestroy() {
        if (!this.useEnergy(10)) {
            return false;
        }
        return this.allowAutoDestroy;
    }

    private boolean useEnergy(int amount) {
        for (int i = 0; i < 4; ++i) {
            Position pos = new Position((TileEntity)this);
            pos.orientation = ForgeDirection.VALID_DIRECTIONS[i + 2];
            pos.moveForwards(1.0);
            TileEntity tile = this.field_70331_k.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile instanceof IRoutedPowerProvider && ((IRoutedPowerProvider)tile).useEnergy(amount)) {
                return true;
            }
            if (!(tile instanceof TileGenericPipe) || !(((TileGenericPipe)tile).pipe instanceof IRoutedPowerProvider) || !((IRoutedPowerProvider)((TileGenericPipe)tile).pipe).useEnergy(amount)) continue;
            return true;
        }
        return false;
    }

    public void func_85027_a(CrashReportCategory par1CrashReportCategory) {
        super.func_85027_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.7.3.7:false");
    }
}

