/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.liquid.LiquidRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.ITransposerManager;
import thermalexpansion.api.crafting.ITransposerRecipe;

public class TransposerManager
implements ITransposerManager {
    private static TransposerManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMapFill;
    private static Map recipeMapExtraction;
    private static List recipeListFill;
    private static List recipeListExtraction;
    private static Set validationSet;
    private static int defaultProcessEnergy;

    public static ITransposerManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static TransposerRecipe getFillRecipe(ItemStack input, LiquidStack liquid) {
        if (input == null || liquid == null) {
            return null;
        }
        return (TransposerRecipe)recipeMapFill.get(Arrays.asList(input.field_77993_c, input.func_77960_j(), liquid.itemID, liquid.itemMeta));
    }

    public static TransposerRecipe getExtractionRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return (TransposerRecipe)recipeMapExtraction.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static boolean fillRecipeExists(ItemStack input, LiquidStack liquid) {
        if (input == null || liquid == null) {
            return true;
        }
        TransposerRecipe recipe = (TransposerRecipe)recipeMapFill.get(Arrays.asList(input.field_77993_c, input.func_77960_j(), liquid.itemID, liquid.itemMeta));
        return recipe != null;
    }

    public static boolean extractionRecipeExists(ItemStack input, LiquidStack liquid) {
        if (input == null || liquid == null) {
            return true;
        }
        TransposerRecipe recipe = (TransposerRecipe)recipeMapExtraction.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        return recipe != null;
    }

    public static boolean isItemValid(ItemStack input) {
        if (input == null) {
            return false;
        }
        return validationSet.contains(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static void initialize() {
        CraftingManagers.transposerManager = new TransposerManager();
        TransposerManager.getInstance().addFillRecipe(800, new ItemStack(Block.field_71978_w), new ItemStack(Block.field_72087_ao), new LiquidStack(LiquidRegistry.WATER_ID, 250), false, false);
        TransposerManager.getInstance().addFillRecipe(800, new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 1), new LiquidStack(LiquidRegistry.WATER_ID, 250), false, false);
    }

    public static void loadRecipes() {
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (LiquidContainerRegistry.isBucket((ItemStack)data.container)) {
                TransposerManager.addFillRecipe(80, data, true);
                continue;
            }
            TransposerManager.addFillRecipe(160, data, true);
        }
    }

    public static void addRecipe(ItemStack input, ItemStack output, LiquidStack liquid) {
        TransposerManager.getInstance().addFillRecipe(defaultProcessEnergy, input, output, liquid, true, false);
    }

    public static boolean addFillRecipe(int energy, LiquidContainerData data, boolean reversible) {
        ItemStack input = data.container;
        ItemStack output = data.filled;
        LiquidStack liquid = data.stillLiquid;
        return TransposerManager.getInstance().addFillRecipe(energy, input, output, liquid, reversible, false);
    }

    public static boolean addTEFillRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, boolean reversible) {
        return instance.addInternalFillRecipe(energy, input, output, liquid, reversible);
    }

    public static boolean addTEExtractionRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, int chance, boolean reversible) {
        return instance.addInternalExtractionRecipe(energy, input, output, liquid, chance, reversible);
    }

    private boolean addInternalFillRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, boolean reversible) {
        if (input == null || output == null || liquid == null || liquid.amount <= 0 || energy <= 0) {
            return false;
        }
        if (TransposerManager.fillRecipeExists(input, liquid)) {
            TransposerRecipe recipe = TransposerManager.getFillRecipe(input, liquid);
            recipeListFill.remove(recipe);
        }
        TransposerRecipe recipeFill = new TransposerRecipe(input, output, liquid, energy, 100);
        recipeMapFill.put(Arrays.asList(input.field_77993_c, input.func_77960_j(), liquid.itemID, liquid.itemMeta), recipeFill);
        recipeListFill.add(recipeFill);
        validationSet.add(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (reversible) {
            TransposerManager.addTEExtractionRecipe(energy, output, input, liquid, 100, false);
        }
        return true;
    }

    private boolean addInternalExtractionRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, int chance, boolean reversible) {
        if (input == null || liquid == null || liquid.amount <= 0 || energy <= 0) {
            return false;
        }
        if (output == null && reversible) {
            return false;
        }
        if (output == null && chance != 0) {
            return false;
        }
        if (TransposerManager.extractionRecipeExists(input, liquid)) {
            TransposerRecipe recipe = TransposerManager.getExtractionRecipe(input);
            recipeListExtraction.remove(recipe);
        }
        TransposerRecipe recipeExtraction = new TransposerRecipe(input, output, liquid, energy, chance);
        recipeMapExtraction.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipeExtraction);
        recipeListExtraction.add(recipeExtraction);
        validationSet.add(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (reversible) {
            TransposerManager.addTEFillRecipe(energy, output, input, liquid, false);
        }
        return true;
    }

    @Override
    public boolean addFillRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, boolean reversible, boolean overwrite) {
        if (input == null || output == null || liquid == null || liquid.amount <= 0 || energy <= 0) {
            return false;
        }
        if (TransposerManager.fillRecipeExists(input, liquid)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                TransposerRecipe recipe = TransposerManager.getFillRecipe(input, liquid);
                recipeListFill.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Transposer recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Transposer recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        TransposerRecipe recipeFill = new TransposerRecipe(input, output, liquid, energy, 100);
        recipeMapFill.put(Arrays.asList(input.field_77993_c, input.func_77960_j(), liquid.itemID, liquid.itemMeta), recipeFill);
        recipeListFill.add(recipeFill);
        validationSet.add(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (reversible) {
            this.addExtractionRecipe(energy, output, input, liquid, 100, false, overwrite);
        }
        return true;
    }

    @Override
    public boolean addFillRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, boolean reversible) {
        return this.addFillRecipe(energy, input, output, liquid, reversible, false);
    }

    @Override
    public boolean addExtractionRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, int chance, boolean reversible, boolean overwrite) {
        if (input == null || liquid == null || liquid.amount <= 0 || energy <= 0) {
            return false;
        }
        if (output == null && reversible) {
            return false;
        }
        if (output == null && chance != 0) {
            return false;
        }
        if (TransposerManager.extractionRecipeExists(input, liquid)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                TransposerRecipe recipe = TransposerManager.getExtractionRecipe(input);
                recipeListExtraction.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Transposer recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Transposer recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        TransposerRecipe recipeExtraction = new TransposerRecipe(input, output, liquid, energy, chance);
        recipeMapExtraction.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipeExtraction);
        recipeListExtraction.add(recipeExtraction);
        validationSet.add(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (reversible) {
            this.addFillRecipe(energy, output, input, liquid, false, overwrite);
        }
        return true;
    }

    @Override
    public boolean addExtractionRecipe(int energy, ItemStack input, ItemStack output, LiquidStack liquid, int chance, boolean reversible) {
        return this.addExtractionRecipe(energy, input, output, liquid, chance, reversible, false);
    }

    @Override
    public ITransposerRecipe[] getFillRecipeList() {
        return recipeListFill.toArray(new TransposerRecipe[0]);
    }

    @Override
    public ITransposerRecipe[] getExtractionRecipeList() {
        return recipeListExtraction.toArray(new TransposerRecipe[0]);
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Transposer.Override", false)) {
            TransposerManager.allowOverwrite();
        } else {
            TransposerManager.denyOverwrite();
        }
        instance = new TransposerManager();
        recipeMapFill = new HashMap();
        recipeMapExtraction = new HashMap();
        recipeListFill = new ArrayList();
        recipeListExtraction = new ArrayList();
        validationSet = new HashSet();
        defaultProcessEnergy = 80;
    }

    public class TransposerRecipe
    implements ITransposerRecipe {
        final ItemStack input;
        final ItemStack output;
        final LiquidStack liquid;
        final int energy;
        final int chance;

        TransposerRecipe(ItemStack input, ItemStack output, LiquidStack liquid, int energy, int chance) {
            this.input = input;
            this.output = output;
            this.liquid = liquid;
            this.energy = energy;
            this.chance = chance;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output != null) {
                return this.output.func_77946_l();
            }
            return null;
        }

        @Override
        public LiquidStack getLiquid() {
            return this.liquid.copy();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }

        @Override
        public int getChance() {
            return this.chance;
        }
    }
}

